// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-avr.go from ATtiny828.atdf, see http://packs.download.atmel.com/

//go:build avr && attiny828

// Device information for the ATtiny828.
package avr

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "ATtiny828"
	ARCH   = "AVR8"
	FAMILY = "tinyAVR"
)

// Interrupts
const (
	IRQ_RESET        = 0  // External Pin, Power-on Reset, Brown-out Reset and Watchdog Reset
	IRQ_INT0         = 1  // External Interrupt Request 0
	IRQ_INT1         = 2  // External Interrupt Request 1
	IRQ_PCINT0       = 3  // Pin Change Interrupt Request 0
	IRQ_PCINT1       = 4  // Pin Change Interrupt Request 1
	IRQ_PCINT2       = 5  // Pin Change Interrupt Request 2
	IRQ_PCINT3       = 6  // Pin Change Interrupt Request 3
	IRQ_WDT          = 7  // Watchdog Time-out Interrupt
	IRQ_TIMER1_CAPT  = 8  // Timer/Counter1 Capture Event
	IRQ_TIMER1_COMPA = 9  // Timer/Counter1 Compare Match A
	IRQ_TIMER1_COMPB = 10 // Timer/Counter1 Compare Match B
	IRQ_TIMER1_OVF   = 11 // Timer/Counter1 Overflow
	IRQ_TIMER0_COMPA = 12 // Timer/Counter0 Compare Match A
	IRQ_TIMER0_COMPB = 13 // Timer/Counter0 Compare Match B
	IRQ_TIMER0_OVF   = 14 // Timer/Counter0 Overflow
	IRQ_SPI_STC      = 15 // SPI Serial Transfer Complete
	IRQ_USART_START  = 16 // USART, Start
	IRQ_USART_RX     = 17 // USART Rx Complete
	IRQ_USART_UDRE   = 18 // USART, Data Register Empty
	IRQ_USART_TX     = 19 // USART Tx Complete
	IRQ_ADC          = 20 // ADC Conversion Complete
	IRQ_EE_READY     = 21 // EEPROM Ready
	IRQ_ANALOG_COMP  = 22 // Analog Comparator
	IRQ_TWI_SLAVE    = 23 // Two-wire Serial Interface
	IRQ_SPM_Ready    = 24 // Store Program Memory Read
	IRQ_QTRIP        = 25 // Touch Sensing
	IRQ_max          = 25 // Highest interrupt number on this device.
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export __vector_RESET
//go:interrupt
func interruptRESET() {
	callHandlers(IRQ_RESET)
}

//export __vector_INT0
//go:interrupt
func interruptINT0() {
	callHandlers(IRQ_INT0)
}

//export __vector_INT1
//go:interrupt
func interruptINT1() {
	callHandlers(IRQ_INT1)
}

//export __vector_PCINT0
//go:interrupt
func interruptPCINT0() {
	callHandlers(IRQ_PCINT0)
}

//export __vector_PCINT1
//go:interrupt
func interruptPCINT1() {
	callHandlers(IRQ_PCINT1)
}

//export __vector_PCINT2
//go:interrupt
func interruptPCINT2() {
	callHandlers(IRQ_PCINT2)
}

//export __vector_PCINT3
//go:interrupt
func interruptPCINT3() {
	callHandlers(IRQ_PCINT3)
}

//export __vector_WDT
//go:interrupt
func interruptWDT() {
	callHandlers(IRQ_WDT)
}

//export __vector_TIMER1_CAPT
//go:interrupt
func interruptTIMER1_CAPT() {
	callHandlers(IRQ_TIMER1_CAPT)
}

//export __vector_TIMER1_COMPA
//go:interrupt
func interruptTIMER1_COMPA() {
	callHandlers(IRQ_TIMER1_COMPA)
}

//export __vector_TIMER1_COMPB
//go:interrupt
func interruptTIMER1_COMPB() {
	callHandlers(IRQ_TIMER1_COMPB)
}

//export __vector_TIMER1_OVF
//go:interrupt
func interruptTIMER1_OVF() {
	callHandlers(IRQ_TIMER1_OVF)
}

//export __vector_TIMER0_COMPA
//go:interrupt
func interruptTIMER0_COMPA() {
	callHandlers(IRQ_TIMER0_COMPA)
}

//export __vector_TIMER0_COMPB
//go:interrupt
func interruptTIMER0_COMPB() {
	callHandlers(IRQ_TIMER0_COMPB)
}

//export __vector_TIMER0_OVF
//go:interrupt
func interruptTIMER0_OVF() {
	callHandlers(IRQ_TIMER0_OVF)
}

//export __vector_SPI_STC
//go:interrupt
func interruptSPI_STC() {
	callHandlers(IRQ_SPI_STC)
}

//export __vector_USART_START
//go:interrupt
func interruptUSART_START() {
	callHandlers(IRQ_USART_START)
}

//export __vector_USART_RX
//go:interrupt
func interruptUSART_RX() {
	callHandlers(IRQ_USART_RX)
}

//export __vector_USART_UDRE
//go:interrupt
func interruptUSART_UDRE() {
	callHandlers(IRQ_USART_UDRE)
}

//export __vector_USART_TX
//go:interrupt
func interruptUSART_TX() {
	callHandlers(IRQ_USART_TX)
}

//export __vector_ADC
//go:interrupt
func interruptADC() {
	callHandlers(IRQ_ADC)
}

//export __vector_EE_READY
//go:interrupt
func interruptEE_READY() {
	callHandlers(IRQ_EE_READY)
}

//export __vector_ANALOG_COMP
//go:interrupt
func interruptANALOG_COMP() {
	callHandlers(IRQ_ANALOG_COMP)
}

//export __vector_TWI_SLAVE
//go:interrupt
func interruptTWI_SLAVE() {
	callHandlers(IRQ_TWI_SLAVE)
}

//export __vector_SPM_Ready
//go:interrupt
func interruptSPM_Ready() {
	callHandlers(IRQ_SPM_Ready)
}

//export __vector_QTRIP
//go:interrupt
func interruptQTRIP() {
	callHandlers(IRQ_QTRIP)
}

// Peripherals.
var (
	// Serial Peripheral Interface
	SPDR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4e)))
	SPSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4d)))
	SPCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4c)))

	// I/O Port
	PUEA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x23)))
	PORTA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x22)))
	DDRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x21)))
	PINA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x20)))

	// I/O Port
	PUEB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x27)))
	PORTB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x26)))
	DDRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x25)))
	PINB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x24)))

	// I/O Port
	PHDE  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x34)))
	PUEC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2b)))
	PORTC = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2a)))
	DDRC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x29)))
	PINC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x28)))

	// I/O Port
	PUED  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2f)))
	PORTD = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2e)))
	DDRD  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2d)))
	PIND  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2c)))

	// CPU Registers
	PRR       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x64)))
	CCP       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x56)))
	CLKPR     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x61)))
	SREG      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5f)))
	SPL       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5d)))
	SPH       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5e)))
	MCUCR     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x55)))
	MCUSR     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x54)))
	GPIOR2    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4b)))
	GPIOR1    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4a)))
	GPIOR0    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3e)))
	SMCR      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x53)))
	SPMCSR    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x57)))
	OSCCAL0   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x66)))
	OSCCAL1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x67)))
	OSCTCAL0A = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf0)))
	OSCTCAL0B = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf1)))

	// Timer/Counter, 8-bit
	OCR0B  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x48)))
	OCR0A  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x47)))
	TCNT0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x46)))
	TCCR0B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x45)))
	TCCR0A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x44)))
	TIMSK0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6e)))
	TIFR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x35)))
	GTCCR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x43)))

	// Timer/Counter, 16-bit
	TIMSK1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6f)))
	TIFR1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x36)))
	TCCR1A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x80)))
	TCCR1B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x81)))
	TCCR1C = (*volatile.Register8)(unsafe.Pointer(uintptr(0x82)))
	TCNT1L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x84)))
	TCNT1H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x85)))
	OCR1AL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x88)))
	OCR1AH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x89)))
	OCR1BL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8a)))
	OCR1BH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8b)))
	ICR1L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x86)))
	ICR1H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x87)))

	// Timer/Counter Output Compare Pin
	TOCPMSA1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe9)))
	TOCPMSA0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe8)))
	TOCPMCOE = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe2)))

	// Analog-to-Digital Converter
	ADMUXA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7c)))
	ADMUXB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7d)))
	ADCSRA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7a)))
	ADCL   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x78)))
	ADCH   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x79)))
	ADCSRB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7b)))
	DIDR3  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xdf)))
	DIDR2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xde)))
	DIDR1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7f)))
	DIDR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7e)))

	// Analog Comparator
	ACSRB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4f)))
	ACSRA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x50)))

	// External Interrupts
	EICRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x69)))
	EIMSK  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3d)))
	EIFR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3c)))
	PCICR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x68)))
	PCMSK3 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x73)))
	PCMSK2 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6d)))
	PCMSK1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6c)))
	PCMSK0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6b)))
	PCIFR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3b)))

	// Watchdog Timer
	WDTCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x60)))

	// EEPROM
	EEAR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x41)))
	EEDR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x40)))
	EECR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3f)))

	// Two Wire Serial Interface
	TWSCRA = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb8)))
	TWSCRB = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb9)))
	TWSSRA = (*volatile.Register8)(unsafe.Pointer(uintptr(0xba)))
	TWSA   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbc)))
	TWSD   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbd)))
	TWSAM  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbb)))

	// USART
	UDR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc6)))
	UCSRA = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc0)))
	UCSRB = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc1)))
	UCSRC = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc2)))
	UCSRD = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc3)))
	UBRRL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc4)))
	UBRRH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc5)))

	// Fuses
	EXTENDED = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2)))
	HIGH     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x1)))
	LOW      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// Lockbits
	LOCKBIT = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))
)

// Bitfields for FUSE: Fuses
const (
	// EXTENDED
	EXTENDED_BOOTSZ0     = 0x2  // Select boot size
	EXTENDED_BOOTSZ1     = 0x4  // Select boot size
	EXTENDED_BOOTSZ_Msk  = 0x6  // Select boot size
	EXTENDED_BOOTRST     = 0x1  // Boot Reset vector Enabled
	EXTENDED_BOOTRST_Msk = 0x1  // Boot Reset vector Enabled
	EXTENDED_BODPD0      = 0x40 // BOD mode of operation when the device is in sleep mode
	EXTENDED_BODPD1      = 0x80 // BOD mode of operation when the device is in sleep mode
	EXTENDED_BODPD_Msk   = 0xc0 // BOD mode of operation when the device is in sleep mode
	EXTENDED_BODACT0     = 0x10 // BOD mode of operation when the device is active or idle
	EXTENDED_BODACT1     = 0x20 // BOD mode of operation when the device is active or idle
	EXTENDED_BODACT_Msk  = 0x30 // BOD mode of operation when the device is active or idle

	// HIGH
	HIGH_RSTDISBL     = 0x80 // Reset Disabled (Enable PC6 as i/o pin)]
	HIGH_RSTDISBL_Msk = 0x80 // Reset Disabled (Enable PC6 as i/o pin)]
	HIGH_DWEN         = 0x40 // Debug Wire enable
	HIGH_DWEN_Msk     = 0x40 // Debug Wire enable
	HIGH_SPIEN        = 0x20 // Serial program downloading (SPI) enabled
	HIGH_SPIEN_Msk    = 0x20 // Serial program downloading (SPI) enabled
	HIGH_WDTON        = 0x10 // Watch-dog Timer always on
	HIGH_WDTON_Msk    = 0x10 // Watch-dog Timer always on
	HIGH_EESAVE       = 0x8  // Preserve EEPROM through the Chip Erase cycle
	HIGH_EESAVE_Msk   = 0x8  // Preserve EEPROM through the Chip Erase cycle
	HIGH_BODLEVEL0    = 0x1  // Brown-out Detector trigger level
	HIGH_BODLEVEL1    = 0x2  // Brown-out Detector trigger level
	HIGH_BODLEVEL2    = 0x4  // Brown-out Detector trigger level
	HIGH_BODLEVEL_Msk = 0x7  // Brown-out Detector trigger level

	// LOW
	LOW_CKDIV8        = 0x80 // Divide clock by 8 internally
	LOW_CKDIV8_Msk    = 0x80 // Divide clock by 8 internally
	LOW_CKOUT         = 0x40 // Clock output on PORTB0
	LOW_CKOUT_Msk     = 0x40 // Clock output on PORTB0
	LOW_SUT_CKSEL0    = 0x1  // Select Clock Source
	LOW_SUT_CKSEL1    = 0x2  // Select Clock Source
	LOW_SUT_CKSEL2    = 0x10 // Select Clock Source
	LOW_SUT_CKSEL3    = 0x20 // Select Clock Source
	LOW_SUT_CKSEL_Msk = 0x33 // Select Clock Source
)

// Bitfields for LOCKBIT: Lockbits
const (
	// LOCKBIT
	LOCKBIT_LB0      = 0x1  // Memory Lock
	LOCKBIT_LB1      = 0x2  // Memory Lock
	LOCKBIT_LB_Msk   = 0x3  // Memory Lock
	LOCKBIT_BLB00    = 0x4  // Boot Loader Protection Mode
	LOCKBIT_BLB01    = 0x8  // Boot Loader Protection Mode
	LOCKBIT_BLB0_Msk = 0xc  // Boot Loader Protection Mode
	LOCKBIT_BLB10    = 0x10 // Boot Loader Protection Mode
	LOCKBIT_BLB11    = 0x20 // Boot Loader Protection Mode
	LOCKBIT_BLB1_Msk = 0x30 // Boot Loader Protection Mode
)

// Bitfields for SPI: Serial Peripheral Interface
const (
	// SPSR: SPI Status Register
	SPSR_SPIF      = 0x80 // SPI Interrupt Flag
	SPSR_SPIF_Msk  = 0x80 // SPI Interrupt Flag
	SPSR_WCOL      = 0x40 // Write Collision Flag
	SPSR_WCOL_Msk  = 0x40 // Write Collision Flag
	SPSR_SPI2X     = 0x1  // Double SPI Speed Bit
	SPSR_SPI2X_Msk = 0x1  // Double SPI Speed Bit

	// SPCR: SPI Control Register
	SPCR_SPIE     = 0x80 // SPI Interrupt Enable
	SPCR_SPIE_Msk = 0x80 // SPI Interrupt Enable
	SPCR_SPE      = 0x40 // SPI Enable
	SPCR_SPE_Msk  = 0x40 // SPI Enable
	SPCR_DORD     = 0x20 // Data Order
	SPCR_DORD_Msk = 0x20 // Data Order
	SPCR_MSTR     = 0x10 // Master/Slave Select
	SPCR_MSTR_Msk = 0x10 // Master/Slave Select
	SPCR_CPOL     = 0x8  // Clock polarity
	SPCR_CPOL_Msk = 0x8  // Clock polarity
	SPCR_CPHA     = 0x4  // Clock Phase
	SPCR_CPHA_Msk = 0x4  // Clock Phase
	SPCR_SPR0     = 0x1  // SPI Clock Rate Selects
	SPCR_SPR1     = 0x2  // SPI Clock Rate Selects
	SPCR_SPR_Msk  = 0x3  // SPI Clock Rate Selects
)

// Bitfields for PORTC: I/O Port
const (
	// PHDE: Port High Drive Enable Register
	PHDE_PHDEC     = 0x4 // Port C High Drive Enable
	PHDE_PHDEC_Msk = 0x4 // Port C High Drive Enable
)

// Bitfields for CPU: CPU Registers
const (
	// PRR: Power Reduction Register
	PRR_PRTWI        = 0x80 // Power Reduction TWI
	PRR_PRTWI_Msk    = 0x80 // Power Reduction TWI
	PRR_PRTIM0       = 0x20 // Power Reduction Timer/Counter0
	PRR_PRTIM0_Msk   = 0x20 // Power Reduction Timer/Counter0
	PRR_PRTIM1       = 0x8  // Power Reduction Timer/Counter1
	PRR_PRTIM1_Msk   = 0x8  // Power Reduction Timer/Counter1
	PRR_PRSPI        = 0x4  // Power Reduction SPI
	PRR_PRSPI_Msk    = 0x4  // Power Reduction SPI
	PRR_PRUSART0     = 0x2  // Power Reduction USART 0
	PRR_PRUSART0_Msk = 0x2  // Power Reduction USART 0
	PRR_PRADC        = 0x1  // Power Reduction ADC
	PRR_PRADC_Msk    = 0x1  // Power Reduction ADC

	// CLKPR: Clock Prescale Register
	CLKPR_CLKPS0    = 0x1 // Clock Prescaler Select Bits
	CLKPR_CLKPS1    = 0x2 // Clock Prescaler Select Bits
	CLKPR_CLKPS2    = 0x4 // Clock Prescaler Select Bits
	CLKPR_CLKPS3    = 0x8 // Clock Prescaler Select Bits
	CLKPR_CLKPS_Msk = 0xf // Clock Prescaler Select Bits

	// SREG: Status Register
	SREG_I     = 0x80 // Global Interrupt Enable
	SREG_I_Msk = 0x80 // Global Interrupt Enable
	SREG_T     = 0x40 // Bit Copy Storage
	SREG_T_Msk = 0x40 // Bit Copy Storage
	SREG_H     = 0x20 // Half Carry Flag
	SREG_H_Msk = 0x20 // Half Carry Flag
	SREG_S     = 0x10 // Sign Bit
	SREG_S_Msk = 0x10 // Sign Bit
	SREG_V     = 0x8  // Two's Complement Overflow Flag
	SREG_V_Msk = 0x8  // Two's Complement Overflow Flag
	SREG_N     = 0x4  // Negative Flag
	SREG_N_Msk = 0x4  // Negative Flag
	SREG_Z     = 0x2  // Zero Flag
	SREG_Z_Msk = 0x2  // Zero Flag
	SREG_C     = 0x1  // Carry Flag
	SREG_C_Msk = 0x1  // Carry Flag

	// MCUCR: MCU Control Register
	MCUCR_IVSEL     = 0x2 // Interrupt Vector Select
	MCUCR_IVSEL_Msk = 0x2 // Interrupt Vector Select

	// MCUSR: MCU Status Register
	MCUSR_WDRF      = 0x8 // Watchdog Reset Flag
	MCUSR_WDRF_Msk  = 0x8 // Watchdog Reset Flag
	MCUSR_BORF      = 0x4 // Brown-out Reset Flag
	MCUSR_BORF_Msk  = 0x4 // Brown-out Reset Flag
	MCUSR_EXTRF     = 0x2 // External Reset Flag
	MCUSR_EXTRF_Msk = 0x2 // External Reset Flag
	MCUSR_PORF      = 0x1 // Power-on reset flag
	MCUSR_PORF_Msk  = 0x1 // Power-on reset flag

	// SMCR: Sleep Mode Control Register
	SMCR_SM0    = 0x2 // Sleep Mode Select Bits
	SMCR_SM1    = 0x4 // Sleep Mode Select Bits
	SMCR_SM_Msk = 0x6 // Sleep Mode Select Bits
	SMCR_SE     = 0x1 // Sleep Enable
	SMCR_SE_Msk = 0x1 // Sleep Enable

	// SPMCSR: Store Program Memory Control and Status Register
	SPMCSR_SPMIE      = 0x80 // SPM Interrupt Enable
	SPMCSR_SPMIE_Msk  = 0x80 // SPM Interrupt Enable
	SPMCSR_RWWSB      = 0x40 // Read-While-Write Section Busy
	SPMCSR_RWWSB_Msk  = 0x40 // Read-While-Write Section Busy
	SPMCSR_RSIG       = 0x20 // Read Device Signature Imprint Table
	SPMCSR_RSIG_Msk   = 0x20 // Read Device Signature Imprint Table
	SPMCSR_RWWSRE     = 0x10 // Read-While-Write section read enable
	SPMCSR_RWWSRE_Msk = 0x10 // Read-While-Write section read enable
	SPMCSR_RWFLB      = 0x8  // Read/Write Fuse and Lock Bits
	SPMCSR_RWFLB_Msk  = 0x8  // Read/Write Fuse and Lock Bits
	SPMCSR_PGWRT      = 0x4  // Page Write
	SPMCSR_PGWRT_Msk  = 0x4  // Page Write
	SPMCSR_PGERS      = 0x2  // Page Erase
	SPMCSR_PGERS_Msk  = 0x2  // Page Erase
	SPMCSR_SPMEN      = 0x1  // Store Program Memory Enable
	SPMCSR_SPMEN_Msk  = 0x1  // Store Program Memory Enable
)

// Bitfields for TC0: Timer/Counter, 8-bit
const (
	// TCCR0B: Timer/Counter Control Register B
	TCCR0B_FOC0A     = 0x80 // Force Output Compare A
	TCCR0B_FOC0A_Msk = 0x80 // Force Output Compare A
	TCCR0B_FOC0B     = 0x40 // Force Output Compare B
	TCCR0B_FOC0B_Msk = 0x40 // Force Output Compare B
	TCCR0B_WGM02     = 0x8
	TCCR0B_WGM02_Msk = 0x8
	TCCR0B_CS00      = 0x1 // Clock Select
	TCCR0B_CS01      = 0x2 // Clock Select
	TCCR0B_CS02      = 0x4 // Clock Select
	TCCR0B_CS0_Msk   = 0x7 // Clock Select

	// TCCR0A: Timer/Counter  Control Register A
	TCCR0A_COM0A0    = 0x40 // Compare Output Mode, Phase Correct PWM Mode
	TCCR0A_COM0A1    = 0x80 // Compare Output Mode, Phase Correct PWM Mode
	TCCR0A_COM0A_Msk = 0xc0 // Compare Output Mode, Phase Correct PWM Mode
	TCCR0A_COM0B0    = 0x10 // Compare Output Mode, Fast PWm
	TCCR0A_COM0B1    = 0x20 // Compare Output Mode, Fast PWm
	TCCR0A_COM0B_Msk = 0x30 // Compare Output Mode, Fast PWm
	TCCR0A_WGM00     = 0x1  // Waveform Generation Mode
	TCCR0A_WGM01     = 0x2  // Waveform Generation Mode
	TCCR0A_WGM0_Msk  = 0x3  // Waveform Generation Mode

	// TIMSK0: Timer/Counter0 Interrupt Mask Register
	TIMSK0_OCIE0B     = 0x4 // Timer/Counter0 Output Compare Match B Interrupt Enable
	TIMSK0_OCIE0B_Msk = 0x4 // Timer/Counter0 Output Compare Match B Interrupt Enable
	TIMSK0_OCIE0A     = 0x2 // Timer/Counter0 Output Compare Match A Interrupt Enable
	TIMSK0_OCIE0A_Msk = 0x2 // Timer/Counter0 Output Compare Match A Interrupt Enable
	TIMSK0_TOIE0      = 0x1 // Timer/Counter0 Overflow Interrupt Enable
	TIMSK0_TOIE0_Msk  = 0x1 // Timer/Counter0 Overflow Interrupt Enable

	// TIFR0: Timer/Counter0 Interrupt Flag register
	TIFR0_OCF0B     = 0x4 // Timer/Counter0 Output Compare Flag 0B
	TIFR0_OCF0B_Msk = 0x4 // Timer/Counter0 Output Compare Flag 0B
	TIFR0_OCF0A     = 0x2 // Timer/Counter0 Output Compare Flag 0A
	TIFR0_OCF0A_Msk = 0x2 // Timer/Counter0 Output Compare Flag 0A
	TIFR0_TOV0      = 0x1 // Timer/Counter0 Overflow Flag
	TIFR0_TOV0_Msk  = 0x1 // Timer/Counter0 Overflow Flag

	// GTCCR: General Timer/Counter Control Register
	GTCCR_TSM         = 0x80 // Timer/Counter Synchronization Mode
	GTCCR_TSM_Msk     = 0x80 // Timer/Counter Synchronization Mode
	GTCCR_PSRSYNC     = 0x1  // Prescaler Reset Timer/Counter1 and Timer/Counter0
	GTCCR_PSRSYNC_Msk = 0x1  // Prescaler Reset Timer/Counter1 and Timer/Counter0
)

// Bitfields for TC1: Timer/Counter, 16-bit
const (
	// TIMSK1: Timer/Counter Interrupt Mask Register
	TIMSK1_ICIE1      = 0x20 // Timer/Counter1 Input Capture Interrupt Enable
	TIMSK1_ICIE1_Msk  = 0x20 // Timer/Counter1 Input Capture Interrupt Enable
	TIMSK1_OCIE1B     = 0x4  // Timer/Counter1 Output CompareB Match Interrupt Enable
	TIMSK1_OCIE1B_Msk = 0x4  // Timer/Counter1 Output CompareB Match Interrupt Enable
	TIMSK1_OCIE1A     = 0x2  // Timer/Counter1 Output CompareA Match Interrupt Enable
	TIMSK1_OCIE1A_Msk = 0x2  // Timer/Counter1 Output CompareA Match Interrupt Enable
	TIMSK1_TOIE1      = 0x1  // Timer/Counter1 Overflow Interrupt Enable
	TIMSK1_TOIE1_Msk  = 0x1  // Timer/Counter1 Overflow Interrupt Enable

	// TIFR1: Timer/Counter Interrupt Flag register
	TIFR1_ICF1      = 0x20 // Input Capture Flag 1
	TIFR1_ICF1_Msk  = 0x20 // Input Capture Flag 1
	TIFR1_OCF1B     = 0x4  // Output Compare Flag 1B
	TIFR1_OCF1B_Msk = 0x4  // Output Compare Flag 1B
	TIFR1_OCF1A     = 0x2  // Output Compare Flag 1A
	TIFR1_OCF1A_Msk = 0x2  // Output Compare Flag 1A
	TIFR1_TOV1      = 0x1  // Timer/Counter1 Overflow Flag
	TIFR1_TOV1_Msk  = 0x1  // Timer/Counter1 Overflow Flag

	// TCCR1A: Timer/Counter1 Control Register A
	TCCR1A_COM1A0    = 0x40 // Compare Output Mode 1A, bits
	TCCR1A_COM1A1    = 0x80 // Compare Output Mode 1A, bits
	TCCR1A_COM1A_Msk = 0xc0 // Compare Output Mode 1A, bits
	TCCR1A_COM1B0    = 0x10 // Compare Output Mode 1B, bits
	TCCR1A_COM1B1    = 0x20 // Compare Output Mode 1B, bits
	TCCR1A_COM1B_Msk = 0x30 // Compare Output Mode 1B, bits
	TCCR1A_WGM10     = 0x1  // Waveform Generation Mode
	TCCR1A_WGM11     = 0x2  // Waveform Generation Mode
	TCCR1A_WGM1_Msk  = 0x3  // Waveform Generation Mode

	// TCCR1B: Timer/Counter1 Control Register B
	TCCR1B_ICNC1     = 0x80 // Input Capture 1 Noise Canceler
	TCCR1B_ICNC1_Msk = 0x80 // Input Capture 1 Noise Canceler
	TCCR1B_ICES1     = 0x40 // Input Capture 1 Edge Select
	TCCR1B_ICES1_Msk = 0x40 // Input Capture 1 Edge Select
	TCCR1B_WGM10     = 0x8  // Waveform Generation Mode
	TCCR1B_WGM11     = 0x10 // Waveform Generation Mode
	TCCR1B_WGM1_Msk  = 0x18 // Waveform Generation Mode
	TCCR1B_CS10      = 0x1  // Prescaler source of Timer/Counter 1
	TCCR1B_CS11      = 0x2  // Prescaler source of Timer/Counter 1
	TCCR1B_CS12      = 0x4  // Prescaler source of Timer/Counter 1
	TCCR1B_CS1_Msk   = 0x7  // Prescaler source of Timer/Counter 1

	// TCCR1C: Timer/Counter1 Control Register C
	TCCR1C_FOC1A     = 0x80
	TCCR1C_FOC1A_Msk = 0x80
	TCCR1C_FOC1B     = 0x40
	TCCR1C_FOC1B_Msk = 0x40
)

// Bitfields for TOCPM: Timer/Counter Output Compare Pin
const (
	// TOCPMSA1: Timer Output Compare Pin Mux Selection 1
	TOCPMSA1_TOCC7S0    = 0x40 // Timer Output Compare Channel 7 Selection Bits
	TOCPMSA1_TOCC7S1    = 0x80 // Timer Output Compare Channel 7 Selection Bits
	TOCPMSA1_TOCC7S_Msk = 0xc0 // Timer Output Compare Channel 7 Selection Bits
	TOCPMSA1_TOCC6S0    = 0x10 // Timer Output Compare Channel 6 Selection Bits
	TOCPMSA1_TOCC6S1    = 0x20 // Timer Output Compare Channel 6 Selection Bits
	TOCPMSA1_TOCC6S_Msk = 0x30 // Timer Output Compare Channel 6 Selection Bits
	TOCPMSA1_TOCC5S0    = 0x4  // Timer Output Compare Channel 5 Selection Bits
	TOCPMSA1_TOCC5S1    = 0x8  // Timer Output Compare Channel 5 Selection Bits
	TOCPMSA1_TOCC5S_Msk = 0xc  // Timer Output Compare Channel 5 Selection Bits
	TOCPMSA1_TOCC4S0    = 0x1  // Timer Output Compare Channel 4 Selection Bits
	TOCPMSA1_TOCC4S1    = 0x2  // Timer Output Compare Channel 4 Selection Bits
	TOCPMSA1_TOCC4S_Msk = 0x3  // Timer Output Compare Channel 4 Selection Bits

	// TOCPMSA0: Timer Output Compare Pin Mux Selection 0
	TOCPMSA0_TOCC3S0    = 0x40 // Timer Output Compare Channel 3 Selection Bits
	TOCPMSA0_TOCC3S1    = 0x80 // Timer Output Compare Channel 3 Selection Bits
	TOCPMSA0_TOCC3S_Msk = 0xc0 // Timer Output Compare Channel 3 Selection Bits
	TOCPMSA0_TOCC2S0    = 0x10 // Timer Output Compare Channel 2 Selection Bits
	TOCPMSA0_TOCC2S1    = 0x20 // Timer Output Compare Channel 2 Selection Bits
	TOCPMSA0_TOCC2S_Msk = 0x30 // Timer Output Compare Channel 2 Selection Bits
	TOCPMSA0_TOCC1S0    = 0x4  // Timer Output Compare Channel 1 Selection Bits
	TOCPMSA0_TOCC1S1    = 0x8  // Timer Output Compare Channel 1 Selection Bits
	TOCPMSA0_TOCC1S_Msk = 0xc  // Timer Output Compare Channel 1 Selection Bits
	TOCPMSA0_TOCC0S0    = 0x1  // Timer Output Compare Channel 0 Selection Bits
	TOCPMSA0_TOCC0S1    = 0x2  // Timer Output Compare Channel 0 Selection Bits
	TOCPMSA0_TOCC0S_Msk = 0x3  // Timer Output Compare Channel 0 Selection Bits

	// TOCPMCOE: Timer Output Compare Pin Mux Channel Output Enable
	TOCPMCOE_TOCC7OE     = 0x80 // Timer Output Compare Channel 7 Output Enable
	TOCPMCOE_TOCC7OE_Msk = 0x80 // Timer Output Compare Channel 7 Output Enable
	TOCPMCOE_TOCC6OE     = 0x40 // Timer Output Compare Channel 6 Output Enable
	TOCPMCOE_TOCC6OE_Msk = 0x40 // Timer Output Compare Channel 6 Output Enable
	TOCPMCOE_TOCC5OE     = 0x20 // Timer Output Compare Channel 5 Output Enable
	TOCPMCOE_TOCC5OE_Msk = 0x20 // Timer Output Compare Channel 5 Output Enable
	TOCPMCOE_TOCC4OE     = 0x10 // Timer Output Compare Channel 4 Output Enable
	TOCPMCOE_TOCC4OE_Msk = 0x10 // Timer Output Compare Channel 4 Output Enable
	TOCPMCOE_TOCC3OE     = 0x8  // Timer Output Compare Channel 3 Output Enable
	TOCPMCOE_TOCC3OE_Msk = 0x8  // Timer Output Compare Channel 3 Output Enable
	TOCPMCOE_TOCC2OE     = 0x4  // Timer Output Compare Channel 2 Output Enable
	TOCPMCOE_TOCC2OE_Msk = 0x4  // Timer Output Compare Channel 2 Output Enable
	TOCPMCOE_TOCC1OE     = 0x2  // Timer Output Compare Channel 1 Output Enable
	TOCPMCOE_TOCC1OE_Msk = 0x2  // Timer Output Compare Channel 1 Output Enable
	TOCPMCOE_TOCC0OE     = 0x1  // Timer Output Compare Channel 0 Output Enable
	TOCPMCOE_TOCC0OE_Msk = 0x1  // Timer Output Compare Channel 0 Output Enable
)

// Bitfields for ADC: Analog-to-Digital Converter
const (
	// ADMUXA: The ADC multiplexer Selection Register A
	ADMUXA_MUX0    = 0x1  // Analog Channel Selection Bits 4:0
	ADMUXA_MUX1    = 0x2  // Analog Channel Selection Bits 4:0
	ADMUXA_MUX2    = 0x4  // Analog Channel Selection Bits 4:0
	ADMUXA_MUX3    = 0x8  // Analog Channel Selection Bits 4:0
	ADMUXA_MUX4    = 0x10 // Analog Channel Selection Bits 4:0
	ADMUXA_MUX_Msk = 0x1f // Analog Channel Selection Bits 4:0

	// ADMUXB: The ADC multiplexer Selection Register B
	ADMUXB_REFS     = 0x20 // Reference Selection Bit
	ADMUXB_REFS_Msk = 0x20 // Reference Selection Bit
	ADMUXB_MUX5     = 0x1  // Analog Channel Selection Bit 5
	ADMUXB_MUX5_Msk = 0x1  // Analog Channel Selection Bit 5

	// ADCSRA: The ADC Control and Status register
	ADCSRA_ADEN      = 0x80 // ADC Enable
	ADCSRA_ADEN_Msk  = 0x80 // ADC Enable
	ADCSRA_ADSC      = 0x40 // ADC Start Conversion
	ADCSRA_ADSC_Msk  = 0x40 // ADC Start Conversion
	ADCSRA_ADATE     = 0x20 // ADC Auto Trigger Enable
	ADCSRA_ADATE_Msk = 0x20 // ADC Auto Trigger Enable
	ADCSRA_ADIF      = 0x10 // ADC Interrupt Flag
	ADCSRA_ADIF_Msk  = 0x10 // ADC Interrupt Flag
	ADCSRA_ADIE      = 0x8  // ADC Interrupt Enable
	ADCSRA_ADIE_Msk  = 0x8  // ADC Interrupt Enable
	ADCSRA_ADPS0     = 0x1  // ADC Prescaler Select Bits
	ADCSRA_ADPS1     = 0x2  // ADC Prescaler Select Bits
	ADCSRA_ADPS2     = 0x4  // ADC Prescaler Select Bits
	ADCSRA_ADPS_Msk  = 0x7  // ADC Prescaler Select Bits

	// ADCSRB: ADC Control and Status Register B
	ADCSRB_ADLAR     = 0x8
	ADCSRB_ADLAR_Msk = 0x8
	ADCSRB_ADTS0     = 0x1 // ADC Auto Trigger Sources
	ADCSRB_ADTS1     = 0x2 // ADC Auto Trigger Sources
	ADCSRB_ADTS2     = 0x4 // ADC Auto Trigger Sources
	ADCSRB_ADTS_Msk  = 0x7 // ADC Auto Trigger Sources

	// DIDR3: Digital Input Disable Register 2
	DIDR3_ADC27D     = 0x8 // ADC27 Digital input Disable
	DIDR3_ADC27D_Msk = 0x8 // ADC27 Digital input Disable
	DIDR3_ADC26D     = 0x4 // ADC26 Digital input Disable
	DIDR3_ADC26D_Msk = 0x4 // ADC26 Digital input Disable
	DIDR3_ADC25D     = 0x2 // ADC25 Digital input Disable
	DIDR3_ADC25D_Msk = 0x2 // ADC25 Digital input Disable
	DIDR3_ADC24D     = 0x1 // ADC24 Digital input Disable
	DIDR3_ADC24D_Msk = 0x1 // ADC24 Digital input Disable

	// DIDR2: Digital Input Disable Register 2
	DIDR2_ADC23D     = 0x80 // ADC23 Digital input Disable
	DIDR2_ADC23D_Msk = 0x80 // ADC23 Digital input Disable
	DIDR2_ADC22D     = 0x40 // ADC22 Digital input Disable
	DIDR2_ADC22D_Msk = 0x40 // ADC22 Digital input Disable
	DIDR2_ADC21D     = 0x20 // ADC21 Digital input Disable
	DIDR2_ADC21D_Msk = 0x20 // ADC21 Digital input Disable
	DIDR2_ADC20D     = 0x10 // ADC20 Digital input Disable
	DIDR2_ADC20D_Msk = 0x10 // ADC20 Digital input Disable
	DIDR2_ADC19D     = 0x8  // ADC19 Digital input Disable
	DIDR2_ADC19D_Msk = 0x8  // ADC19 Digital input Disable
	DIDR2_ADC18D     = 0x4  // ADC18 Digital input Disable
	DIDR2_ADC18D_Msk = 0x4  // ADC18 Digital input Disable
	DIDR2_ADC17D     = 0x2  // ADC17 Digital input Disable
	DIDR2_ADC17D_Msk = 0x2  // ADC17 Digital input Disable
	DIDR2_ADC16D     = 0x1  // ADC16 Digital input Disable
	DIDR2_ADC16D_Msk = 0x1  // ADC16 Digital input Disable

	// DIDR1: Digital Input Disable Register 1
	DIDR1_ADC15D     = 0x80 // ADC15 Digital input Disable
	DIDR1_ADC15D_Msk = 0x80 // ADC15 Digital input Disable
	DIDR1_ADC14D     = 0x40 // ADC14 Digital input Disable
	DIDR1_ADC14D_Msk = 0x40 // ADC14 Digital input Disable
	DIDR1_ADC13D     = 0x20 // ADC13 Digital input Disable
	DIDR1_ADC13D_Msk = 0x20 // ADC13 Digital input Disable
	DIDR1_ADC12D     = 0x10 // ADC12 Digital input Disable
	DIDR1_ADC12D_Msk = 0x10 // ADC12 Digital input Disable
	DIDR1_ADC11D     = 0x8  // ADC11 Digital input Disable
	DIDR1_ADC11D_Msk = 0x8  // ADC11 Digital input Disable
	DIDR1_ADC10D     = 0x4  // ADC10 Digital input Disable
	DIDR1_ADC10D_Msk = 0x4  // ADC10 Digital input Disable
	DIDR1_ADC9D      = 0x2  // ADC9 Digital input Disable
	DIDR1_ADC9D_Msk  = 0x2  // ADC9 Digital input Disable
	DIDR1_ADC8D      = 0x1  // ADC8 Digital input Disable
	DIDR1_ADC8D_Msk  = 0x1  // ADC8 Digital input Disable

	// DIDR0: Digital Input Disable Register 0
	DIDR0_ADC7D     = 0x80 // ADC7 Digital input Disable
	DIDR0_ADC7D_Msk = 0x80 // ADC7 Digital input Disable
	DIDR0_ADC6D     = 0x40 // ADC6 Digital input Disable
	DIDR0_ADC6D_Msk = 0x40 // ADC6 Digital input Disable
	DIDR0_ADC5D     = 0x20 // ADC5 Digital input Disable
	DIDR0_ADC5D_Msk = 0x20 // ADC5 Digital input Disable
	DIDR0_ADC4D     = 0x10 // ADC4 Digital input Disable
	DIDR0_ADC4D_Msk = 0x10 // ADC4 Digital input Disable
	DIDR0_ADC3D     = 0x8  // ADC3 Digital input Disable
	DIDR0_ADC3D_Msk = 0x8  // ADC3 Digital input Disable
	DIDR0_ADC2D     = 0x4  // ADC2 Digital input Disable
	DIDR0_ADC2D_Msk = 0x4  // ADC2 Digital input Disable
	DIDR0_ADC1D     = 0x2  // ADC1 Digital input Disable
	DIDR0_ADC1D_Msk = 0x2  // ADC1 Digital input Disable
	DIDR0_ADC0D     = 0x1  // ADC0 Digital input Disable
	DIDR0_ADC0D_Msk = 0x1  // ADC0 Digital input Disable
)

// Bitfields for AC: Analog Comparator
const (
	// ACSRB: Analog Comparator Control And Status Register B
	ACSRB_HSEL       = 0x80 // Hysteresis Select
	ACSRB_HSEL_Msk   = 0x80 // Hysteresis Select
	ACSRB_HLEV       = 0x40 // Hysteresis Level
	ACSRB_HLEV_Msk   = 0x40 // Hysteresis Level
	ACSRB_ACNMUX0    = 0x4  // Analog Comparator Negative Input Multiplexer
	ACSRB_ACNMUX1    = 0x8  // Analog Comparator Negative Input Multiplexer
	ACSRB_ACNMUX_Msk = 0xc  // Analog Comparator Negative Input Multiplexer
	ACSRB_ACPMUX0    = 0x1  // Analog Comparator Positive Input Multiplexer Bits 1:0
	ACSRB_ACPMUX1    = 0x2  // Analog Comparator Positive Input Multiplexer Bits 1:0
	ACSRB_ACPMUX_Msk = 0x3  // Analog Comparator Positive Input Multiplexer Bits 1:0

	// ACSRA: Analog Comparator Control And Status Register A
	ACSRA_ACD         = 0x80 // Analog Comparator Disable
	ACSRA_ACD_Msk     = 0x80 // Analog Comparator Disable
	ACSRA_ACPMUX2     = 0x40 // Analog Comparator Positive Input Multiplexer Bit 2
	ACSRA_ACPMUX2_Msk = 0x40 // Analog Comparator Positive Input Multiplexer Bit 2
	ACSRA_ACO         = 0x20 // Analog Compare Output
	ACSRA_ACO_Msk     = 0x20 // Analog Compare Output
	ACSRA_ACI         = 0x10 // Analog Comparator Interrupt Flag
	ACSRA_ACI_Msk     = 0x10 // Analog Comparator Interrupt Flag
	ACSRA_ACIE        = 0x8  // Analog Comparator Interrupt Enable
	ACSRA_ACIE_Msk    = 0x8  // Analog Comparator Interrupt Enable
	ACSRA_ACIC        = 0x4  // Analog Comparator Input Capture Enable
	ACSRA_ACIC_Msk    = 0x4  // Analog Comparator Input Capture Enable
	ACSRA_ACIS0       = 0x1  // Analog Comparator Interrupt Mode Select bits
	ACSRA_ACIS1       = 0x2  // Analog Comparator Interrupt Mode Select bits
	ACSRA_ACIS_Msk    = 0x3  // Analog Comparator Interrupt Mode Select bits
)

// Bitfields for EXINT: External Interrupts
const (
	// EICRA: External Interrupt Control Register
	EICRA_ISC10    = 0x4 // External Interrupt Sense Control 1 Bits
	EICRA_ISC11    = 0x8 // External Interrupt Sense Control 1 Bits
	EICRA_ISC1_Msk = 0xc // External Interrupt Sense Control 1 Bits
	EICRA_ISC00    = 0x1 // External Interrupt Sense Control 0 Bits
	EICRA_ISC01    = 0x2 // External Interrupt Sense Control 0 Bits
	EICRA_ISC0_Msk = 0x3 // External Interrupt Sense Control 0 Bits

	// EIMSK: External Interrupt Mask Register
	EIMSK_INT0    = 0x1 // External Interrupt Request Enables
	EIMSK_INT1    = 0x2 // External Interrupt Request Enables
	EIMSK_INT_Msk = 0x3 // External Interrupt Request Enables

	// EIFR: External Interrupt Flag Register
	EIFR_INTF0    = 0x1 // External Interrupt Flags
	EIFR_INTF1    = 0x2 // External Interrupt Flags
	EIFR_INTF_Msk = 0x3 // External Interrupt Flags

	// PCICR: Pin Change Interrupt Control Register
	PCICR_PCIE0    = 0x1 // Pin Change Interrupt Enables
	PCICR_PCIE1    = 0x2 // Pin Change Interrupt Enables
	PCICR_PCIE2    = 0x4 // Pin Change Interrupt Enables
	PCICR_PCIE3    = 0x8 // Pin Change Interrupt Enables
	PCICR_PCIE_Msk = 0xf // Pin Change Interrupt Enables

	// PCMSK3: Pin Change Mask Register 3
	PCMSK3_PCINT0    = 0x1 // Pin Change Enable Masks
	PCMSK3_PCINT1    = 0x2 // Pin Change Enable Masks
	PCMSK3_PCINT2    = 0x4 // Pin Change Enable Masks
	PCMSK3_PCINT3    = 0x8 // Pin Change Enable Masks
	PCMSK3_PCINT_Msk = 0xf // Pin Change Enable Masks

	// PCMSK2: Pin Change Mask Register 2
	PCMSK2_PCINT0    = 0x1  // Pin Change Enable Masks
	PCMSK2_PCINT1    = 0x2  // Pin Change Enable Masks
	PCMSK2_PCINT2    = 0x4  // Pin Change Enable Masks
	PCMSK2_PCINT3    = 0x8  // Pin Change Enable Masks
	PCMSK2_PCINT4    = 0x10 // Pin Change Enable Masks
	PCMSK2_PCINT5    = 0x20 // Pin Change Enable Masks
	PCMSK2_PCINT6    = 0x40 // Pin Change Enable Masks
	PCMSK2_PCINT7    = 0x80 // Pin Change Enable Masks
	PCMSK2_PCINT_Msk = 0xff // Pin Change Enable Masks

	// PCMSK1: Pin Change Mask Register 1
	PCMSK1_PCINT0    = 0x1  // Pin Change Enable Masks
	PCMSK1_PCINT1    = 0x2  // Pin Change Enable Masks
	PCMSK1_PCINT2    = 0x4  // Pin Change Enable Masks
	PCMSK1_PCINT3    = 0x8  // Pin Change Enable Masks
	PCMSK1_PCINT4    = 0x10 // Pin Change Enable Masks
	PCMSK1_PCINT5    = 0x20 // Pin Change Enable Masks
	PCMSK1_PCINT6    = 0x40 // Pin Change Enable Masks
	PCMSK1_PCINT7    = 0x80 // Pin Change Enable Masks
	PCMSK1_PCINT_Msk = 0xff // Pin Change Enable Masks

	// PCMSK0: Pin Change Mask Register 0
	PCMSK0_PCINT0    = 0x1  // Pin Change Enable Masks
	PCMSK0_PCINT1    = 0x2  // Pin Change Enable Masks
	PCMSK0_PCINT2    = 0x4  // Pin Change Enable Masks
	PCMSK0_PCINT3    = 0x8  // Pin Change Enable Masks
	PCMSK0_PCINT4    = 0x10 // Pin Change Enable Masks
	PCMSK0_PCINT5    = 0x20 // Pin Change Enable Masks
	PCMSK0_PCINT6    = 0x40 // Pin Change Enable Masks
	PCMSK0_PCINT7    = 0x80 // Pin Change Enable Masks
	PCMSK0_PCINT_Msk = 0xff // Pin Change Enable Masks

	// PCIFR: Pin Change Interrupt Flag Register
	PCIFR_PCIF0    = 0x1 // Pin Change Interrupt Flags
	PCIFR_PCIF1    = 0x2 // Pin Change Interrupt Flags
	PCIFR_PCIF2    = 0x4 // Pin Change Interrupt Flags
	PCIFR_PCIF3    = 0x8 // Pin Change Interrupt Flags
	PCIFR_PCIF_Msk = 0xf // Pin Change Interrupt Flags
)

// Bitfields for WDT: Watchdog Timer
const (
	// WDTCSR: Watchdog Timer Control and Status Register
	WDTCSR_WDIF     = 0x80 // Watchdog Timer Interrupt Flag
	WDTCSR_WDIF_Msk = 0x80 // Watchdog Timer Interrupt Flag
	WDTCSR_WDIE     = 0x40 // Watchdog Timer Interrupt Enable
	WDTCSR_WDIE_Msk = 0x40 // Watchdog Timer Interrupt Enable
	WDTCSR_WDP0     = 0x1  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP1     = 0x2  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP2     = 0x4  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP3     = 0x20 // Watchdog Timer Prescaler Bits
	WDTCSR_WDP_Msk  = 0x27 // Watchdog Timer Prescaler Bits
	WDTCSR_WDE      = 0x8  // Watch Dog Enable
	WDTCSR_WDE_Msk  = 0x8  // Watch Dog Enable
)

// Bitfields for EEPROM: EEPROM
const (
	// EECR: EEPROM Control Register
	EECR_EEPM0     = 0x10 // EEPROM Programming Mode Bits
	EECR_EEPM1     = 0x20 // EEPROM Programming Mode Bits
	EECR_EEPM_Msk  = 0x30 // EEPROM Programming Mode Bits
	EECR_EERIE     = 0x8  // EEProm Ready Interrupt Enable
	EECR_EERIE_Msk = 0x8  // EEProm Ready Interrupt Enable
	EECR_EEMPE     = 0x4  // EEPROM Master Write Enable
	EECR_EEMPE_Msk = 0x4  // EEPROM Master Write Enable
	EECR_EEPE      = 0x2  // EEPROM Write Enable
	EECR_EEPE_Msk  = 0x2  // EEPROM Write Enable
	EECR_EERE      = 0x1  // EEPROM Read Enable
	EECR_EERE_Msk  = 0x1  // EEPROM Read Enable
)

// Bitfields for TWI: Two Wire Serial Interface
const (
	// TWSCRA: TWI Slave Control Register A
	TWSCRA_TWSHE      = 0x80 // TWI SDA Hold Time Enable
	TWSCRA_TWSHE_Msk  = 0x80 // TWI SDA Hold Time Enable
	TWSCRA_TWDIE      = 0x20 // TWI Data Interrupt Enable
	TWSCRA_TWDIE_Msk  = 0x20 // TWI Data Interrupt Enable
	TWSCRA_TWASIE     = 0x10 // TWI Address/Stop Interrupt Enable
	TWSCRA_TWASIE_Msk = 0x10 // TWI Address/Stop Interrupt Enable
	TWSCRA_TWEN       = 0x8  // Two-Wire Interface Enable
	TWSCRA_TWEN_Msk   = 0x8  // Two-Wire Interface Enable
	TWSCRA_TWSIE      = 0x4  // TWI Stop Interrupt Enable
	TWSCRA_TWSIE_Msk  = 0x4  // TWI Stop Interrupt Enable
	TWSCRA_TWPME      = 0x2  // TWI Promiscuous Mode Enable
	TWSCRA_TWPME_Msk  = 0x2  // TWI Promiscuous Mode Enable
	TWSCRA_TWSME      = 0x1  // TWI Smart Mode Enable
	TWSCRA_TWSME_Msk  = 0x1  // TWI Smart Mode Enable

	// TWSCRB: TWI Slave Control Register B
	TWSCRB_TWHNM     = 0x8 // TWI High Noise Mode
	TWSCRB_TWHNM_Msk = 0x8 // TWI High Noise Mode
	TWSCRB_TWAA      = 0x4 // TWI Acknowledge Action
	TWSCRB_TWAA_Msk  = 0x4 // TWI Acknowledge Action
	TWSCRB_TWCMD0    = 0x1
	TWSCRB_TWCMD1    = 0x2
	TWSCRB_TWCMD_Msk = 0x3

	// TWSSRA: TWI Slave Status Register A
	TWSSRA_TWDIF      = 0x80 // TWI Data Interrupt Flag.
	TWSSRA_TWDIF_Msk  = 0x80 // TWI Data Interrupt Flag.
	TWSSRA_TWASIF     = 0x40 // TWI Address/Stop Interrupt Flag
	TWSSRA_TWASIF_Msk = 0x40 // TWI Address/Stop Interrupt Flag
	TWSSRA_TWCH       = 0x20 // TWI Clock Hold
	TWSSRA_TWCH_Msk   = 0x20 // TWI Clock Hold
	TWSSRA_TWRA       = 0x10 // TWI Receive Acknowledge
	TWSSRA_TWRA_Msk   = 0x10 // TWI Receive Acknowledge
	TWSSRA_TWC        = 0x8  // TWI Collision
	TWSSRA_TWC_Msk    = 0x8  // TWI Collision
	TWSSRA_TWBE       = 0x4  // TWI Bus Error
	TWSSRA_TWBE_Msk   = 0x4  // TWI Bus Error
	TWSSRA_TWDIR      = 0x2  // TWI Read/Write Direction
	TWSSRA_TWDIR_Msk  = 0x2  // TWI Read/Write Direction
	TWSSRA_TWAS       = 0x1  // TWI Address or Stop
	TWSSRA_TWAS_Msk   = 0x1  // TWI Address or Stop

	// TWSD: TWI Slave Data Register
	TWSD_TWSD0    = 0x1  // TWI slave data bit
	TWSD_TWSD1    = 0x2  // TWI slave data bit
	TWSD_TWSD2    = 0x4  // TWI slave data bit
	TWSD_TWSD3    = 0x8  // TWI slave data bit
	TWSD_TWSD4    = 0x10 // TWI slave data bit
	TWSD_TWSD5    = 0x20 // TWI slave data bit
	TWSD_TWSD6    = 0x40 // TWI slave data bit
	TWSD_TWSD7    = 0x80 // TWI slave data bit
	TWSD_TWSD_Msk = 0xff // TWI slave data bit

	// TWSAM: TWI Slave Address Mask Register
	TWSAM_TWSAM0    = 0x2  // TWI Address Mask Bits
	TWSAM_TWSAM1    = 0x4  // TWI Address Mask Bits
	TWSAM_TWSAM2    = 0x8  // TWI Address Mask Bits
	TWSAM_TWSAM3    = 0x10 // TWI Address Mask Bits
	TWSAM_TWSAM4    = 0x20 // TWI Address Mask Bits
	TWSAM_TWSAM5    = 0x40 // TWI Address Mask Bits
	TWSAM_TWSAM6    = 0x80 // TWI Address Mask Bits
	TWSAM_TWSAM_Msk = 0xfe // TWI Address Mask Bits
	TWSAM_TWAE      = 0x1  // TWI Address Enable
	TWSAM_TWAE_Msk  = 0x1  // TWI Address Enable
)

// Bitfields for USART: USART
const (
	// UCSRA: USART Control and Status Register A
	UCSRA_RXC      = 0x80 // USART Receive Complete
	UCSRA_RXC_Msk  = 0x80 // USART Receive Complete
	UCSRA_TXC      = 0x40 // USART Transmitt Complete
	UCSRA_TXC_Msk  = 0x40 // USART Transmitt Complete
	UCSRA_UDRE     = 0x20 // USART Data Register Empty
	UCSRA_UDRE_Msk = 0x20 // USART Data Register Empty
	UCSRA_FE       = 0x10 // Framing Error
	UCSRA_FE_Msk   = 0x10 // Framing Error
	UCSRA_DOR      = 0x8  // Data overRun
	UCSRA_DOR_Msk  = 0x8  // Data overRun
	UCSRA_UPE      = 0x4  // Parity Error
	UCSRA_UPE_Msk  = 0x4  // Parity Error
	UCSRA_U2X      = 0x2  // Double the USART transmission speed
	UCSRA_U2X_Msk  = 0x2  // Double the USART transmission speed
	UCSRA_MPCM     = 0x1  // Multi-processor Communication Mode
	UCSRA_MPCM_Msk = 0x1  // Multi-processor Communication Mode

	// UCSRB: USART Control and Status Register B
	UCSRB_RXCIE     = 0x80 // RX Complete Interrupt Enable
	UCSRB_RXCIE_Msk = 0x80 // RX Complete Interrupt Enable
	UCSRB_TXCIE     = 0x40 // TX Complete Interrupt Enable
	UCSRB_TXCIE_Msk = 0x40 // TX Complete Interrupt Enable
	UCSRB_UDRIE     = 0x20 // USART Data register Empty Interrupt Enable
	UCSRB_UDRIE_Msk = 0x20 // USART Data register Empty Interrupt Enable
	UCSRB_RXEN      = 0x10 // Receiver Enable
	UCSRB_RXEN_Msk  = 0x10 // Receiver Enable
	UCSRB_TXEN      = 0x8  // Transmitter Enable
	UCSRB_TXEN_Msk  = 0x8  // Transmitter Enable
	UCSRB_UCSZ2     = 0x4  // Character Size
	UCSRB_UCSZ2_Msk = 0x4  // Character Size
	UCSRB_RXB8      = 0x2  // Receive Data Bit 8
	UCSRB_RXB8_Msk  = 0x2  // Receive Data Bit 8
	UCSRB_TXB8      = 0x1  // Transmit Data Bit 8
	UCSRB_TXB8_Msk  = 0x1  // Transmit Data Bit 8

	// UCSRC: USART Control and Status Register C
	UCSRC_UMSEL0    = 0x40 // USART Mode Select
	UCSRC_UMSEL1    = 0x80 // USART Mode Select
	UCSRC_UMSEL_Msk = 0xc0 // USART Mode Select
	UCSRC_UPM0      = 0x10 // Parity Mode Bits
	UCSRC_UPM1      = 0x20 // Parity Mode Bits
	UCSRC_UPM_Msk   = 0x30 // Parity Mode Bits
	UCSRC_USBS      = 0x8  // Stop Bit Select
	UCSRC_USBS_Msk  = 0x8  // Stop Bit Select
	UCSRC_UCSZ0     = 0x2  // Character Size
	UCSRC_UCSZ1     = 0x4  // Character Size
	UCSRC_UCSZ_Msk  = 0x6  // Character Size
	UCSRC_UCPOL     = 0x1  // Clock Polarity
	UCSRC_UCPOL_Msk = 0x1  // Clock Polarity

	// UCSRD: USART Control and Status Register D
	UCSRD_RXSIE     = 0x80 // USART RX Start Interrupt Enable
	UCSRD_RXSIE_Msk = 0x80 // USART RX Start Interrupt Enable
	UCSRD_RXS       = 0x40 // USART RX Start Flag
	UCSRD_RXS_Msk   = 0x40 // USART RX Start Flag
	UCSRD_SFDE      = 0x20 // USART RX Start Frame Detection Enable
	UCSRD_SFDE_Msk  = 0x20 // USART RX Start Frame Detection Enable
)
