/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.bcm.vc.iv;

import com.jogamp.common.util.Bitfield;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.Capabilities;
import com.jogamp.nativewindow.DefaultGraphicsScreen;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.nativewindow.util.RectangleImmutable;
import jogamp.newt.PointerIconImpl;
import jogamp.newt.ScreenImpl;
import jogamp.newt.WindowImpl;
import jogamp.newt.driver.KeyTracker;
import jogamp.newt.driver.MouseTracker;
import jogamp.newt.driver.bcm.vc.iv.DisplayDriver;
import jogamp.newt.driver.bcm.vc.iv.ScreenDriver;
import jogamp.newt.driver.linux.LinuxKeyEventTracker;
import jogamp.newt.driver.linux.LinuxMouseTracker;
import jogamp.newt.driver.x11.X11UnderlayTracker;
import jogamp.opengl.egl.EGLDisplayUtil;

public class WindowDriver
extends WindowImpl {
    private static final String WINDOW_CLASS_NAME = "NewtWindow";
    private X11UnderlayTracker x11UnderlayTracker;
    private MouseTracker mouseTracker;
    private KeyTracker keyTracker;
    private int layer;
    private long nativeWindowHandle;
    private long windowHandleClose;
    private static int nextLayer;
    private static int layerCount;
    private static final int MAX_LAYERS = 32;
    private static final Bitfield usedLayers;
    private static final Object layerSync;

    public WindowDriver() {
        try {
            this.x11UnderlayTracker = X11UnderlayTracker.getSingleton();
            this.mouseTracker = this.x11UnderlayTracker;
            this.keyTracker = this.x11UnderlayTracker;
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            this.mouseTracker = LinuxMouseTracker.getSingleton();
            this.keyTracker = LinuxKeyEventTracker.getSingleton();
        }
        this.layer = -1;
        this.nativeWindowHandle = 0L;
        this.windowHandleClose = 0L;
    }

    private RectangleImmutable clampRect(ScreenDriver screenDriver, RectangleImmutable rectangleImmutable, boolean bl) {
        int n = rectangleImmutable.getX();
        int n2 = rectangleImmutable.getY();
        int n3 = rectangleImmutable.getWidth();
        int n4 = rectangleImmutable.getHeight();
        int n5 = screenDriver.getWidth();
        int n6 = screenDriver.getHeight();
        boolean bl2 = false;
        boolean bl3 = false;
        if (0 > n) {
            n = 0;
            bl2 = true;
        }
        if (0 > n2) {
            n2 = 0;
            bl2 = true;
        }
        if (n5 < n + n3) {
            if (0 < n) {
                n = 0;
                bl2 = true;
            }
            if (n5 < n3) {
                n3 = n5;
                bl3 = true;
            }
        }
        if (n6 < n2 + n4) {
            if (0 < n2) {
                n2 = 0;
                bl2 = true;
            }
            if (n6 < n4) {
                n4 = n6;
                bl3 = true;
            }
        }
        if (bl2 || bl3) {
            if (bl) {
                if (bl2) {
                    this.defineWindowPosition(n, n2);
                }
                if (bl3) {
                    this.defineWindowSize(n3, n4);
                }
            }
            return new Rectangle(n, n2, n3, n4);
        }
        return rectangleImmutable;
    }

    @Override
    protected boolean canCreateNativeImpl() {
        this.clampRect((ScreenDriver)this.getScreen(), new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight()), true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createNativeImpl(boolean[] blArray) {
        if (0L != this.getParentWindowHandle()) {
            throw new RuntimeException("Window parenting not supported (yet)");
        }
        Object object = layerSync;
        synchronized (object) {
            if (layerCount >= 32) {
                throw new RuntimeException("Max windows reached: " + layerCount + " ( " + 32 + " )");
            }
            for (int i = 0; 0 > this.layer && i < 32; ++i) {
                if (!usedLayers.get(nextLayer)) {
                    this.layer = nextLayer;
                    usedLayers.set(this.layer);
                    ++layerCount;
                }
                if (32 != ++nextLayer) continue;
                nextLayer = 0;
            }
        }
        if (0 > this.layer) {
            throw new InternalError("Could not find a free layer: count " + layerCount + ", max " + 32);
        }
        object = (ScreenDriver)this.getScreen();
        DisplayDriver displayDriver = (DisplayDriver)((ScreenImpl)object).getDisplay();
        AbstractGraphicsScreen abstractGraphicsScreen = ((ScreenImpl)object).getGraphicsScreen();
        EGLGraphicsDevice eGLGraphicsDevice = (EGLGraphicsDevice)abstractGraphicsScreen.getDevice();
        EGLGraphicsDevice eGLGraphicsDevice2 = EGLDisplayUtil.eglCreateEGLGraphicsDevice(eGLGraphicsDevice.getNativeDisplayID(), eGLGraphicsDevice.getConnection(), eGLGraphicsDevice.getUnitID());
        eGLGraphicsDevice2.open();
        DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen(eGLGraphicsDevice2, abstractGraphicsScreen.getIndex());
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = GraphicsConfigurationFactory.getFactory(displayDriver.getGraphicsDevice(), this.capsRequested).chooseGraphicsConfiguration(this.capsRequested, this.capsRequested, this.capabilitiesChooser, defaultGraphicsScreen, 0);
        if (null == abstractGraphicsConfiguration) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
        }
        Capabilities capabilities = (Capabilities)abstractGraphicsConfiguration.getChosenCapabilities();
        if (this.capsRequested.isBackgroundOpaque() != capabilities.isBackgroundOpaque()) {
            capabilities.setBackgroundOpaque(this.capsRequested.isBackgroundOpaque());
        }
        this.setGraphicsConfiguration(abstractGraphicsConfiguration);
        this.nativeWindowHandle = this.CreateWindow0(displayDriver.getBCMHandle(), this.layer, this.getX(), this.getY(), this.getWidth(), this.getHeight(), capabilities.isBackgroundOpaque(), capabilities.getAlphaBits());
        if (this.nativeWindowHandle == 0L) {
            throw new NativeWindowException("Error creating egl window: " + abstractGraphicsConfiguration);
        }
        this.setWindowHandle(this.nativeWindowHandle);
        if (0L == this.getWindowHandle()) {
            throw new NativeWindowException("Error native Window Handle is null");
        }
        this.windowHandleClose = this.nativeWindowHandle;
        if (null != this.keyTracker) {
            this.addWindowListener(this.keyTracker);
        }
        if (null != this.mouseTracker) {
            this.addWindowListener(this.mouseTracker);
        }
        this.focusChanged(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeNativeImpl() {
        DisplayDriver displayDriver = (DisplayDriver)this.getScreen().getDisplay();
        EGLGraphicsDevice eGLGraphicsDevice = (EGLGraphicsDevice)this.getGraphicsConfiguration().getScreen().getDevice();
        if (null != this.mouseTracker) {
            this.removeWindowListener(this.mouseTracker);
        }
        if (null != this.keyTracker) {
            this.removeWindowListener(this.keyTracker);
        }
        if (0L != this.windowHandleClose) {
            this.CloseWindow0(displayDriver.getBCMHandle(), this.windowHandleClose);
        }
        eGLGraphicsDevice.close();
        Object object = layerSync;
        synchronized (object) {
            usedLayers.clear(this.layer);
            --layerCount;
            this.layer = -1;
        }
    }

    @Override
    protected void requestFocusImpl(boolean bl) {
        this.focusChanged(false, true);
    }

    @Override
    protected final int getSupportedReconfigMaskImpl() {
        return 30985;
    }

    @Override
    protected boolean reconfigureWindowImpl(int n, int n2, int n3, int n4, int n5) {
        RectangleImmutable rectangleImmutable = this.clampRect((ScreenDriver)this.getScreen(), new Rectangle(n, n2, n3, n4), false);
        this.reconfigure0(this.nativeWindowHandle, rectangleImmutable.getX(), rectangleImmutable.getY(), rectangleImmutable.getWidth(), rectangleImmutable.getHeight(), n5);
        return true;
    }

    @Override
    protected Point getLocationOnScreenImpl(int n, int n2) {
        return new Point(n, n2);
    }

    @Override
    protected final void doMouseEvent(boolean bl, boolean bl2, short s, int n, int n2, int n3, short s2, float[] fArray, float f) {
        if (205 == s || 206 == s) {
            DisplayDriver displayDriver = (DisplayDriver)this.getScreen().getDisplay();
            displayDriver.moveActivePointerIcon(this.getX() + n2, this.getY() + n3);
        }
        super.doMouseEvent(bl, bl2, s, n, n2, n3, s2, fArray, f);
    }

    @Override
    protected void setPointerIconImpl(PointerIconImpl pointerIconImpl) {
        DisplayDriver displayDriver = (DisplayDriver)this.getScreen().getDisplay();
        if (null != this.mouseTracker) {
            displayDriver.setPointerIconActive(null != pointerIconImpl ? pointerIconImpl.validatedHandle() : 0L, this.mouseTracker.getLastX(), this.mouseTracker.getLastY());
        } else {
            displayDriver.setPointerIconActive(null != pointerIconImpl ? pointerIconImpl.validatedHandle() : 0L, 0, 0);
        }
    }

    @Override
    protected boolean setPointerVisibleImpl(boolean bl) {
        DisplayDriver displayDriver = (DisplayDriver)this.getScreen().getDisplay();
        if (null != this.mouseTracker) {
            displayDriver.setActivePointerIconVisible(bl, this.mouseTracker.getLastX(), this.mouseTracker.getLastY());
        } else {
            displayDriver.setActivePointerIconVisible(bl, 0, 0);
        }
        return true;
    }

    protected static native boolean initIDs();

    private native long CreateWindow0(long var1, int var3, int var4, int var5, int var6, int var7, boolean var8, int var9);

    private native void CloseWindow0(long var1, long var3);

    private native void reconfigure0(long var1, int var3, int var4, int var5, int var6, int var7);

    static {
        DisplayDriver.initSingleton();
        nextLayer = 0;
        layerCount = 0;
        usedLayers = Bitfield.Factory.create((int)32);
        layerSync = new Object();
    }
}

