/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.glsl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLException;
import java.io.PrintStream;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.Set;

public final class ShaderUtil {
    private static final String implObjectKey = "com.jogamp.opengl.util.glsl.ShaderUtil";

    public static String getShaderInfoLog(GL gL, int n) {
        GL2ES2 gL2ES2 = gL.getGL2ES2();
        int[] nArray = new int[1];
        gL2ES2.glGetShaderiv(n, 35716, nArray, 0);
        if (nArray[0] == 0) {
            return "(no info log)";
        }
        int[] nArray2 = new int[1];
        byte[] byArray = new byte[nArray[0]];
        gL2ES2.glGetShaderInfoLog(n, nArray[0], nArray2, 0, byArray, 0);
        return new String(byArray, 0, nArray2[0]);
    }

    public static String getProgramInfoLog(GL gL, int n) {
        GL2ES2 gL2ES2 = gL.getGL2ES2();
        int[] nArray = new int[1];
        gL2ES2.glGetProgramiv(n, 35716, nArray, 0);
        if (nArray[0] == 0) {
            return "(no info log)";
        }
        int[] nArray2 = new int[1];
        byte[] byArray = new byte[nArray[0]];
        gL2ES2.glGetProgramInfoLog(n, nArray[0], nArray2, 0, byArray, 0);
        return new String(byArray, 0, nArray2[0]);
    }

    public static boolean isShaderStatusValid(GL gL, int n, int n2, PrintStream printStream) {
        boolean bl;
        GL2ES2 gL2ES2 = gL.getGL2ES2();
        int[] nArray = new int[1];
        gL2ES2.glGetShaderiv(n, n2, nArray, 0);
        boolean bl2 = bl = nArray[0] == 1;
        if (!bl && null != printStream) {
            printStream.println("Shader status invalid: " + ShaderUtil.getShaderInfoLog(gL2ES2, n));
        }
        return bl;
    }

    public static boolean isShaderStatusValid(GL gL, IntBuffer intBuffer, int n, PrintStream printStream) {
        boolean bl = true;
        for (int i = intBuffer.position(); i < intBuffer.limit(); ++i) {
            bl = ShaderUtil.isShaderStatusValid(gL, intBuffer.get(i), n, printStream) && bl;
        }
        return bl;
    }

    public static boolean isProgramStatusValid(GL gL, int n, int n2) {
        GL2ES2 gL2ES2 = gL.getGL2ES2();
        int[] nArray = new int[1];
        gL2ES2.glGetProgramiv(n, n2, nArray, 0);
        return nArray[0] == 1;
    }

    public static boolean isProgramLinkStatusValid(GL gL, int n, PrintStream printStream) {
        GL2ES2 gL2ES2 = gL.getGL2ES2();
        if (!gL2ES2.glIsProgram(n)) {
            if (null != printStream) {
                printStream.println("Program name invalid: " + n);
            }
            return false;
        }
        if (!ShaderUtil.isProgramStatusValid(gL2ES2, n, 35714)) {
            if (null != printStream) {
                printStream.println("Program link failed: " + n + "\n\t" + ShaderUtil.getProgramInfoLog(gL2ES2, n));
            }
            return false;
        }
        return true;
    }

    public static boolean isProgramExecStatusValid(GL gL, int n, PrintStream printStream) {
        GL2ES2 gL2ES2 = gL.getGL2ES2();
        gL2ES2.glValidateProgram(n);
        if (!ShaderUtil.isProgramStatusValid(gL2ES2, n, 35715)) {
            if (null != printStream) {
                printStream.println("Program validation failed: " + n + "\n\t" + ShaderUtil.getProgramInfoLog(gL2ES2, n));
            }
            return false;
        }
        return true;
    }

    public static void createShader(GL gL, int n, IntBuffer intBuffer) {
        GL2ES2 gL2ES2 = gL.getGL2ES2();
        for (int i = intBuffer.position(); i < intBuffer.limit(); ++i) {
            intBuffer.put(i, gL2ES2.glCreateShader(n));
        }
    }

    public static Set<Integer> getShaderBinaryFormats(GL gL) {
        GL2ES2 gL2ES2 = gL.getGL2ES2();
        ProfileInformation profileInformation = ShaderUtil.getProfileInformation(gL2ES2);
        if (null == profileInformation.shaderBinaryFormats) {
            profileInformation.shaderBinaryFormats = new HashSet<Integer>();
            if (gL2ES2.isGLES2Compatible()) {
                try {
                    int n;
                    int[] nArray = new int[1];
                    gL2ES2.glGetIntegerv(36345, nArray, 0);
                    int n2 = gL2ES2.glGetError();
                    int n3 = n = 0 == n2 ? nArray[0] : 0;
                    if (n > 0) {
                        int[] nArray2 = new int[n];
                        gL2ES2.glGetIntegerv(36344, nArray2, 0);
                        for (int i = 0; i < n; ++i) {
                            profileInformation.shaderBinaryFormats.add(nArray2[i]);
                        }
                    }
                }
                catch (GLException gLException) {
                    System.err.println("Caught exception on thread " + Thread.currentThread().getName());
                    gLException.printStackTrace();
                }
            }
        }
        return profileInformation.shaderBinaryFormats;
    }

    public static boolean isShaderCompilerAvailable(GL gL) {
        GL2ES2 gL2ES2 = gL.getGL2ES2();
        ProfileInformation profileInformation = ShaderUtil.getProfileInformation(gL2ES2);
        if (null == profileInformation.shaderCompilerAvailable) {
            if (gL2ES2.isGLES2()) {
                boolean bl = false;
                try {
                    Set<Integer> set;
                    boolean bl2;
                    byte[] byArray = new byte[1];
                    gL2ES2.glGetBooleanv(36346, byArray, 0);
                    int n = gL2ES2.glGetError();
                    boolean bl3 = bl2 = 0 == n && byArray[0] != 0;
                    if (!bl2 && (set = ShaderUtil.getShaderBinaryFormats(gL2ES2)).size() == 0) {
                        bl2 = true;
                    }
                    profileInformation.shaderCompilerAvailable = bl2;
                    bl = true;
                }
                catch (GLException gLException) {
                    System.err.println("Caught exception on thread " + Thread.currentThread().getName());
                    gLException.printStackTrace();
                }
                if (!bl) {
                    profileInformation.shaderCompilerAvailable = true;
                }
            } else if (gL2ES2.isGL2ES2()) {
                profileInformation.shaderCompilerAvailable = new Boolean(true);
            } else {
                throw new GLException("Invalid OpenGL profile");
            }
        }
        return profileInformation.shaderCompilerAvailable;
    }

    public static boolean isGeometryShaderSupported(GL gL) {
        GLContext gLContext = gL.getContext();
        return gLContext.getGLVersionNumber().compareTo(GLContext.Version3_2) >= 0 || gLContext.isExtensionAvailable("GL_ARB_geometry_shader4");
    }

    public static void shaderSource(GL gL, int n, CharSequence[] charSequenceArray) {
        int n2;
        GL2ES2 gL2ES2 = gL.getGL2ES2();
        if (!ShaderUtil.isShaderCompilerAvailable(gL)) {
            throw new GLException("No compiler is available");
        }
        int n3 = n2 = null != charSequenceArray ? charSequenceArray.length : 0;
        if (n2 == 0) {
            throw new GLException("No sources specified");
        }
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)n2);
        for (int i = 0; i < n2; ++i) {
            intBuffer.put(i, charSequenceArray[i].length());
        }
        if (charSequenceArray instanceof String[]) {
            gL2ES2.glShaderSource(n, n2, (String[])charSequenceArray, intBuffer);
        } else {
            String[] stringArray = new String[charSequenceArray.length];
            for (int i = charSequenceArray.length - 1; i >= 0; --i) {
                CharSequence charSequence = charSequenceArray[i];
                stringArray[i] = charSequence instanceof String ? (String)charSequence : charSequenceArray[i].toString();
            }
            gL2ES2.glShaderSource(n, n2, stringArray, intBuffer);
        }
    }

    public static void shaderSource(GL gL, IntBuffer intBuffer, CharSequence[][] charSequenceArray) {
        int n;
        int n2 = null != charSequenceArray ? charSequenceArray.length : 0;
        int n3 = n = null != intBuffer ? intBuffer.remaining() : 0;
        if (n <= 0 || n2 <= 0 || n != n2) {
            throw new GLException("Invalid number of shaders and/or sources: shaders=" + n + ", sources=" + n2);
        }
        for (int i = 0; i < n2; ++i) {
            ShaderUtil.shaderSource(gL, intBuffer.get(intBuffer.position() + i), charSequenceArray[i]);
        }
    }

    public static void shaderBinary(GL gL, IntBuffer intBuffer, int n, Buffer buffer) {
        GL2ES2 gL2ES2 = gL.getGL2ES2();
        if (ShaderUtil.getShaderBinaryFormats(gL2ES2).size() <= 0) {
            throw new GLException("No binary formats are supported");
        }
        int n2 = intBuffer.remaining();
        if (n2 <= 0) {
            throw new GLException("No shaders specified");
        }
        if (null == buffer) {
            throw new GLException("Null shader binary");
        }
        int n3 = buffer.remaining();
        if (0 >= n3) {
            throw new GLException("Empty shader binary (remaining == 0)");
        }
        gL2ES2.glShaderBinary(n2, intBuffer, n, buffer, n3);
    }

    public static void compileShader(GL gL, IntBuffer intBuffer) {
        GL2ES2 gL2ES2 = gL.getGL2ES2();
        for (int i = intBuffer.position(); i < intBuffer.limit(); ++i) {
            gL2ES2.glCompileShader(intBuffer.get(i));
        }
    }

    public static void attachShader(GL gL, int n, IntBuffer intBuffer) {
        GL2ES2 gL2ES2 = gL.getGL2ES2();
        for (int i = intBuffer.position(); i < intBuffer.limit(); ++i) {
            gL2ES2.glAttachShader(n, intBuffer.get(i));
        }
    }

    public static void detachShader(GL gL, int n, IntBuffer intBuffer) {
        GL2ES2 gL2ES2 = gL.getGL2ES2();
        for (int i = intBuffer.position(); i < intBuffer.limit(); ++i) {
            gL2ES2.glDetachShader(n, intBuffer.get(i));
        }
    }

    public static void deleteShader(GL gL, IntBuffer intBuffer) {
        GL2ES2 gL2ES2 = gL.getGL2ES2();
        for (int i = intBuffer.position(); i < intBuffer.limit(); ++i) {
            gL2ES2.glDeleteShader(intBuffer.get(i));
        }
    }

    public static boolean createAndLoadShader(GL gL, IntBuffer intBuffer, int n, int n2, Buffer buffer, PrintStream printStream) {
        GL2ES2 gL2ES2 = gL.getGL2ES2();
        int n3 = gL2ES2.glGetError();
        if (n3 != 0 && null != printStream) {
            printStream.println("createAndLoadShader: Pre GL Error: 0x" + Integer.toHexString(n3));
        }
        ShaderUtil.createShader(gL2ES2, n, intBuffer);
        n3 = gL2ES2.glGetError();
        if (n3 != 0) {
            throw new GLException("createAndLoadShader: CreateShader failed, GL Error: 0x" + Integer.toHexString(n3));
        }
        ShaderUtil.shaderBinary(gL2ES2, intBuffer, n2, buffer);
        n3 = gL2ES2.glGetError();
        if (n3 != 0 && null != printStream) {
            printStream.println("createAndLoadShader: ShaderBinary failed, GL Error: 0x" + Integer.toHexString(n3));
        }
        return n3 == 0;
    }

    public static boolean createAndCompileShader(GL gL, IntBuffer intBuffer, int n, CharSequence[][] charSequenceArray, PrintStream printStream) {
        GL2ES2 gL2ES2 = gL.getGL2ES2();
        int n2 = gL2ES2.glGetError();
        if (n2 != 0 && null != printStream) {
            printStream.println("createAndCompileShader: Pre GL Error: 0x" + Integer.toHexString(n2));
        }
        ShaderUtil.createShader(gL2ES2, n, intBuffer);
        n2 = gL2ES2.glGetError();
        if (n2 != 0) {
            throw new GLException("createAndCompileShader: CreateShader failed, GL Error: 0x" + Integer.toHexString(n2));
        }
        ShaderUtil.shaderSource((GL)gL2ES2, intBuffer, charSequenceArray);
        n2 = gL2ES2.glGetError();
        if (n2 != 0) {
            throw new GLException("createAndCompileShader: ShaderSource failed, GL Error: 0x" + Integer.toHexString(n2));
        }
        ShaderUtil.compileShader(gL2ES2, intBuffer);
        n2 = gL2ES2.glGetError();
        if (n2 != 0 && null != printStream) {
            printStream.println("createAndCompileShader: CompileShader failed, GL Error: 0x" + Integer.toHexString(n2));
        }
        return ShaderUtil.isShaderStatusValid((GL)gL2ES2, intBuffer, 35713, printStream) && n2 == 0;
    }

    private static ProfileInformation getProfileInformation(GL gL) {
        GLContext gLContext = gL.getContext();
        gLContext.validateCurrent();
        ProfileInformation profileInformation = (ProfileInformation)gLContext.getAttachedObject(implObjectKey);
        if (profileInformation == null) {
            profileInformation = new ProfileInformation();
            gLContext.attachObject(implObjectKey, profileInformation);
        }
        return profileInformation;
    }

    private static class ProfileInformation {
        Boolean shaderCompilerAvailable = null;
        Set<Integer> shaderBinaryFormats = null;

        private ProfileInformation() {
        }
    }
}

