\name{GradientAnisotropicDiffusionImageFilter}
\alias{GradientAnisotropicDiffusionImageFilter}
\title{GradientAnisotropicDiffusionImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
This filter performs anisotropic diffusion on a scalar itk::Image using the classic Perona-Malik, gradient magnitude based equation.
GradientAnisotropicDiffusionImageFilter}
\details{
For detailed information on anisotropic diffusion, see
itkAnisotropicDiffusionFunction and
itkGradientNDAnisotropicDiffusionFunction.
Inputs and Outputs
The input to this filter should be a scalar itk::Image of any dimensionality. The output image will be a diffused copy of
the input.
Parameters
Please see the description of parameters given in
itkAnisotropicDiffusionImageFilter.
See:
AnisotropicDiffusionImageFilter
AnisotropicDiffusionFunction
GradientAnisotropicDiffusionFunction
GradientAnisotropicDiffusion for the procedural interface
itk::GradientAnisotropicDiffusionImageFilter for the Doxygen on the original ITK class.
GradientAnisotropicDiffusionImageFilter}
%C++ includes: sitkGradientAnisotropicDiffusionImageFilter.h
\section{Methods}{
\describe{
\item{double EstimateOptimalTimeStep(Image &inImage):}{
This method autmatically sets the optimal timestep for an image given
its spacing.
}
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(Image &&image1):}{
Execute the filter on the input image
}
\item{double GetConductanceParameter() const:}{}
\item{unsigned int GetConductanceScalingUpdateInterval() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint32_t GetNumberOfIterations() const:}{}
\item{double GetTimeStep() const:}{}
\item{ GradientAnisotropicDiffusionImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetConductanceParameter(double ConductanceParameter):}{}
\item{Self SetConductanceScalingUpdateInterval(unsigned int ConductanceScalingUpdateInterval):}{}
\item{Self SetNumberOfIterations(uint32_t NumberOfIterations):}{}
\item{Self SetTimeStep(double TimeStep):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~GradientAnisotropicDiffusionImageFilter():}{
Destructor
}
}
}
