# Interface for submodule: VideoSource
from typing import Union, Any
# additional imports
from .support.template_class import itkTemplate as _itkTemplate


# Interface for class: VideoSource
from ._proxies import VideoSourceProxy as _VideoSourceProxy
class _VideoSourceTemplateGetter():
    def __getitem__(self, parameters) -> _VideoSourceTemplate:
        """Specify class type with:
            	[INSERT_TYPE_NAMES_HERE]
            :return: VideoSourceTemplate
            """
        ...


class _VideoSourceTemplate(_itkTemplate, metaclass=_VideoSourceTemplateGetter):
    """Interface for instantiating itk::VideoSource< INSERT_TYPE_NAMES_HERE >
        Create a new VideoSource Object (of default type):
            'itk.VideoSource.New(**kwargs)
        Supports type specification through dictionary access:
            'itk.VideoSource[INSERT_TYPE_NAMES_HERE].New(**kwargs)"""

    @staticmethod
    def New(**kwargs) -> _VideoSourceProxy:
        """Instantiate itk::VideoSource< INSERT_TYPE_NAMES_HERE >"""
        ...

VideoSource = _VideoSourceTemplate

