/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.StandardMBean;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.replay.ReplayStatistics;
import oracle.jdbc.replay.ReplayStatisticsMXBean;
import oracle.jdbc.replay.driver.ReplayStatisticsImpl;
import oracle.jdbc.replay.driver.StatisticsTracker;

public class ReplayStatisticsMBeanImpl
extends StandardMBean
implements ReplayStatisticsMXBean {
    public static final ReplayStatisticsMBeanImpl SOLE_INSTANCE = new ReplayStatisticsMBeanImpl();
    private static final Set<StatisticsTracker> trackerSet = Collections.synchronizedSet(new HashSet());
    private static ReplayStatisticsImpl STATS_ON_CLOSED_DS = new ReplayStatisticsImpl();

    private ReplayStatisticsMBeanImpl() {
        super(ReplayStatisticsMXBean.class, true);
    }

    public void addTrackerForDS(StatisticsTracker tracker) {
        trackerSet.add(tracker);
    }

    public void removeTrackerForDS(StatisticsTracker tracker) {
        trackerSet.remove(tracker);
        STATS_ON_CLOSED_DS.aggregate(tracker.getReplayStatistics());
    }

    @Override
    public String allStatistics() {
        long totalRequests = 0L;
        long totalCompletedRequests = 0L;
        long totalCalls = 0L;
        long totalProtectedCalls = 0L;
        long totalCallsAffectedByOutages = 0L;
        long totalCallsTriggeringReplay = 0L;
        long totalCallsAffectedByOutagesDuringReplay = 0L;
        long successfulReplayCount = 0L;
        long failedReplayCount = 0L;
        long replayDisablingCount = 0L;
        long totalReplayAttempts = 0L;
        int[] histogram = new int[31];
        for (StatisticsTracker tracker : trackerSet) {
            ReplayStatistics stats = tracker.getReplayStatistics();
            totalRequests += stats.getTotalRequests();
            totalCompletedRequests += stats.getTotalCompletedRequests();
            totalCalls += stats.getTotalCalls();
            totalProtectedCalls += stats.getTotalProtectedCalls();
            totalCallsAffectedByOutages += stats.getTotalCallsAffectedByOutages();
            totalCallsTriggeringReplay += stats.getTotalCallsTriggeringReplay();
            totalCallsAffectedByOutagesDuringReplay += stats.getTotalCallsAffectedByOutagesDuringReplay();
            successfulReplayCount += stats.getSuccessfulReplayCount();
            failedReplayCount += stats.getFailedReplayCount();
            replayDisablingCount += stats.getReplayDisablingCount();
            totalReplayAttempts += stats.getTotalReplayAttempts();
            int[] h = stats.getRequestSizeHistogram();
            if (h == null || h.length <= 0) continue;
            for (int i = 0; i < h.length; ++i) {
                int n = i;
                histogram[n] = histogram[n] + h[i];
            }
        }
        ReplayStatisticsImpl globalStats = new ReplayStatisticsImpl(totalRequests, totalCompletedRequests, totalCalls, totalProtectedCalls, totalCallsAffectedByOutages, totalCallsTriggeringReplay, totalCallsAffectedByOutagesDuringReplay, successfulReplayCount, failedReplayCount, replayDisablingCount, totalReplayAttempts, 0);
        globalStats.setRequestSizeHistogram(histogram);
        globalStats.aggregate(STATS_ON_CLOSED_DS);
        return globalStats.toString();
    }

    @Override
    public String getStatisticsForDataSource(String dataSourceName) {
        boolean foundOne = false;
        StringBuffer buf = new StringBuffer();
        for (StatisticsTracker tracker : trackerSet) {
            String dsName = tracker.getDataSourceName();
            if (dataSourceName == null || !dataSourceName.equals(dsName)) continue;
            if (!foundOne) {
                buf.append(tracker.getReplayStatistics().toString());
                foundOne = true;
                continue;
            }
            buf.append("\n\nWARNING: there are data sources with duplicate names and replay statistics is only reported for one of them. Check names and try again.");
            break;
        }
        if (!foundOne) {
            buf.append("WARNING: replay statistics not available for this data source name. Check name and try again.");
        }
        return buf.toString();
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        return DatabaseError.findMessage("ReplayStatisticsMBeanDescription", (Object)this);
    }

    @Override
    protected String getDescription(MBeanConstructorInfo info) {
        return DatabaseError.findMessage("ReplayStatisticsMBeanConstructor", (Object)this);
    }

    @Override
    protected String getDescription(MBeanOperationInfo info) {
        String n = info.getName();
        if (n.equals("allStatistics")) {
            return DatabaseError.findMessage("ReplayStatisticsMBeanAllStatisticsDescription", (Object)this);
        }
        if (n.equals("getStatisticsForDataSource")) {
            return DatabaseError.findMessage("ReplayStatisticsMBeanGetDSStatisticsDescription", (Object)this);
        }
        Logger.getLogger("oracle.jdbc.internal.replay").log(Level.SEVERE, "Got a request to describe an unexpected operation: " + n);
        return super.getDescription(info);
    }
}

