/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.compare;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.headers.Header;
import java.util.HashSet;
import java.util.Objects;
import org.openapitools.openapidiff.core.compare.OpenApiDiff;
import org.openapitools.openapidiff.core.compare.ReferenceDiffCache;
import org.openapitools.openapidiff.core.model.ChangedExample;
import org.openapitools.openapidiff.core.model.ChangedExamples;
import org.openapitools.openapidiff.core.model.ChangedHeader;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.deferred.DeferredBuilder;
import org.openapitools.openapidiff.core.model.deferred.DeferredChanged;
import org.openapitools.openapidiff.core.utils.RefPointer;
import org.openapitools.openapidiff.core.utils.RefType;

public class HeaderDiff
extends ReferenceDiffCache<Header, ChangedHeader> {
    private static final RefPointer<Header> refPointer = new RefPointer(RefType.HEADERS);
    private final OpenApiDiff openApiDiff;
    private final Components leftComponents;
    private final Components rightComponents;

    public HeaderDiff(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
        this.leftComponents = openApiDiff.getOldSpecOpenApi() != null ? openApiDiff.getOldSpecOpenApi().getComponents() : null;
        this.rightComponents = openApiDiff.getNewSpecOpenApi() != null ? openApiDiff.getNewSpecOpenApi().getComponents() : null;
    }

    public DeferredChanged<ChangedHeader> diff(Header left, Header right, DiffContext context) {
        return this.cachedDiff(new HashSet<String>(), left, right, left.get$ref(), right.get$ref(), context);
    }

    @Override
    protected DeferredChanged<ChangedHeader> computeDiff(HashSet<String> refSet, Header left, Header right, DiffContext context) {
        left = refPointer.resolveRef(this.leftComponents, left, left.get$ref());
        right = refPointer.resolveRef(this.rightComponents, right, right.get$ref());
        DeferredBuilder builder = new DeferredBuilder();
        ChangedHeader changedHeader = new ChangedHeader(left, right, context).setRequired(!Objects.equals(left.getRequired(), right.getRequired())).setDeprecated(!Objects.equals(left.getDeprecated(), right.getDeprecated())).setStyle(!Objects.equals((Object)left.getStyle(), (Object)right.getStyle())).setExplode(!Objects.equals(left.getExplode(), right.getExplode())).setExamples(new ChangedExamples(left.getExamples(), right.getExamples())).setExample(new ChangedExample(left.getExample(), right.getExample()));
        builder.with(this.openApiDiff.getMetadataDiff().diff(left.getDescription(), right.getDescription(), context)).ifPresent(changedHeader::setDescription);
        builder.with(this.openApiDiff.getSchemaDiff().diff(left.getSchema(), right.getSchema(), context.copyWithRequired(true))).ifPresent(changedHeader::setSchema);
        builder.with(this.openApiDiff.getContentDiff().diff(left.getContent(), right.getContent(), context)).ifPresent(changedHeader::setContent);
        builder.with(this.openApiDiff.getExtensionsDiff().diff(left.getExtensions(), right.getExtensions(), context)).ifPresent(changedHeader::setExtensions);
        return builder.buildIsChanged(changedHeader);
    }
}

