##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Auxiliary

  def initialize
    super(
      'Name' => 'VSploit DNS Beaconing Emulation',
      'Description' => 'This module takes a list of domains and emulates malicious DNS beaconing.',
      'Author' => 'MJC',
      'License' => MSF_LICENSE,
      'Notes' => {
        'Stability' => [CRASH_SAFE],
        'SideEffects' => [IOC_IN_LOGS],
        'Reliability' => []
      }
    )
    register_options(
      [
        OptString.new('DOMAINS', [ true, 'Separate domains by whitespace']),
        OptString.new('DNS_SERVER', [false, 'Specifies a DNS Server']),
        OptInt.new('COUNT', [false, 'Number of intervals to loop', 2]),
        OptInt.new('DELAY', [false, 'Delay in seconds between intervals', 3])
      ]
    )
  end

  def run
    @res = Net::DNS::Resolver.new
    # @res.retry = 2

    if datastore['DNS_SERVER']
      @res.nameservers = datastore['DNS_SERVER']
    end

    count = 0

    while count < datastore['COUNT']

      domain = datastore['DOMAINS'].split(/[\s,]+/)
      domain.each do |name|
        query = @res.query(name, 'A')
        time = Time.new
        time = time.strftime('%Y-%m-%d %H:%M:%S')
        print_status("#{time} - DNS Query sent for => #{name}")
        if query.answer.empty?
          print_error("#{time} - #{name} => No Record Found")
        else
          a = query.answer[0].to_s.split(/[\s,]+/)
          print_status("#{time} - #{name} => #{a[-1]}")
        end
      end
      unless count == (datastore['COUNT'] - 1)
        time = Time.new
        time = time.strftime('%Y-%m-%d %H:%M:%S')
        print_status("#{time} - Waiting #{datastore['DELAY']} seconds to beacon")
        select(nil, nil, nil, datastore['DELAY'])
      end
      count += 1
    end
  end
end
