# -*- coding: binary -*-
# frozen_string_literal: true

module Rex::Proto
  module MsCrtd
    # see: https://learn.microsoft.com/en-us/openspecs/windows_protocols/ms-crtd/4c6950e4-1dc2-4ae3-98c3-b8919bb73822

    # [2.4 flags Attribute](https://learn.microsoft.com/en-us/openspecs/windows_protocols/ms-crtd/6cc7eb79-3e84-477a-b398-b0ff2b68a6c0)
    CT_FLAG_AUTO_ENROLLMENT = 0x00000020
    CT_FLAG_MACHINE_TYPE = 0x00000040
    CT_FLAG_IS_CA = 0x00000080
    CT_FLAG_ADD_TEMPLATE_NAME = 0x00000200
    CT_FLAG_IS_CROSS_CA = 0x00000800
    CT_FLAG_IS_DEFAULT = 0x00010000
    CT_FLAG_IS_MODIFIED = 0x00020000
    CT_FLAG_DONOTPERSISTINDB = 0x00001000
    CT_FLAG_ADD_EMAIL = 0x00000002
    CT_FLAG_PUBLISH_TO_DS = 0x00000008
    CT_FLAG_EXPORTABLE_KEY = 0x00000010

    # [2.26 msPKI-Enrollment-Flag Attribute](https://learn.microsoft.com/en-us/openspecs/windows_protocols/ms-crtd/ec71fd43-61c2-407b-83c9-b52272dec8a1)
    CT_FLAG_INCLUDE_SYMMETRIC_ALGORITHMS = 0x00000001
    CT_FLAG_PEND_ALL_REQUESTS = 0x00000002
    CT_FLAG_PUBLISH_TO_KRA_CONTAINER = 0x00000004
    #CT_FLAG_PUBLISH_TO_DS = 0x00000008
    CT_FLAG_AUTO_ENROLLMENT_CHECK_USER_DS_CERTIFICATE = 0x00000010
    #CT_FLAG_AUTO_ENROLLMENT = 0x00000020
    CT_FLAG_PREVIOUS_APPROVAL_VALIDATE_REENROLLMENT = 0x00000040
    CT_FLAG_USER_INTERACTION_REQUIRED = 0x00000100
    CT_FLAG_REMOVE_INVALID_CERTIFICATE_FROM_PERSONAL_STORE = 0x00000400
    CT_FLAG_ALLOW_ENROLL_ON_BEHALF_OF = 0x00000800
    CT_FLAG_ADD_OCSP_NOCHECK = 0x00001000
    CT_FLAG_ENABLE_KEY_REUSE_ON_NT_TOKEN_KEYSET_STORAGE_FULL = 0x00002000
    CT_FLAG_NOREVOCATIONINFOINISSUEDCERTS = 0x00004000
    CT_FLAG_INCLUDE_BASIC_CONSTRAINTS_FOR_EE_CERTS = 0x00008000
    CT_FLAG_ALLOW_PREVIOUS_APPROVAL_KEYBASEDRENEWAL_VALIDATE_REENROLLMENT = 0x00010000
    CT_FLAG_ISSUANCE_POLICIES_FROM_REQUEST = 0x00020000
    CT_FLAG_SKIP_AUTO_RENEWAL = 0x00040000
    CT_FLAG_NO_SECURITY_EXTENSION = 0x80000

    # [2.27 msPKI-Private-Key-Flag Attribute](https://learn.microsoft.com/en-us/openspecs/windows_protocols/ms-crtd/f6122d87-b999-4b92-bff8-f465e8949667)
    CT_FLAG_REQUIRE_PRIVATE_KEY_ARCHIVAL = 0x00000001
    #CT_FLAG_EXPORTABLE_KEY = 0x00000010
    CT_FLAG_STRONG_KEY_PROTECTION_REQUIRED = 0x00000020
    CT_FLAG_REQUIRE_ALTERNATE_SIGNATURE_ALGORITHM = 0x00000040
    CT_FLAG_REQUIRE_SAME_KEY_RENEWAL = 0x00000080
    CT_FLAG_USE_LEGACY_PROVIDER = 0x00000100
    CT_FLAG_ATTEST_NONE = 0x00000000
    CT_FLAG_ATTEST_REQUIRED = 0x00002000
    CT_FLAG_ATTEST_PREFERRED = 0x00001000
    CT_FLAG_ATTESTATION_WITHOUT_POLICY = 0x00004000
    CT_FLAG_EK_TRUST_ON_USE = 0x00000200
    CT_FLAG_EK_VALIDATE_CERT = 0x00000400
    CT_FLAG_EK_VALIDATE_KEY = 0x00000800
    CT_FLAG_HELLO_LOGON_KEY = 0x00200000

    # [2.28 msPKI-Certificate-Name-Flag Attribute](https://learn.microsoft.com/en-us/openspecs/windows_protocols/ms-crtd/1192823c-d839-4bc3-9b6b-fa8c53507ae1)
    CT_FLAG_ENROLLEE_SUPPLIES_SUBJECT = 0x00000001
    CT_FLAG_ENROLLEE_SUPPLIES_SUBJECT_ALT_NAME = 0x00010000
    CT_FLAG_SUBJECT_ALT_REQUIRE_DOMAIN_DNS = 0x00400000
    CT_FLAG_SUBJECT_ALT_REQUIRE_SPN = 0x00800000
    CT_FLAG_SUBJECT_ALT_REQUIRE_DIRECTORY_GUID = 0x01000000
    CT_FLAG_SUBJECT_ALT_REQUIRE_UPN = 0x02000000
    CT_FLAG_SUBJECT_ALT_REQUIRE_EMAIL = 0x04000000
    CT_FLAG_SUBJECT_ALT_REQUIRE_DNS = 0x08000000
    CT_FLAG_SUBJECT_REQUIRE_DNS_AS_CN = 0x10000000
    CT_FLAG_SUBJECT_REQUIRE_EMAIL = 0x20000000
    CT_FLAG_SUBJECT_REQUIRE_COMMON_NAME = 0x40000000
    CT_FLAG_SUBJECT_REQUIRE_DIRECTORY_PATH = 0x80000000
    CT_FLAG_OLD_CERT_SUPPLIES_SUBJECT_AND_ALT_NAME = 0x00000008

  end
end
