/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.type;

import org.hibernate.dialect.Dialect;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.JsonJdbcType;

public class PostgreSQLCastingJsonJdbcType
extends JsonJdbcType {
    public static final PostgreSQLCastingJsonJdbcType JSON_INSTANCE = new PostgreSQLCastingJsonJdbcType(false, null);
    public static final PostgreSQLCastingJsonJdbcType JSONB_INSTANCE = new PostgreSQLCastingJsonJdbcType(true, null);
    private final boolean jsonb;

    public PostgreSQLCastingJsonJdbcType(boolean jsonb, EmbeddableMappingType embeddableMappingType) {
        super(embeddableMappingType);
        this.jsonb = jsonb;
    }

    @Override
    public int getDdlTypeCode() {
        return 3001;
    }

    @Override
    public AggregateJdbcType resolveAggregateJdbcType(EmbeddableMappingType mappingType, String sqlType, RuntimeModelCreationContext creationContext) {
        return new PostgreSQLCastingJsonJdbcType(this.jsonb, mappingType);
    }

    @Override
    public void appendWriteExpression(String writeExpression, SqlAppender appender, Dialect dialect) {
        appender.append("cast(");
        appender.append(writeExpression);
        appender.append(" as ");
        if (this.jsonb) {
            appender.append("jsonb)");
        } else {
            appender.append("json)");
        }
    }
}

