/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.CSSDOMImplementation;
import io.sf.carte.doc.dom.DOMAttr;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DOMNamedNodeMap;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.ext.LexicalHandler;

public class XMLDocumentBuilder
extends DocumentBuilder {
    private final DOMImplementation domImpl;
    private final SAXParserFactory parserFactory;
    private XMLReader xmlReader = null;
    private EntityResolver resolver = null;
    private ErrorHandler errorHandler = null;
    private boolean strictErrorChecking = false;
    private boolean htmlProcessing = false;
    private boolean ignoreElementContentWhitespace = false;
    private boolean ignoreNotSpecifiedAttributes = true;
    private static final HashSet<String> headChildList = new HashSet(8);

    public XMLDocumentBuilder(DOMImplementation domImpl) {
        this(domImpl, SAXParserFactory.newInstance());
        this.parserFactory.setNamespaceAware(true);
        try {
            this.parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            this.parserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.parserFactory.setFeature("http://xml.org/sax/features/xmlns-uris", true);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException exception) {
            // empty catch block
        }
    }

    public XMLDocumentBuilder(DOMImplementation domImpl, SAXParserFactory parserFactory) {
        this.domImpl = domImpl;
        this.parserFactory = parserFactory;
        if (domImpl instanceof CSSDOMImplementation) {
            this.strictErrorChecking = ((CSSDOMImplementation)domImpl).getStrictErrorChecking();
        }
    }

    @Override
    public Document parse(InputSource is) throws SAXException, IOException {
        XMLReader xmlReader = this.xmlReader == null ? this.createXMLReader() : this.xmlReader;
        return this.parse(is, xmlReader);
    }

    private XMLReader createXMLReader() throws SAXException {
        SAXParser saxParser;
        try {
            saxParser = this.parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
        XMLReader xmlReader = saxParser.getXMLReader();
        if (this.resolver != null) {
            xmlReader.setEntityResolver(this.resolver);
        } else {
            try {
                xmlReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                xmlReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
                // empty catch block
            }
        }
        XMLDocumentBuilder.setPropertyIfLower(xmlReader, "jdk.xml.maxParameterEntitySizeLimit", 262144);
        XMLDocumentBuilder.setPropertyIfLower(xmlReader, "jdk.xml.totalEntitySizeLimit", 0x100000);
        XMLDocumentBuilder.setPropertyIfLower(xmlReader, "jdk.xml.maxGeneralEntitySizeLimit", 0x100000);
        return xmlReader;
    }

    private static void setPropertyIfLower(XMLReader xmlReader, String property, int value) {
        try {
            int iold;
            String oldval = (String)xmlReader.getProperty(property);
            if (oldval == null || (iold = Integer.parseInt(oldval)) != 0 && iold < value) {
                xmlReader.setProperty(property, value);
            }
        }
        catch (RuntimeException | SAXNotRecognizedException | SAXNotSupportedException exception) {
            // empty catch block
        }
    }

    private Document parse(InputSource is, XMLReader xmlReader) throws SAXException, IOException {
        boolean errorHandlerSet = true;
        XMLContentHandler handler = this.htmlProcessing ? new XHTMLContentHandler(xmlReader) : new XMLContentHandler(xmlReader);
        handler.setSystemId(is.getSystemId());
        xmlReader.setContentHandler(handler);
        try {
            xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            // empty catch block
        }
        if (this.errorHandler != null) {
            xmlReader.setErrorHandler(this.errorHandler);
        } else if (xmlReader.getErrorHandler() == null) {
            xmlReader.setErrorHandler(handler);
        } else {
            errorHandlerSet = false;
        }
        xmlReader.parse(is);
        Document document = handler.getDocument();
        xmlReader.setContentHandler(null);
        try {
            xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", null);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            // empty catch block
        }
        if (errorHandlerSet) {
            xmlReader.setErrorHandler(null);
        }
        return document;
    }

    @Override
    public boolean isNamespaceAware() {
        return this.parserFactory.isNamespaceAware();
    }

    @Override
    public boolean isValidating() {
        return this.parserFactory.isValidating();
    }

    @Override
    public boolean isXIncludeAware() {
        return this.parserFactory.isXIncludeAware();
    }

    @Override
    public void setEntityResolver(EntityResolver er) {
        this.resolver = er;
    }

    @Override
    public void setErrorHandler(ErrorHandler eh) {
        this.errorHandler = eh;
    }

    @Override
    public Document newDocument() {
        return this.createDocument("", null, null, null);
    }

    private Document createDocument(String namespaceURI, String qualifiedName, DocumentType doctype, String systemId) throws DOMException {
        if (doctype != null && namespaceURI != null && namespaceURI.isEmpty() && "html".equals(doctype.getName())) {
            namespaceURI = null;
        }
        Document document = this.domImpl.createDocument(namespaceURI, qualifiedName, doctype);
        document.setStrictErrorChecking(this.strictErrorChecking);
        document.setDocumentURI(systemId);
        return document;
    }

    @Override
    public DOMImplementation getDOMImplementation() {
        return this.domImpl;
    }

    public SAXParserFactory getSAXParserFactory() {
        return this.parserFactory;
    }

    @Override
    public Schema getSchema() {
        return this.parserFactory.getSchema();
    }

    public void setHTMLProcessing(boolean html) {
        this.htmlProcessing = html;
    }

    public void setIgnoreElementContentWhitespace(boolean ignore) {
        this.ignoreElementContentWhitespace = ignore;
    }

    public void setIgnoreNotSpecifiedAttributes(boolean ignore) {
        this.ignoreNotSpecifiedAttributes = ignore;
    }

    public boolean isStrictErrorChecking() {
        return this.strictErrorChecking;
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
        this.strictErrorChecking = strictErrorChecking;
    }

    public void setXMLReader(XMLReader xmlReader) {
        this.xmlReader = xmlReader;
    }

    public XMLReader getXMLReader() {
        return this.xmlReader;
    }

    @Override
    public void reset() {
        this.strictErrorChecking = this.domImpl instanceof CSSDOMImplementation ? ((CSSDOMImplementation)this.domImpl).getStrictErrorChecking() : false;
        this.ignoreElementContentWhitespace = false;
        this.resolver = null;
        this.errorHandler = null;
    }

    private static boolean isHeadChild(String qName) {
        return headChildList.contains(qName);
    }

    static {
        headChildList.add("base");
        headChildList.add("link");
        headChildList.add("meta");
        headChildList.add("noscript");
        headChildList.add("script");
        headChildList.add("style");
        headChildList.add("template");
        headChildList.add("title");
    }

    private class XHTMLContentHandler
    extends XMLContentHandler {
        private boolean headPending;
        private boolean bodyPending;
        private boolean headImplicit;
        private boolean bodyImplicit;

        XHTMLContentHandler(XMLReader xmlReader) {
            super(xmlReader);
            this.headPending = true;
            this.bodyPending = true;
            this.headImplicit = false;
            this.bodyImplicit = false;
        }

        @Override
        void documentElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            boolean isXHTML;
            boolean bl = isXHTML = "http://www.w3.org/1999/xhtml".equals(uri) || this.documentType != null && "html".equalsIgnoreCase(this.documentType.getName());
            if (!"html".equals(localName) && isXHTML) {
                String deQname = "html";
                if (!qName.equalsIgnoreCase(localName)) {
                    int idx = qName.indexOf(58, 1);
                    if (idx != -1) {
                        deQname = qName.substring(0, idx) + ":html";
                    } else {
                        this.error("Invalid qName: " + qName);
                    }
                }
                this.document = XMLDocumentBuilder.this.createDocument(uri, deQname, this.documentType, this.systemId);
                this.currentNode = this.document.getDocumentElement();
                this.newElement(uri, localName, qName, atts);
            } else {
                this.document = XMLDocumentBuilder.this.createDocument(uri, qName, this.documentType, this.systemId);
                Element element = this.document.getDocumentElement();
                this.currentNode = element;
                this.setAttributes(element, atts);
                if (!isXHTML) {
                    this.headPending = false;
                    this.bodyPending = false;
                }
            }
        }

        @Override
        void newElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            Element element = this.document.createElementNS(uri, qName);
            this.setAttributes(element, atts);
            if (this.headPending && this.currentNode.getParentNode() == this.document) {
                if ("head".equals(qName)) {
                    this.appendChild(element);
                    this.headPending = false;
                    this.currentNode = element;
                    return;
                }
                if (XMLDocumentBuilder.isHeadChild(qName)) {
                    Element head = this.document.createElementNS(uri, "head");
                    this.currentNode.appendChild(head);
                    head.appendChild(element);
                    this.headImplicit = true;
                    this.headPending = false;
                    this.currentNode = element;
                    return;
                }
            }
            if (this.bodyPending && (this.currentNode.getParentNode() == this.document || this.headImplicit && this.currentNode.getParentNode().getParentNode() == this.document)) {
                if ("body".equals(qName)) {
                    if (this.headImplicit) {
                        this.currentNode = this.currentNode.getParentNode();
                        this.headImplicit = false;
                    } else {
                        this.headPending = false;
                    }
                    this.bodyPending = false;
                } else if (!XMLDocumentBuilder.isHeadChild(qName)) {
                    if (this.headImplicit) {
                        this.currentNode = this.currentNode.getParentNode();
                        this.headImplicit = false;
                    } else {
                        this.headPending = false;
                    }
                    Element body = this.document.createElementNS(uri, "body");
                    this.currentNode.appendChild(body);
                    body.appendChild(element);
                    this.currentNode = element;
                    this.bodyPending = false;
                    this.bodyImplicit = true;
                    return;
                }
            }
            this.appendChild(element);
            this.currentNode = element;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.currentNode = this.currentNode.getParentNode();
            if ((this.bodyImplicit || this.headImplicit) && "html".equals(this.currentNode.getNodeName())) {
                this.currentNode = this.currentNode.getParentNode();
            }
        }
    }

    private class XMLContentHandler
    implements ContentHandler,
    LexicalHandler,
    ErrorHandler {
        String systemId = null;
        Document document = null;
        DocumentType documentType = null;
        private LinkedList<MockNode> preDocTypeNodes = null;
        private LinkedList<MockNode> preDocElementNodes = null;
        Node currentNode = null;
        private Locator lastLocator = null;
        private boolean cdata = false;
        private boolean endDTD = true;
        private final boolean ignoreECW;
        final boolean isNativeDOM;
        final boolean hasAttributes2;
        private final AttributeProcessor attrProcessor;

        XMLContentHandler(XMLReader xmlReader) {
            this.ignoreECW = XMLDocumentBuilder.this.ignoreElementContentWhitespace;
            this.isNativeDOM = XMLDocumentBuilder.this.domImpl instanceof CSSDOMImplementation;
            this.hasAttributes2 = this.hasAttributes2Feature(xmlReader);
            this.attrProcessor = XMLDocumentBuilder.this.ignoreNotSpecifiedAttributes ? new AttributeProcessor() : new NotSpecifiedAttributeProcessor();
        }

        void setSystemId(String systemId) {
            this.systemId = systemId;
        }

        private boolean hasAttributes2Feature(XMLReader xmlReader) {
            boolean result;
            try {
                result = xmlReader.getFeature("http://xml.org/sax/features/use-attributes2");
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException e) {
                result = false;
            }
            return result;
        }

        Document getDocument() {
            return this.document;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.lastLocator = locator;
        }

        @Override
        public void startDocument() throws SAXException {
            this.document = null;
        }

        @Override
        public void endDocument() throws SAXException {
            this.currentNode = null;
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (this.document == null) {
                this.documentElement(uri, localName, qName, atts);
                this.insertPreDocElementNodes();
            } else {
                this.newElement(uri, localName, qName, atts);
            }
        }

        void documentElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            this.document = XMLDocumentBuilder.this.createDocument(uri, qName, this.documentType, this.systemId);
            Element element = this.document.getDocumentElement();
            this.currentNode = element;
            this.setAttributes(element, atts);
        }

        void newElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            Element element = this.document.createElementNS(uri, qName);
            this.setAttributes(element, atts);
            this.appendChild(element);
            this.currentNode = element;
        }

        void setAttributes(Element element, Attributes atts) throws SAXException {
            this.attrProcessor.setAttributes(element, atts);
        }

        private void insertPreDocElementNodes() {
            if (this.preDocTypeNodes != null) {
                Node refNode = this.documentType;
                if (refNode == null) {
                    refNode = this.document.getDocumentElement();
                }
                for (MockNode mock : this.preDocTypeNodes) {
                    this.insertMockNode(mock, refNode);
                }
            }
            if (this.preDocElementNodes != null) {
                Element docElm = this.document.getDocumentElement();
                for (MockNode mock : this.preDocElementNodes) {
                    this.insertMockNode(mock, docElm);
                }
            }
        }

        private void insertMockNode(MockNode mock, Node refNode) {
            if (mock.getNodeType() == 8) {
                this.document.insertBefore(this.document.createComment(mock.getData()), refNode);
            } else {
                this.document.insertBefore(this.document.createProcessingInstruction(((MockProcessingInstruction)mock).getTarget(), mock.getData()), refNode);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.currentNode = this.currentNode.getParentNode();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            Node node;
            String s = new String(ch, start, length);
            if (this.currentNode == null) {
                this.error("Text outside of root element: " + s);
            }
            int type = (node = this.currentNode.getLastChild()) == null ? -1 : (int)node.getNodeType();
            if (!this.cdata && type == 3 || this.cdata && type == 4) {
                Text text = (Text)node;
                text.appendData(s);
            } else if (!this.cdata) {
                this.appendChild(this.document.createTextNode(s));
            } else {
                this.appendChild(this.document.createCDATASection(s));
            }
        }

        void appendChild(Node node) throws SAXException {
            try {
                this.currentNode.appendChild(node);
            }
            catch (DOMException e) {
                this.error("Error appending child " + node.getNodeName() + " to " + this.currentNode.getNodeName(), e);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (!this.ignoreECW && this.currentNode != null) {
                String s = new String(ch, start, length);
                Node node = this.currentNode.getLastChild();
                int type = node == null ? -1 : (int)node.getNodeType();
                if (this.cdata && type == 4) {
                    Text text = (Text)node;
                    text.appendData(s);
                } else if (!this.cdata) {
                    this.appendChild(this.document.createTextNode(s));
                } else {
                    this.appendChild(this.document.createCDATASection(s));
                }
            }
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            if (this.currentNode != null) {
                this.appendChild(this.document.createProcessingInstruction(target, data));
            } else if (this.document != null) {
                this.document.appendChild(this.document.createProcessingInstruction(target, data));
            } else if (this.endDTD) {
                if (this.documentType == null) {
                    if (this.preDocTypeNodes == null) {
                        this.preDocTypeNodes = new LinkedList();
                    }
                    this.preDocTypeNodes.add(new MockProcessingInstruction(target, data));
                } else {
                    if (this.preDocElementNodes == null) {
                        this.preDocElementNodes = new LinkedList();
                    }
                    this.preDocElementNodes.add(new MockProcessingInstruction(target, data));
                }
            }
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            if (this.documentType != null || this.document != null) {
                this.error("DTD must be the first node in a document (except PIs and comments)");
            }
            this.documentType = XMLDocumentBuilder.this.domImpl.createDocumentType(name, publicId, systemId);
            this.endDTD = false;
        }

        @Override
        public void endDTD() throws SAXException {
            this.endDTD = true;
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
            this.cdata = true;
        }

        @Override
        public void endCDATA() throws SAXException {
            this.cdata = false;
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            String comment = new String(ch, start, length);
            if (this.currentNode != null) {
                this.appendChild(this.document.createComment(comment));
            } else if (this.document != null) {
                this.document.appendChild(this.document.createComment(comment));
            } else if (this.endDTD) {
                if (this.documentType == null) {
                    if (this.preDocTypeNodes == null) {
                        this.preDocTypeNodes = new LinkedList();
                    }
                    this.preDocTypeNodes.add(new MockCommentNode(comment));
                } else {
                    if (this.preDocElementNodes == null) {
                        this.preDocElementNodes = new LinkedList();
                    }
                    this.preDocElementNodes.add(new MockCommentNode(comment));
                }
            }
        }

        void error(String message) throws SAXException {
            if (this.lastLocator == null) {
                throw new SAXException(message);
            }
            throw new SAXParseException(message, this.lastLocator);
        }

        private void error(String message, Exception ex) throws SAXException {
            if (this.lastLocator == null) {
                throw new SAXException(message, ex);
            }
            throw new SAXParseException(message, this.lastLocator, ex);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }

        private class AttributeProcessor {
            private AttributeProcessor() {
            }

            void setAttributes(Element element, Attributes atts) throws SAXException {
                int len = atts.getLength();
                for (int i = 0; i < len; ++i) {
                    Attributes2 atts2;
                    String namespaceURI = atts.getURI(i);
                    String value = atts.getValue(i);
                    if (XMLContentHandler.this.isNativeDOM && "http://www.w3.org/XML/1998/namespace".equals(namespaceURI) && "space".equals(atts.getLocalName(i)) && "preserve".equalsIgnoreCase(value)) {
                        ((DOMElement)element).setRawText();
                    }
                    if (XMLContentHandler.this.hasAttributes2 && !(atts2 = (Attributes2)atts).isSpecified(i)) continue;
                    String attrQName = atts.getQName(i);
                    Attr attr = XMLContentHandler.this.document.createAttributeNS(namespaceURI, attrQName);
                    attr.setValue(value);
                    if (XMLContentHandler.this.isNativeDOM) {
                        ((DOMNamedNodeMap)element.getAttributes()).setNamedItemUnchecked(attr);
                        continue;
                    }
                    element.getAttributes().setNamedItem(attr);
                    if (!"ID".equals(atts.getType(i)) && (!"id".equals(attrQName) || element.getNamespaceURI() == XMLContentHandler.this.document.getNamespaceURI())) continue;
                    element.setIdAttributeNode(attr, true);
                }
            }
        }

        private class NotSpecifiedAttributeProcessor
        extends AttributeProcessor {
            private NotSpecifiedAttributeProcessor() {
            }

            @Override
            void setAttributes(Element element, Attributes atts) throws SAXException {
                int len = atts.getLength();
                for (int i = 0; i < len; ++i) {
                    String namespaceURI = atts.getURI(i);
                    String value = atts.getValue(i);
                    String attrQName = atts.getQName(i);
                    Attr attr = XMLContentHandler.this.document.createAttributeNS(namespaceURI, attrQName);
                    attr.setValue(value);
                    if (XMLContentHandler.this.isNativeDOM) {
                        if (XMLContentHandler.this.hasAttributes2) {
                            ((DOMAttr)attr).specified = ((Attributes2)atts).isSpecified(i);
                        }
                        if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI) && "space".equals(atts.getLocalName(i)) && "preserve".equalsIgnoreCase(value)) {
                            ((DOMElement)element).setRawText();
                        }
                        ((DOMNamedNodeMap)element.getAttributes()).setNamedItemUnchecked(attr);
                        continue;
                    }
                    element.getAttributes().setNamedItem(attr);
                    if (!"ID".equals(atts.getType(i)) && (!"id".equals(attrQName) || element.getNamespaceURI() == XMLContentHandler.this.document.getNamespaceURI())) continue;
                    element.setIdAttributeNode(attr, true);
                }
            }
        }
    }

    private static class MockProcessingInstruction
    extends MockNode {
        String target = null;

        MockProcessingInstruction(String target, String data) {
            super(data);
            this.target = target;
        }

        @Override
        short getNodeType() {
            return 7;
        }

        String getTarget() {
            return this.target;
        }
    }

    private static class MockCommentNode
    extends MockNode {
        MockCommentNode(String data) {
            super(data);
        }

        @Override
        short getNodeType() {
            return 8;
        }
    }

    static abstract class MockNode {
        String data = null;

        MockNode(String data) {
            this.data = data;
        }

        abstract short getNodeType();

        String getData() {
            return this.data;
        }
    }
}

