/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.AttributeNamedNodeMap;
import io.sf.carte.doc.dom.DOMAttr;
import io.sf.carte.doc.dom.DOMDocument;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.DOMNodeList;
import io.sf.carte.doc.dom.ElementList;
import io.sf.carte.doc.style.css.CSSRule;
import io.sf.carte.doc.style.css.CSSRuleList;
import io.sf.carte.doc.style.css.CSSStyleRule;
import io.sf.carte.doc.style.css.CSSStyleSheet;
import io.sf.carte.doc.style.css.nsac.ElementSelector;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.xml.dtd.DefaultEntityResolver;
import io.sf.carte.doc.xml.dtd.EntityFinder;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class DOMWriter {
    private String indentingUnit = "  ";
    private final StringBuilder indentString = new StringBuilder(48);
    private HashMap<Integer, String> entityMap = null;
    private EntityResolver2 resolver = null;
    private CSSStyleSheet<?> uaSheet;
    private HashMap<String, String> displayMap = null;
    private Node rootNode = null;

    public DOMWriter() {
    }

    public DOMWriter(CSSStyleSheet<? extends CSSRule> refSheet) {
        this.uaSheet = refSheet;
    }

    public int setEntityCodepoints(DocumentType docType, int[] entities) throws SAXException, IOException {
        InputSource is;
        if (docType == null || entities == null) {
            throw new NullPointerException();
        }
        int ret = 0;
        if (this.entityMap == null) {
            this.entityMap = new HashMap(entities.length + 2);
            this.entityMap.put(60, "lt");
            this.entityMap.put(62, "gt");
        }
        for (int entity : entities) {
            this.entityMap.putIfAbsent(entity, null);
        }
        if (this.resolver == null) {
            this.resolver = new DefaultEntityResolver();
        }
        if ((is = this.resolver.resolveEntity(docType.getName(), docType.getPublicId(), docType.getBaseURI(), docType.getSystemId())) != null) {
            EntityFinder finder = new EntityFinder(this.resolver);
            Reader re = is.getCharacterStream();
            ret = finder.findEntities(this.entityMap, re);
            re.close();
        }
        return ret;
    }

    public void setEntityResolver(EntityResolver2 resolver) {
        this.resolver = resolver;
    }

    public void setIndentingUnit(int whitespaceCount) {
        if (whitespaceCount < 0) {
            throw new IllegalArgumentException("Negative count");
        }
        StringBuilder buf = new StringBuilder(whitespaceCount);
        for (int i = 0; i < whitespaceCount; ++i) {
            buf.append(' ');
        }
        this.indentingUnit = buf.toString();
    }

    public static void writeTree(Node root, SimpleWriter writer) throws DOMException, IOException {
        DOMWriter domWriter = new DOMWriter();
        domWriter.writeNode(root, writer);
    }

    public String serializeToString(Node root) throws DOMException {
        BufferSimpleWriter writer = new BufferSimpleWriter(512);
        try {
            this.writeNode(root, (SimpleWriter)writer);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return writer.toString();
    }

    public void writeNode(Node root, SimpleWriter writer) throws DOMException, IOException {
        this.rootNode = root;
        CSSStyleSheet<?> oldUaSheet = this.uaSheet;
        if (oldUaSheet == null) {
            DOMDocument doc = (DOMDocument)this.getOwnerDocument();
            this.uaSheet = doc.getImplementation().getUserAgentStyleSheet(doc.getComplianceMode());
        }
        this.writeNode(root, writer, true);
        this.uaSheet = oldUaSheet;
        this.rootNode = null;
    }

    protected void writeNode(Node node, SimpleWriter wri, boolean indented) throws DOMException, IOException {
        switch (node.getNodeType()) {
            case 1: {
                this.writeElement((DOMElement)node, wri, indented);
                break;
            }
            case 3: {
                Text text = (Text)node;
                if (!text.isElementContentWhitespace() || this.isParentWhitespacePreserving(text)) {
                    this.writeText(text, wri, indented);
                    break;
                }
                if (indented) break;
                this.writeElementContentWhitespace(text, wri);
                break;
            }
            case 4: {
                this.writeCDataSection((CDATASection)node, wri);
                break;
            }
            case 8: {
                this.writeComment((Comment)node, wri, indented);
                break;
            }
            case 7: {
                this.writeProcessingInstruction((ProcessingInstruction)node, wri);
                break;
            }
            case 10: {
                this.writeDocumentType((DocumentType)node, wri);
                break;
            }
            case 9: 
            case 11: {
                if (!node.hasChildNodes()) break;
                this.writeChildNodes(node, wri, indented);
                break;
            }
            case 5: {
                this.writeEntityReference(node, wri);
                break;
            }
            default: {
                wri.write((CharSequence)node.toString());
            }
        }
    }

    protected void writeElement(DOMElement element, SimpleWriter wri, boolean indented) throws DOMException, IOException {
        if (indented) {
            this.startIndentedNode(element, wri);
        }
        String tagname = element.getTagName();
        wri.write('<');
        wri.write((CharSequence)tagname);
        String nsUri = element.getNamespaceURI();
        DOMNode parentNode = element.getParentNode();
        if (parentNode != null) {
            String nsPrefix = element.getPrefix();
            if (nsUri != null && nsPrefix != null && !nsPrefix.equals(parentNode.lookupPrefix(nsUri)) && !this.hasXmlnsAttr(element.getAttributes(), nsPrefix, nsUri)) {
                Attr attr = this.getOwnerDocument().createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + nsPrefix);
                attr.setValue(nsUri);
                wri.write(' ');
                this.writeAttribute(attr, wri);
            }
        }
        this.writeAttributes(element.getAttributes(), wri);
        if (element.hasChildNodes() || !element.isNonHTMLOrVoid()) {
            wri.write('>');
            boolean ast = this.afterStartTag(element, wri);
            if (element.hasChildNodes()) {
                if (ast) {
                    this.startIndentedNodeList(element, wri);
                }
                this.writeChildNodes(element, wri, ast);
                if (ast) {
                    this.endIndentedNodeList(element, wri);
                }
            }
            if (ast) {
                this.writeFullIndent(wri);
            }
            wri.write((CharSequence)"</");
            wri.write((CharSequence)tagname);
            wri.write((CharSequence)">");
        } else {
            if (nsUri == "http://www.w3.org/1999/xhtml") {
                wri.write(' ');
            }
            wri.write((CharSequence)"/>");
        }
        if (indented) {
            this.endIndentedNode(element, wri);
        }
    }

    private boolean hasXmlnsAttr(AttributeNamedNodeMap attributeMap, String nsPrefix, String nsUri) throws DOMException {
        if (!attributeMap.isEmpty()) {
            for (Attr attr : attributeMap) {
                if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) || !nsUri.equals(attr.getValue())) continue;
                String localName = attr.getLocalName();
                String prefix = attr.getPrefix();
                if (!"xmlns".equals(prefix)) continue;
                if (nsPrefix.equals(localName)) {
                    return true;
                }
                throw new DOMException(14, "Two prefixes for same namespace (" + nsUri + "): '" + nsPrefix + "' and '" + prefix + "'.");
            }
        }
        return false;
    }

    protected void writeAttributes(AttributeNamedNodeMap nodeMap, SimpleWriter wri) throws IOException {
        for (Attr attr : nodeMap) {
            if (!attr.getSpecified()) continue;
            wri.write(' ');
            this.writeAttribute(attr, wri);
        }
    }

    protected void writeAttribute(Attr attr, SimpleWriter wri) throws IOException {
        ((DOMAttr)attr).write(wri);
    }

    protected void writeChildNodes(Node parent, SimpleWriter wri, boolean indented) throws DOMException, IOException {
        DOMNodeList list = ((DOMNode)parent).getChildNodes();
        for (DOMNode node : list) {
            this.writeNode(node, wri, indented);
        }
    }

    private boolean isParentWhitespacePreserving(Text text) {
        Node node = text.getParentNode();
        if (node.getNodeType() == 1) {
            String value = ((DOMElement)node).getComputedStyle(null).getPropertyValue("white-space");
            return "pre".equalsIgnoreCase(value) || "pre-wrap".equalsIgnoreCase(value) || "break-spaces".equalsIgnoreCase(value);
        }
        return false;
    }

    protected void writeText(Text text, SimpleWriter wri, boolean indented) throws IOException {
        boolean doIndent = indented && !this.previousSiblingWasTextOrERef(text);
        Node node = text.getParentNode();
        if (node != null && node.getNodeType() == 1 && this.isRawTextElement((DOMElement)node)) {
            String parentLName = node.getLocalName();
            this.writeRawText(text, parentLName, wri);
        } else {
            this.writeNonRawText(text, wri, doIndent);
        }
    }

    private boolean previousSiblingWasTextOrERef(Text text) {
        short type;
        Node previous = text.getPreviousSibling();
        return previous != null && ((type = previous.getNodeType()) == 3 || type == 5);
    }

    protected boolean isRawTextElement(DOMElement element) {
        return element.isRawText();
    }

    protected void writeRawText(Text text, String parentLocalName, SimpleWriter wri) throws IOException {
        wri.write((CharSequence)DOMDocument.escapeCloseTag(parentLocalName, text.getData()));
    }

    protected void writeNonRawText(Text text, SimpleWriter wri, boolean indented) throws IOException {
        String s = text.getData();
        if (indented) {
            String last = s;
            StringTokenizer st = new StringTokenizer(s, "\n");
            while (st.hasMoreTokens()) {
                this.writeFullIndent(wri);
                last = st.nextToken();
                this.writeTextLine(last, wri);
            }
            if (!last.endsWith("\n")) {
                this.endIndentedNode(text, wri);
            }
        } else {
            this.writeTextLine(s, wri);
        }
    }

    protected void writeTextLine(String line, SimpleWriter wri) throws IOException {
        if (line.length() != 0) {
            if (this.entityMap != null) {
                try {
                    line = this.replaceByEntities(line);
                }
                catch (SAXException sAXException) {}
            } else {
                line = DOMDocument.escapeLtGtEntities(line);
            }
            wri.write((CharSequence)line);
        }
    }

    protected String replaceByEntities(String line) throws SAXException, IOException {
        StringBuilder buf = null;
        int len = line.length();
        int i = 0;
        while (i < len) {
            int cp = line.codePointAt(i);
            if (this.entityMap.containsKey(cp)) {
                String entity = this.entityMap.get(cp);
                if (buf == null) {
                    buf = new StringBuilder(len + 64);
                    buf.append(line.subSequence(0, i));
                }
                buf.append('&');
                if (entity != null) {
                    buf.append(entity);
                } else {
                    buf.append('#').append(cp);
                }
                buf.append(';');
            } else if (buf != null) {
                buf.appendCodePoint(cp);
            }
            i = line.offsetByCodePoints(i, 1);
        }
        return buf == null ? line : buf.toString();
    }

    private Document getOwnerDocument() {
        Document doc = this.rootNode.getNodeType() == 9 ? (Document)this.rootNode : this.rootNode.getOwnerDocument();
        return doc;
    }

    protected void writeElementContentWhitespace(Text text, SimpleWriter wri) throws IOException {
        Node nsiblingNd;
        Node psiblingNd = text.getPreviousSibling();
        String data = text.getData();
        if (data.length() == 0 || psiblingNd == null || (nsiblingNd = text.getNextSibling()) == null || this.isBlockElementNode(psiblingNd) || this.isBlockElementNode(nsiblingNd)) {
            return;
        }
        if (data.indexOf(10) != -1) {
            wri.newLine();
            this.writeFullIndent(wri);
        } else {
            wri.write(' ');
        }
    }

    private boolean isBlockElementNode(Node node) {
        if (node.getNodeType() == 1) {
            DOMElement element = (DOMElement)node;
            ComputedCSSStyle style = element.getComputedStyle(null);
            String display = style.getPropertyValue("display");
            if (display.length() == 0) {
                display = this.getDisplayProperty(element);
            }
            if ("block".equalsIgnoreCase(display) || "table".equalsIgnoreCase(display) || "table-row".equalsIgnoreCase(display) || "inline-block".equalsIgnoreCase(display)) {
                return true;
            }
        }
        return false;
    }

    protected void writeCDataSection(CDATASection data, SimpleWriter wri) throws IOException {
        boolean indentMe;
        AbstractDOMNode parentNode = ((AbstractDOMNode)((Object)data)).parentNode();
        boolean bl = indentMe = parentNode == null || parentNode.getNodeType() != 1 || !((DOMElement)parentNode).isRawText();
        if (indentMe) {
            this.startIndentedNode(data, wri);
        }
        wri.write((CharSequence)"<![CDATA[");
        wri.write((CharSequence)data.getData());
        wri.write((CharSequence)"]]>");
        if (indentMe) {
            this.endIndentedNode(data, wri);
        }
    }

    protected void writeComment(Comment comment, SimpleWriter wri, boolean indented) throws IOException {
        if (indented) {
            this.startIndentedNode(comment, wri);
        }
        wri.write((CharSequence)"<!--");
        wri.write((CharSequence)comment.getData());
        wri.write((CharSequence)"-->");
        if (indented) {
            this.endIndentedNode(comment, wri);
        }
    }

    protected void writeDocumentType(DocumentType docType, SimpleWriter wri) throws IOException {
        this.startIndentedNode(docType, wri);
        String systemId = docType.getSystemId();
        boolean hasSystemId = systemId != null && systemId.length() != 0;
        wri.write((CharSequence)"<!DOCTYPE ");
        String name = docType.getName();
        name = DOMAttr.escapeAttributeEntities(name);
        wri.write((CharSequence)name);
        String publicId = docType.getPublicId();
        if (publicId != null && publicId.length() != 0) {
            wri.write((CharSequence)" PUBLIC \"");
            wri.write((CharSequence)DOMAttr.escapeAttributeEntities(publicId));
            wri.write('\"');
        } else if (hasSystemId) {
            wri.write((CharSequence)" SYSTEM");
        }
        if (hasSystemId) {
            wri.write((CharSequence)" \"");
            wri.write((CharSequence)DOMAttr.escapeAttributeEntities(systemId));
            wri.write('\"');
        }
        wri.write('>');
        this.endIndentedNode(docType, wri);
    }

    protected void writeProcessingInstruction(ProcessingInstruction pi, SimpleWriter wri) throws IOException {
        this.startIndentedNode(pi, wri);
        wri.write((CharSequence)"<?");
        wri.write((CharSequence)pi.getTarget());
        wri.write(' ');
        wri.write((CharSequence)pi.getData());
        wri.write((CharSequence)"?>");
        this.endIndentedNode(pi, wri);
    }

    protected void writeEntityReference(Node node, SimpleWriter wri) throws IOException {
        wri.write('&');
        wri.write((CharSequence)node.getNodeName());
        wri.write(';');
    }

    protected void startIndentedNodeList(Node parent, SimpleWriter wri) throws IOException {
        this.deepenIndent();
    }

    protected void startIndentedNode(Node node, SimpleWriter wri) throws IOException {
        this.writeFullIndent(wri);
    }

    protected void endIndentedNode(Node node, SimpleWriter wri) throws IOException {
        wri.newLine();
    }

    protected void endIndentedNodeList(Node listParent, SimpleWriter wri) throws IOException {
        this.updateIndent(listParent);
    }

    protected boolean afterStartTag(DOMElement element, SimpleWriter wri) throws IOException {
        boolean indentChild = false;
        boolean startsWithNL = false;
        ElementList elist = element.getChildren();
        if (!elist.isEmpty()) {
            for (DOMElement el : elist) {
                String display = this.getDisplayProperty(el);
                if (!"block".equalsIgnoreCase(display) && !"table".equalsIgnoreCase(display) && !"table-row".equalsIgnoreCase(display) && !"inline-block".equalsIgnoreCase(display)) continue;
                indentChild = true;
                break;
            }
            StringBuilder buf = new StringBuilder(128);
            this.effectiveTextContent(element, buf);
            int len = buf.length();
            if (len != 0) {
                boolean bl = startsWithNL = buf.charAt(0) == '\n';
                if (!indentChild) {
                    boolean bl2 = indentChild = len > 64;
                    if (!indentChild) {
                        boolean bl3 = indentChild = buf.charAt(len - 1) == '\n';
                    }
                }
            }
            if (!(!indentChild || this.isRawTextElement(element) && startsWithNL)) {
                wri.newLine();
            }
        }
        return indentChild;
    }

    private void effectiveTextContent(DOMElement element, StringBuilder buf) {
        boolean foundElement = false;
        Iterator<DOMNode> it = element.iterator();
        while (it.hasNext()) {
            DOMNode child = it.next();
            short type = child.getNodeType();
            if (type == 1) {
                if (child.hasChildNodes()) {
                    this.effectiveTextContent((DOMElement)child, buf);
                }
                foundElement = true;
                continue;
            }
            if (type == 3) {
                if (!((Text)((Object)child)).isElementContentWhitespace()) {
                    buf.append(child.getNodeValue());
                    continue;
                }
                if (!foundElement) continue;
                buf.append(' ');
                continue;
            }
            if (type != 4) continue;
            buf.append(child.getNodeValue());
        }
    }

    protected String getDisplayProperty(Element element) {
        CSSRuleList<CSSRule> list;
        String display;
        String localName = element.getLocalName();
        if (this.displayMap == null) {
            this.displayMap = new HashMap();
        }
        if ((display = this.displayMap.get(localName)) == null && this.uaSheet != null && (list = this.uaSheet.getRulesForProperty("display")) != null) {
            for (CSSRule rule : list) {
                if (rule.getType() != 1) continue;
                CSSStyleRule stylerule = (CSSStyleRule)rule;
                SelectorList selist = stylerule.getSelectorList();
                for (int i = 0; i < selist.getLength(); ++i) {
                    Selector sel = selist.item(i);
                    if (sel.getSelectorType() != Selector.SelectorType.ELEMENT || !localName.equals(((ElementSelector)sel).getLocalName()) || (display = stylerule.getStyle().getPropertyValue("display")) == null) continue;
                    this.displayMap.put(localName, display);
                    return display;
                }
            }
        }
        return display;
    }

    protected void deepenIndent() {
        this.indentString.append(this.indentingUnit);
    }

    protected void updateIndent(Node node) {
        Node parent;
        this.indentString.setLength(0);
        if (parent != null) {
            for (parent = node.getParentNode(); parent != this.rootNode; parent = parent.getParentNode()) {
                this.deepenIndent();
            }
        }
    }

    protected void writeFullIndent(SimpleWriter wri) throws IOException {
        wri.write((CharSequence)this.indentString);
    }
}

