/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.xml.dtd;

import io.sf.carte.doc.xml.dtd.DefaultEntityResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class SMDTDLoader
extends DefaultEntityResolver.DTDLoader {
    @Override
    void connect(final URLConnection con) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    con.connect();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    @Override
    Reader loadDTDfromClasspath(final ClassLoader loader, final String dtdFilename) {
        InputStream is = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                InputStream is = loader != null ? loader.getResourceAsStream(dtdFilename) : DefaultEntityResolver.class.getResourceAsStream(dtdFilename);
                if (is == null) {
                    is = ClassLoader.getSystemResourceAsStream(dtdFilename);
                }
                return is;
            }
        });
        InputStreamReader re = null;
        if (is != null) {
            re = new InputStreamReader(is, StandardCharsets.UTF_8);
        }
        return re;
    }
}

