/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.color;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.InputStream;

public class StandardColorSpaces {
    private static ICC_ColorSpace a98rgb;
    private static ICC_ColorSpace prophotoRGB;
    private static ICC_ColorSpace displayP3;
    private static ICC_ColorSpace rec2020;
    private static ICC_ColorSpace xyzD65;

    StandardColorSpaces() {
    }

    public static ICC_ColorSpace getA98RGB() {
        if (a98rgb == null) {
            a98rgb = StandardColorSpaces.loadColorSpace("profiles/A98RGBCompat-v4.icc");
        }
        return a98rgb;
    }

    public static ICC_ColorSpace getProphotoRGB() {
        if (prophotoRGB == null) {
            prophotoRGB = StandardColorSpaces.loadColorSpace("profiles/WideGamutPhoto-v4.icc");
        }
        return prophotoRGB;
    }

    public static ICC_ColorSpace getDisplayP3() {
        if (displayP3 == null) {
            displayP3 = StandardColorSpaces.loadColorSpace("profiles/Display P3.icc");
        }
        return displayP3;
    }

    public static ICC_ColorSpace getRec2020() {
        if (rec2020 == null) {
            rec2020 = StandardColorSpaces.loadColorSpace("profiles/ITU-R_BT2020.icc");
        }
        return rec2020;
    }

    public static ICC_ColorSpace getXYZ_D65() {
        if (xyzD65 == null) {
            xyzD65 = StandardColorSpaces.loadColorSpace("profiles/D65_XYZ.icc");
        }
        return xyzD65;
    }

    private static ICC_ColorSpace loadColorSpace(String resource) {
        ICC_Profile prof;
        try (InputStream is = StandardColorSpaces.class.getResourceAsStream(resource);){
            prof = ICC_Profile.getInstance(is);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return new ICC_ColorSpace(prof);
    }

    public static ColorSpace mergeColorSpace(ColorSpace colorSpace1, ColorSpace colorSpace2) {
        ColorSpace csLsRGB;
        if (colorSpace1 == colorSpace2 || colorSpace2 == null || colorSpace2.isCS_sRGB() || colorSpace2 == (csLsRGB = ColorSpace.getInstance(1004))) {
            return colorSpace1;
        }
        if (colorSpace1 == null || colorSpace1.isCS_sRGB() || colorSpace1 == csLsRGB) {
            return colorSpace2;
        }
        ICC_ColorSpace pro = StandardColorSpaces.getProphotoRGB();
        if (colorSpace1 == pro || colorSpace2 == pro) {
            return pro;
        }
        return StandardColorSpaces.getRec2020();
    }

    public static ColorSpace mergeColorSpace(ColorSpace colorSpace1, ColorSpace colorSpace2, Color color) {
        if (colorSpace1 == null) {
            if (StandardColorSpaces.isInGamut(color, ColorSpace.getInstance(1000)) || colorSpace2.isCS_sRGB() || colorSpace2 == ColorSpace.getInstance(1004)) {
                return null;
            }
            return colorSpace2;
        }
        if (colorSpace2 == StandardColorSpaces.getProphotoRGB()) {
            return colorSpace2;
        }
        if (colorSpace1 == StandardColorSpaces.getProphotoRGB() || StandardColorSpaces.isInGamut(color, colorSpace1)) {
            return colorSpace1;
        }
        ICC_ColorSpace rec = StandardColorSpaces.getRec2020();
        if (colorSpace1 != rec && StandardColorSpaces.isInGamut(color, rec)) {
            return rec;
        }
        return StandardColorSpaces.getProphotoRGB();
    }

    public static ColorSpace containerRGBSpace(Color xyz, ColorSpace colorSpace) {
        ColorSpace cs = ColorSpace.getInstance(1000);
        if (StandardColorSpaces.isInGamut(xyz, cs)) {
            return null;
        }
        if (colorSpace != null && StandardColorSpaces.isInGamut(xyz, colorSpace)) {
            return colorSpace;
        }
        cs = StandardColorSpaces.getDisplayP3();
        if (colorSpace != cs && StandardColorSpaces.isInGamut(xyz, cs)) {
            return cs;
        }
        cs = StandardColorSpaces.getA98RGB();
        if (colorSpace != cs && StandardColorSpaces.isInGamut(xyz, cs)) {
            return cs;
        }
        cs = StandardColorSpaces.getRec2020();
        if (colorSpace != cs && StandardColorSpaces.isInGamut(xyz, cs)) {
            return cs;
        }
        return StandardColorSpaces.getProphotoRGB();
    }

    private static boolean isInGamut(Color color, ColorSpace space) {
        float[] comps = color.getColorComponents(space, null);
        float min = space.getMinValue(0);
        float max = space.getMaxValue(0);
        for (float comp : comps) {
            if (!(comp <= min) && !(comp >= max)) continue;
            return false;
        }
        return true;
    }
}

