/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttribute;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreClass;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDependency;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreScriptObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraint;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableContainer;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablePersistence;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPScriptObjectExt2;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectWithType;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public abstract class PostgreTableBase
extends JDBCTable<PostgreDataSource, PostgreTableContainer>
implements PostgreClass,
PostgreScriptObject,
DBPScriptObjectExt2,
PostgrePrivilegeOwner,
DBPNamedObject2,
DBSObjectWithType {
    private static final Log log = Log.getLog(PostgreTableBase.class);
    private long oid;
    private long ownerId;
    private String description;
    private boolean isPartition;
    private PostgreTablePersistence persistence;
    private Object acl;
    private String[] relOptions;

    protected PostgreTableBase(PostgreTableContainer container) {
        super((DBSObject)container, false);
        this.persistence = PostgreTablePersistence.PERMANENT;
    }

    protected PostgreTableBase(PostgreTableContainer container, ResultSet dbResult) {
        super((DBSObject)container, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"relname"), true);
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.ownerId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"relowner");
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"description");
        this.isPartition = ((PostgreDataSource)this.getDataSource()).isServerVersionAtLeast(10, 0) && JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"relispartition");
        this.acl = JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"relacl");
        if (((PostgreDataSource)this.getDataSource()).isServerVersionAtLeast(8, 2)) {
            this.relOptions = PostgreUtils.safeGetStringArray(dbResult, "reloptions");
        }
        this.persistence = container.getDataSource().isServerVersionAtLeast(9, 1) ? PostgreTablePersistence.getByCode(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"relpersistence")) : PostgreTablePersistence.PERMANENT;
    }

    public PostgreTableBase(DBRProgressMonitor monitor, PostgreTableContainer container, PostgreTableBase source, boolean persisted) throws DBException {
        super((DBSObject)container, (DBSEntity)source, persisted);
        this.ownerId = source.ownerId;
        this.description = source.description;
        this.isPartition = source.isPartition;
        this.acl = source.acl;
        this.relOptions = source.relOptions;
        this.persistence = source.persistence;
        DBSObjectCache colCache = this.getSchema().getTableCache().getChildrenCache(this);
        for (PostgreTableColumn srcColumn : CommonUtils.safeCollection(source.getAttributes(monitor))) {
            if (DBUtils.isHiddenObject((Object)srcColumn)) continue;
            PostgreTableColumn column = new PostgreTableColumn(monitor, this, srcColumn);
            colCache.cacheObject((DBSObject)column);
        }
    }

    public JDBCStructCache<PostgreTableContainer, ? extends PostgreClass, ? extends PostgreAttribute> getCache() {
        return ((PostgreTableContainer)this.getContainer()).getSchema().getTableCache();
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return ((PostgreTableContainer)this.getContainer()).getDatabase();
    }

    @Association
    public List<PostgreDependency> getDependencies(DBRProgressMonitor monitor) throws DBCException {
        return PostgreDependency.readDependencies(monitor, this, true);
    }

    @Property(viewable=true, order=9)
    public long getObjectId() {
        return this.oid;
    }

    @Property(viewable=true, length=PropertyLength.MULTILINE, order=90)
    @Nullable
    public String[] getRelOptions() {
        return this.relOptions;
    }

    public Object getAcl() {
        return this.acl;
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTableTypeName() {
        return "TABLE";
    }

    @Override
    @Property(viewable=true, order=10)
    public PostgreRole getOwner(DBRProgressMonitor monitor) throws DBException {
        return this.getDatabase().getRoleById(monitor, this.ownerId);
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        PostgreDatabase database = this.getDatabase();
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{database.isSharedDatabase() ? database : null, this.getSchema(), this});
    }

    @Override
    @NotNull
    public PostgreSchema getSchema() {
        DBSObject parentObject = super.getParentObject();
        assert (parentObject != null);
        return parentObject instanceof PostgreSchema ? (PostgreSchema)parentObject : ((PostgreTableBase)parentObject).getSchema();
    }

    public List<? extends PostgreTableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((PostgreTableContainer)this.getContainer()).getSchema().getTableCache().getChildren(monitor, (PostgreTableContainer)this.getContainer(), this);
    }

    protected PostgreTableColumn getAttributeByPos(DBRProgressMonitor monitor, int position) throws DBException {
        for (PostgreTableColumn attr : CommonUtils.safeCollection(this.getAttributes(monitor))) {
            if (attr.getOrdinalPosition() != position) continue;
            return attr;
        }
        return null;
    }

    @Association
    public List<? extends PostgreTableColumn> getCachedAttributes() {
        DBSObjectCache childrenCache = ((PostgreTableContainer)this.getContainer()).getSchema().getTableCache().getChildrenCache(this);
        if (childrenCache != null) {
            return childrenCache.getCachedObjects();
        }
        return Collections.emptyList();
    }

    public PostgreTableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return (PostgreTableColumn)((PostgreTableContainer)this.getContainer()).getSchema().getTableCache().getChild(monitor, (PostgreTableContainer)this.getContainer(), this, attributeName);
    }

    public Collection<PostgreTableConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public PostgreTableConstraintBase getConstraint(@NotNull DBRProgressMonitor monitor, String ukName) throws DBException {
        return null;
    }

    @Association
    public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Association
    public synchronized Collection<? extends DBSEntityAssociation> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        PostgreSchema schema = ((PostgreTableContainer)this.getContainer()).getSchema();
        schema.getConstraintCache().clearObjectCache(this);
        if (schema.getIndexCache() != null) {
            schema.getIndexCache().clearObjectCache(this);
        }
        return schema.getTableCache().refreshObject(monitor, schema, this);
    }

    @Override
    public Collection<PostgrePrivilege> getPrivileges(@NotNull DBRProgressMonitor monitor, boolean includeNestedObjects) throws DBException {
        if (!this.isPersisted()) {
            return Collections.emptyList();
        }
        return ((PostgreDataSource)this.getDataSource()).getServerType().readObjectPermissions(monitor, this, includeNestedObjects);
    }

    public boolean isPartition() {
        return this.isPartition;
    }

    public void setPartition(boolean partition) {
        this.isPartition = partition;
    }

    @NotNull
    public PostgreTablePersistence getPersistence() {
        return this.persistence;
    }

    public void appendTableModifiers(DBRProgressMonitor monitor, StringBuilder ddl) {
    }

    @Override
    public String generateChangeOwnerQuery(@NotNull String owner, @NotNull Map<String, Object> options) {
        return "ALTER TABLE " + DBUtils.getEntityScriptName((DBSObject)this, options) + " OWNER TO " + owner;
    }

    public boolean supportsObjectDefinitionOption(@NotNull String option) {
        if ("ddl.includeComments".equals(option) && ((PostgreDataSource)this.getDataSource()).getServerType().supportsShowingOfExtraComments()) {
            return true;
        }
        if ("ddl.includePermissions".equals(option)) {
            return true;
        }
        return !this.isView() && ("ddl.onlyForeignKeys".equals(option) || "ddl.skipForeignKeys".equals(option));
    }

    public PostgreTableColumn createTableColumn(DBRProgressMonitor monitor, PostgreSchema schema, JDBCResultSet dbResult) throws DBException {
        return new PostgreTableColumn(monitor, this, dbResult);
    }

    public static class TablespaceListProvider
    implements IPropertyValueListProvider<PostgreTableBase> {
        public boolean allowCustomValue() {
            return false;
        }

        @Nullable
        public Object[] getPossibleValues(PostgreTableBase object) {
            if (!((PostgreDataSource)object.getDataSource()).getServerType().supportsTablespaces()) {
                return new Object[0];
            }
            return object.getDatabase().getTablespaceCache().getCachedObjects().toArray(new Object[0]);
        }
    }
}

