/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlOperator;
import org.apache.commons.jexl3.introspection.JexlPropertyGet;
import org.apache.commons.jexl3.introspection.JexlPropertySet;
import org.apache.commons.jexl3.introspection.JexlUberspect;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.dpi.DPIClientObject;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;

public abstract class AbstractDescriptor {
    private static final Log log = Log.getLog(AbstractDescriptor.class);
    public static final String VAR_OBJECT = "object";
    public static final String VAR_CONTEXT = "context";
    private static JexlEngine jexlEngine;
    private static final JexlUberspect.PropertyResolver DPI_RESOLVER;
    private static List<JexlUberspect.PropertyResolver> POJO;
    private static final JexlUberspect.ResolverStrategy JEXL_STRATEGY;
    private static Map<String, Map<String, Boolean>> classInfoCache;
    private String pluginId;
    private Bundle originBundle;

    static {
        DPI_RESOLVER = new JexlUberspect.PropertyResolver(){

            public JexlPropertyGet getPropertyGet(JexlUberspect uber, Object obj, Object identifier) {
                if (identifier instanceof String && obj instanceof DPIClientObject) {
                    return new DPIPropertyGetter((String)identifier);
                }
                return null;
            }

            public JexlPropertySet getPropertySet(JexlUberspect uber, Object obj, Object identifier, Object arg) {
                return null;
            }
        };
        POJO = Collections.unmodifiableList(Arrays.asList(JexlUberspect.JexlResolver.PROPERTY, JexlUberspect.JexlResolver.MAP, JexlUberspect.JexlResolver.LIST, JexlUberspect.JexlResolver.DUCK, JexlUberspect.JexlResolver.FIELD, JexlUberspect.JexlResolver.CONTAINER, DPI_RESOLVER));
        JEXL_STRATEGY = (op, obj) -> {
            if (op == JexlOperator.ARRAY_GET) {
                return JexlUberspect.MAP;
            }
            if (op == JexlOperator.ARRAY_SET) {
                return JexlUberspect.MAP;
            }
            if (op == null && obj instanceof Map) {
                return JexlUberspect.MAP;
            }
            return POJO;
        };
        classInfoCache = new HashMap<String, Map<String, Boolean>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JexlExpression parseExpression(String exprString) throws DBException {
        Class<AbstractDescriptor> clazz = AbstractDescriptor.class;
        synchronized (AbstractDescriptor.class) {
            if (jexlEngine == null) {
                jexlEngine = new JexlBuilder().cache(100).strategy(JEXL_STRATEGY).create();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                return jexlEngine.createExpression(exprString);
            }
            catch (JexlException e) {
                throw new DBException("Bad expression", e);
            }
        }
    }

    public static JexlContext makeContext(final Object object, final Object context) {
        return new JexlContext(){

            public Object get(String name) {
                return name.equals(AbstractDescriptor.VAR_OBJECT) ? object : (name.equals(AbstractDescriptor.VAR_CONTEXT) ? context : null);
            }

            public void set(String name, Object value) {
                log.warn("Set is not implemented");
            }

            public boolean has(String name) {
                return name.equals(AbstractDescriptor.VAR_OBJECT) && object != null || name.equals(AbstractDescriptor.VAR_CONTEXT) && context != null;
            }
        };
    }

    public static Object evalExpression(String exprString, Object object, Object context) {
        try {
            JexlExpression expression = AbstractDescriptor.parseExpression(exprString);
            return expression.evaluate(AbstractDescriptor.makeContext(object, context));
        }
        catch (DBException e) {
            log.error("Bad expression: " + exprString, e);
            return null;
        }
    }

    private static synchronized Map<String, Boolean> getTypeInfoCache(Class<?> clazz) {
        Map<String, Boolean> intCache = classInfoCache.get(clazz.getName());
        if (intCache != null) {
            return intCache;
        }
        intCache = new HashMap<String, Boolean>();
        classInfoCache.put(clazz.getName(), intCache);
        Class<?> sc = clazz;
        while (sc != null && sc != Object.class) {
            AbstractDescriptor.collectInterface(sc, intCache);
            sc = sc.getSuperclass();
        }
        return intCache;
    }

    private static void collectInterface(Class<?> clazz, Map<String, Boolean> intCache) {
        intCache.put(clazz.getName(), Boolean.TRUE);
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> i = classArray[n2];
            AbstractDescriptor.collectInterface(i, intCache);
            ++n2;
        }
    }

    protected AbstractDescriptor(IConfigurationElement contributorConfig) {
        this.pluginId = contributorConfig.getContributor().getName();
    }

    protected AbstractDescriptor(String pluginId) {
        this.pluginId = pluginId;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public Bundle getContributorBundle() {
        if (this.originBundle == null) {
            this.originBundle = Platform.getBundle((String)this.pluginId);
        }
        return this.originBundle;
    }

    protected void replaceContributor(IContributor contributor) {
        this.pluginId = contributor.getName();
        this.originBundle = null;
    }

    @NotNull
    protected DBPImage iconToImage(String icon, @NotNull DBPImage defIcon) {
        DBPImage result = this.iconToImage(icon);
        if (result == null) {
            return defIcon;
        }
        return result;
    }

    @Nullable
    public DBPImage iconToImage(String icon) {
        if (CommonUtils.isEmpty((String)icon)) {
            return null;
        }
        if (((String)icon).startsWith("#")) {
            return DBIcon.getImageById(((String)icon).substring(1));
        }
        if (!((String)icon).startsWith("platform:")) {
            icon = "platform:/plugin/" + this.pluginId + "/" + (String)icon;
        }
        return new DBIcon((String)icon);
    }

    public Class<?> getObjectClass(@NotNull String className) {
        return this.getObjectClass(className, null);
    }

    public <T> Class<T> getObjectClass(@NotNull String className, Class<T> type) {
        return AbstractDescriptor.getObjectClass(this.getContributorBundle(), className, type);
    }

    protected boolean isExpressionTrue(Expression expression, Object exprContext) {
        if (expression != null) {
            try {
                EvaluationContext context = new EvaluationContext(null, exprContext);
                EvaluationResult result = expression.evaluate((IEvaluationContext)context);
                if (result != EvaluationResult.TRUE) {
                    return false;
                }
            }
            catch (CoreException e) {
                log.debug((Object)e);
                return false;
            }
        }
        return true;
    }

    public static <T> Class<T> getObjectClass(@NotNull Bundle fromBundle, @NotNull String className, Class<T> type) {
        Class objectClass;
        try {
            objectClass = fromBundle.loadClass(className);
        }
        catch (Throwable ex) {
            log.error("Can't determine object class '" + className + "'", ex);
            return null;
        }
        if (type != null && !type.isAssignableFrom(objectClass)) {
            log.error("Object class '" + className + "' doesn't match requested type '" + type.getName() + "'");
            return null;
        }
        return objectClass;
    }

    @Nullable
    protected static Expression getEnablementExpression(@NotNull IConfigurationElement config) {
        return AbstractDescriptor.getEnablementExpression(config, "enabledWhen");
    }

    @Nullable
    protected static Expression getEnablementExpression(@NotNull IConfigurationElement config, @NotNull String expressionElementName) {
        IConfigurationElement[] elements = config.getChildren(expressionElementName);
        if (elements.length > 0) {
            try {
                IConfigurationElement[] enablement = elements[0].getChildren();
                if (enablement.length > 0) {
                    return ExpressionConverter.getDefault().perform(enablement[0]);
                }
            }
            catch (Exception e) {
                log.debug(e);
            }
        }
        return null;
    }

    private static class DPIPropertyGetter
    implements JexlPropertyGet {
        private final String propertyName;

        private DPIPropertyGetter(String propertyName) {
            this.propertyName = propertyName;
        }

        public Object invoke(Object obj) throws Exception {
            if (obj instanceof DPIClientObject) {
                return ((DPIClientObject)obj).dpiPropertyValue(new LoggingProgressMonitor(log), this.propertyName);
            }
            return null;
        }

        public Object tryInvoke(Object obj, Object key) {
            try {
                return this.invoke(obj);
            }
            catch (Exception e) {
                log.debug(e);
                return null;
            }
        }

        public boolean tryFailed(Object rval) {
            return false;
        }

        public boolean isCacheable() {
            return true;
        }
    }

    public class ObjectType {
        private static final String ATTR_NAME = "name";
        private static final String ATTR_IF = "if";
        private static final String ATTR_FORCE_CHECK = "forceCheck";
        private final String implName;
        private Class<?> implClass;
        private JexlExpression expression;
        private boolean forceCheck;

        public ObjectType(String implName) {
            this.implName = implName;
        }

        public ObjectType(IConfigurationElement cfg) {
            this(cfg, ATTR_NAME);
        }

        public ObjectType(@NotNull IConfigurationElement cfg, String typeAttr) {
            String fcAttr;
            this.implName = cfg.getAttribute(typeAttr);
            String condition = cfg.getAttribute(ATTR_IF);
            if (!CommonUtils.isEmpty((String)condition)) {
                try {
                    this.expression = AbstractDescriptor.parseExpression(condition);
                }
                catch (DBException ex) {
                    log.warn("Can't parse object type expression: " + condition, ex);
                }
            }
            if (!CommonUtils.isEmpty((String)(fcAttr = cfg.getAttribute(ATTR_FORCE_CHECK)))) {
                this.forceCheck = CommonUtils.toBoolean((Object)fcAttr);
            }
        }

        @NotNull
        public String getImplName() {
            return this.implName;
        }

        @Nullable
        public Class<?> getObjectClass() {
            return this.getObjectClass(Object.class);
        }

        @Nullable
        public <T> Class<? extends T> getObjectClass(Class<T> type) {
            if (this.implName == null) {
                return null;
            }
            if (this.implClass == null) {
                this.implClass = AbstractDescriptor.this.getObjectClass(this.implName, type);
            }
            return this.implClass;
        }

        public <T> void checkObjectClass(@NotNull Class<T> type) throws DBException {
            Class<T> objectClass = this.getObjectClass(type);
            if (objectClass == null) {
                throw new DBException("Class '" + this.implName + "' not found");
            }
            if (!type.isAssignableFrom(objectClass)) {
                throw new DBException("Class '" + this.implName + "' do not implements '" + type.getName() + "'");
            }
        }

        public boolean appliesTo(@NotNull Object object, @Nullable Object context) {
            if (!this.matchesType(object.getClass())) {
                return false;
            }
            if (this.expression != null) {
                try {
                    Object result = this.expression.evaluate(AbstractDescriptor.makeContext(object, context));
                    return Boolean.TRUE.equals(result);
                }
                catch (Exception e) {
                    log.debug("Error evaluating EL expression '" + String.valueOf(this.expression) + "'", e);
                    return false;
                }
            }
            return true;
        }

        public <T> T createInstance(@NotNull Class<T> type, Object ... args) throws DBException {
            if (this.implName == null) {
                throw new DBException("No implementation class name set for '" + type.getName() + "'");
            }
            Class<T> objectClass = this.getObjectClass(type);
            if (objectClass == null) {
                throw new DBException("Can't load class '" + this.getImplName() + "'");
            }
            try {
                Constructor<?>[] constructorArray = objectClass.getConstructors();
                int n = constructorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Constructor<?> c = constructorArray[n2];
                    Class<?>[] parameterTypes = c.getParameterTypes();
                    if (parameterTypes.length == args.length) {
                        boolean matches = true;
                        int i = 0;
                        while (i < parameterTypes.length) {
                            if (!parameterTypes[i].isInstance(args[i])) {
                                matches = false;
                                break;
                            }
                            ++i;
                        }
                        if (matches) {
                            return (T)c.newInstance(args);
                        }
                    }
                    ++n2;
                }
                throw new DBException("Cannot find constructor matching args " + String.valueOf(args));
            }
            catch (Exception e) {
                throw new DBException("Can't instantiate class '" + this.getImplName() + "'", e);
            }
        }

        public <T> T createInstance(@NotNull Class<T> type) throws DBException {
            if (this.implName == null) {
                throw new DBException("No implementation class name set for '" + type.getName() + "'");
            }
            Class<T> objectClass = this.getObjectClass(type);
            if (objectClass == null) {
                throw new DBException("Can't load class '" + this.getImplName() + "'");
            }
            try {
                return objectClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new DBException("Can't instantiate class '" + this.getImplName() + "'", e);
            }
        }

        public boolean matchesType(@NotNull Class<?> clazz) {
            if (AbstractDescriptor.this.getContributorBundle().getState() != 32 && !this.forceCheck) {
                return AbstractDescriptor.getTypeInfoCache(clazz).containsKey(this.implName);
            }
            this.getObjectClass();
            return this.implClass != null && this.implClass.isAssignableFrom(clazz);
        }

        public String toString() {
            return this.implName;
        }
    }
}

