/*
 * Decompiled with CFR 0.152.
 */
package org.a11y.brlapi.clients;

import org.a11y.brlapi.Client;
import org.a11y.brlapi.Connection;
import org.a11y.brlapi.OperandUsage;
import org.a11y.brlapi.Parse;
import org.a11y.brlapi.ProgramException;

public class PauseClient
extends Client {
    public static final byte MINIMUM_WAIT_TIME = 1;
    public static final byte DEFAULT_WAIT_TIME = 5;
    private byte waitTime = (byte)5;
    private final OperandUsage waitTimeUsage = new OperandUsage("wait time").setDefault(this.waitTime).setRangeMinimum(1).setRangeUnits("seconds");

    protected final int getWaitTime() {
        return this.waitTime * 1000;
    }

    protected final boolean pause(Connection connection) {
        return this.pause(connection, this.getWaitTime());
    }

    public PauseClient(String ... stringArray2) {
        super(stringArray2);
        this.addOption("wait", stringArray -> {
            this.waitTime = Parse.asByte(this.waitTimeUsage.getOperandDescription(), stringArray[0], (byte)1);
        }, "seconds");
    }

    @Override
    protected void extendUsageSummary(StringBuilder stringBuilder) {
        super.extendUsageSummary(stringBuilder);
        this.waitTimeUsage.appendTo(stringBuilder);
    }

    @Override
    protected void runClient(Connection connection) throws ProgramException {
        PauseClient.printf("Pausing for %d seconds...", this.waitTime);
        String string = this.pause(connection) ? "pause completed" : "pause interrupted";
        PauseClient.printf(" %s\n", string);
    }
}

