﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/workspaces-web/WorkSpacesWeb_EXPORTS.h>
#include <aws/workspaces-web/model/Certificate.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace WorkSpacesWeb {
namespace Model {
class GetTrustStoreCertificateResult {
 public:
  AWS_WORKSPACESWEB_API GetTrustStoreCertificateResult() = default;
  AWS_WORKSPACESWEB_API GetTrustStoreCertificateResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_WORKSPACESWEB_API GetTrustStoreCertificateResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ARN of the trust store certificate.</p>
   */
  inline const Aws::String& GetTrustStoreArn() const { return m_trustStoreArn; }
  template <typename TrustStoreArnT = Aws::String>
  void SetTrustStoreArn(TrustStoreArnT&& value) {
    m_trustStoreArnHasBeenSet = true;
    m_trustStoreArn = std::forward<TrustStoreArnT>(value);
  }
  template <typename TrustStoreArnT = Aws::String>
  GetTrustStoreCertificateResult& WithTrustStoreArn(TrustStoreArnT&& value) {
    SetTrustStoreArn(std::forward<TrustStoreArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The certificate of the trust store certificate.</p>
   */
  inline const Certificate& GetCertificate() const { return m_certificate; }
  template <typename CertificateT = Certificate>
  void SetCertificate(CertificateT&& value) {
    m_certificateHasBeenSet = true;
    m_certificate = std::forward<CertificateT>(value);
  }
  template <typename CertificateT = Certificate>
  GetTrustStoreCertificateResult& WithCertificate(CertificateT&& value) {
    SetCertificate(std::forward<CertificateT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetTrustStoreCertificateResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_trustStoreArn;

  Certificate m_certificate;

  Aws::String m_requestId;
  bool m_trustStoreArnHasBeenSet = false;
  bool m_certificateHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkSpacesWeb
}  // namespace Aws
