﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/quicksight/QuickSight_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace QuickSight {
namespace Model {
class UpdateDataSetPermissionsResult {
 public:
  AWS_QUICKSIGHT_API UpdateDataSetPermissionsResult() = default;
  AWS_QUICKSIGHT_API UpdateDataSetPermissionsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_QUICKSIGHT_API UpdateDataSetPermissionsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the dataset.</p>
   */
  inline const Aws::String& GetDataSetArn() const { return m_dataSetArn; }
  template <typename DataSetArnT = Aws::String>
  void SetDataSetArn(DataSetArnT&& value) {
    m_dataSetArnHasBeenSet = true;
    m_dataSetArn = std::forward<DataSetArnT>(value);
  }
  template <typename DataSetArnT = Aws::String>
  UpdateDataSetPermissionsResult& WithDataSetArn(DataSetArnT&& value) {
    SetDataSetArn(std::forward<DataSetArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID for the dataset whose permissions you want to update. This ID is
   * unique per Amazon Web Services Region for each Amazon Web Services account.</p>
   */
  inline const Aws::String& GetDataSetId() const { return m_dataSetId; }
  template <typename DataSetIdT = Aws::String>
  void SetDataSetId(DataSetIdT&& value) {
    m_dataSetIdHasBeenSet = true;
    m_dataSetId = std::forward<DataSetIdT>(value);
  }
  template <typename DataSetIdT = Aws::String>
  UpdateDataSetPermissionsResult& WithDataSetId(DataSetIdT&& value) {
    SetDataSetId(std::forward<DataSetIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateDataSetPermissionsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The HTTP status of the request.</p>
   */
  inline int GetStatus() const { return m_status; }
  inline void SetStatus(int value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline UpdateDataSetPermissionsResult& WithStatus(int value) {
    SetStatus(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_dataSetArn;

  Aws::String m_dataSetId;

  Aws::String m_requestId;

  int m_status{0};
  bool m_dataSetArnHasBeenSet = false;
  bool m_dataSetIdHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
  bool m_statusHasBeenSet = false;
};

}  // namespace Model
}  // namespace QuickSight
}  // namespace Aws
