﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/neptune-graph/NeptuneGraph_EXPORTS.h>
#include <aws/neptune-graph/model/QuerySummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace NeptuneGraph {
namespace Model {
class ListQueriesResult {
 public:
  AWS_NEPTUNEGRAPH_API ListQueriesResult() = default;
  AWS_NEPTUNEGRAPH_API ListQueriesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_NEPTUNEGRAPH_API ListQueriesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A list of current openCypher queries.</p>
   */
  inline const Aws::Vector<QuerySummary>& GetQueries() const { return m_queries; }
  template <typename QueriesT = Aws::Vector<QuerySummary>>
  void SetQueries(QueriesT&& value) {
    m_queriesHasBeenSet = true;
    m_queries = std::forward<QueriesT>(value);
  }
  template <typename QueriesT = Aws::Vector<QuerySummary>>
  ListQueriesResult& WithQueries(QueriesT&& value) {
    SetQueries(std::forward<QueriesT>(value));
    return *this;
  }
  template <typename QueriesT = QuerySummary>
  ListQueriesResult& AddQueries(QueriesT&& value) {
    m_queriesHasBeenSet = true;
    m_queries.emplace_back(std::forward<QueriesT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListQueriesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<QuerySummary> m_queries;

  Aws::String m_requestId;
  bool m_queriesHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace NeptuneGraph
}  // namespace Aws
