﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime-sdk-identity/ChimeSDKIdentity_EXPORTS.h>
#include <aws/chime-sdk-identity/model/ExpirationSettings.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ChimeSDKIdentity {
namespace Model {
class PutAppInstanceUserExpirationSettingsResult {
 public:
  AWS_CHIMESDKIDENTITY_API PutAppInstanceUserExpirationSettingsResult() = default;
  AWS_CHIMESDKIDENTITY_API PutAppInstanceUserExpirationSettingsResult(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CHIMESDKIDENTITY_API PutAppInstanceUserExpirationSettingsResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ARN of the <code>AppInstanceUser</code>.</p>
   */
  inline const Aws::String& GetAppInstanceUserArn() const { return m_appInstanceUserArn; }
  template <typename AppInstanceUserArnT = Aws::String>
  void SetAppInstanceUserArn(AppInstanceUserArnT&& value) {
    m_appInstanceUserArnHasBeenSet = true;
    m_appInstanceUserArn = std::forward<AppInstanceUserArnT>(value);
  }
  template <typename AppInstanceUserArnT = Aws::String>
  PutAppInstanceUserExpirationSettingsResult& WithAppInstanceUserArn(AppInstanceUserArnT&& value) {
    SetAppInstanceUserArn(std::forward<AppInstanceUserArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Settings that control the interval after which an
   * <code>AppInstanceUser</code> is automatically deleted.</p>
   */
  inline const ExpirationSettings& GetExpirationSettings() const { return m_expirationSettings; }
  template <typename ExpirationSettingsT = ExpirationSettings>
  void SetExpirationSettings(ExpirationSettingsT&& value) {
    m_expirationSettingsHasBeenSet = true;
    m_expirationSettings = std::forward<ExpirationSettingsT>(value);
  }
  template <typename ExpirationSettingsT = ExpirationSettings>
  PutAppInstanceUserExpirationSettingsResult& WithExpirationSettings(ExpirationSettingsT&& value) {
    SetExpirationSettings(std::forward<ExpirationSettingsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  PutAppInstanceUserExpirationSettingsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_appInstanceUserArn;

  ExpirationSettings m_expirationSettings;

  Aws::String m_requestId;
  bool m_appInstanceUserArnHasBeenSet = false;
  bool m_expirationSettingsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ChimeSDKIdentity
}  // namespace Aws
