﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-runtime/BedrockRuntime_EXPORTS.h>
#include <aws/bedrock-runtime/model/AsyncInvokeOutputDataConfig.h>
#include <aws/bedrock-runtime/model/AsyncInvokeStatus.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace BedrockRuntime {
namespace Model {
class GetAsyncInvokeResult {
 public:
  AWS_BEDROCKRUNTIME_API GetAsyncInvokeResult() = default;
  AWS_BEDROCKRUNTIME_API GetAsyncInvokeResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_BEDROCKRUNTIME_API GetAsyncInvokeResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The invocation's ARN.</p>
   */
  inline const Aws::String& GetInvocationArn() const { return m_invocationArn; }
  template <typename InvocationArnT = Aws::String>
  void SetInvocationArn(InvocationArnT&& value) {
    m_invocationArnHasBeenSet = true;
    m_invocationArn = std::forward<InvocationArnT>(value);
  }
  template <typename InvocationArnT = Aws::String>
  GetAsyncInvokeResult& WithInvocationArn(InvocationArnT&& value) {
    SetInvocationArn(std::forward<InvocationArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The invocation's model ARN.</p>
   */
  inline const Aws::String& GetModelArn() const { return m_modelArn; }
  template <typename ModelArnT = Aws::String>
  void SetModelArn(ModelArnT&& value) {
    m_modelArnHasBeenSet = true;
    m_modelArn = std::forward<ModelArnT>(value);
  }
  template <typename ModelArnT = Aws::String>
  GetAsyncInvokeResult& WithModelArn(ModelArnT&& value) {
    SetModelArn(std::forward<ModelArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The invocation's idempotency token.</p>
   */
  inline const Aws::String& GetClientRequestToken() const { return m_clientRequestToken; }
  template <typename ClientRequestTokenT = Aws::String>
  void SetClientRequestToken(ClientRequestTokenT&& value) {
    m_clientRequestTokenHasBeenSet = true;
    m_clientRequestToken = std::forward<ClientRequestTokenT>(value);
  }
  template <typename ClientRequestTokenT = Aws::String>
  GetAsyncInvokeResult& WithClientRequestToken(ClientRequestTokenT&& value) {
    SetClientRequestToken(std::forward<ClientRequestTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The invocation's status.</p>
   */
  inline AsyncInvokeStatus GetStatus() const { return m_status; }
  inline void SetStatus(AsyncInvokeStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline GetAsyncInvokeResult& WithStatus(AsyncInvokeStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An error message.</p>
   */
  inline const Aws::String& GetFailureMessage() const { return m_failureMessage; }
  template <typename FailureMessageT = Aws::String>
  void SetFailureMessage(FailureMessageT&& value) {
    m_failureMessageHasBeenSet = true;
    m_failureMessage = std::forward<FailureMessageT>(value);
  }
  template <typename FailureMessageT = Aws::String>
  GetAsyncInvokeResult& WithFailureMessage(FailureMessageT&& value) {
    SetFailureMessage(std::forward<FailureMessageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>When the invocation request was submitted.</p>
   */
  inline const Aws::Utils::DateTime& GetSubmitTime() const { return m_submitTime; }
  template <typename SubmitTimeT = Aws::Utils::DateTime>
  void SetSubmitTime(SubmitTimeT&& value) {
    m_submitTimeHasBeenSet = true;
    m_submitTime = std::forward<SubmitTimeT>(value);
  }
  template <typename SubmitTimeT = Aws::Utils::DateTime>
  GetAsyncInvokeResult& WithSubmitTime(SubmitTimeT&& value) {
    SetSubmitTime(std::forward<SubmitTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The invocation's last modified time.</p>
   */
  inline const Aws::Utils::DateTime& GetLastModifiedTime() const { return m_lastModifiedTime; }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  void SetLastModifiedTime(LastModifiedTimeT&& value) {
    m_lastModifiedTimeHasBeenSet = true;
    m_lastModifiedTime = std::forward<LastModifiedTimeT>(value);
  }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  GetAsyncInvokeResult& WithLastModifiedTime(LastModifiedTimeT&& value) {
    SetLastModifiedTime(std::forward<LastModifiedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>When the invocation ended.</p>
   */
  inline const Aws::Utils::DateTime& GetEndTime() const { return m_endTime; }
  template <typename EndTimeT = Aws::Utils::DateTime>
  void SetEndTime(EndTimeT&& value) {
    m_endTimeHasBeenSet = true;
    m_endTime = std::forward<EndTimeT>(value);
  }
  template <typename EndTimeT = Aws::Utils::DateTime>
  GetAsyncInvokeResult& WithEndTime(EndTimeT&& value) {
    SetEndTime(std::forward<EndTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Output data settings.</p>
   */
  inline const AsyncInvokeOutputDataConfig& GetOutputDataConfig() const { return m_outputDataConfig; }
  template <typename OutputDataConfigT = AsyncInvokeOutputDataConfig>
  void SetOutputDataConfig(OutputDataConfigT&& value) {
    m_outputDataConfigHasBeenSet = true;
    m_outputDataConfig = std::forward<OutputDataConfigT>(value);
  }
  template <typename OutputDataConfigT = AsyncInvokeOutputDataConfig>
  GetAsyncInvokeResult& WithOutputDataConfig(OutputDataConfigT&& value) {
    SetOutputDataConfig(std::forward<OutputDataConfigT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetAsyncInvokeResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_invocationArn;

  Aws::String m_modelArn;

  Aws::String m_clientRequestToken;

  AsyncInvokeStatus m_status{AsyncInvokeStatus::NOT_SET};

  Aws::String m_failureMessage;

  Aws::Utils::DateTime m_submitTime{};

  Aws::Utils::DateTime m_lastModifiedTime{};

  Aws::Utils::DateTime m_endTime{};

  AsyncInvokeOutputDataConfig m_outputDataConfig;

  Aws::String m_requestId;
  bool m_invocationArnHasBeenSet = false;
  bool m_modelArnHasBeenSet = false;
  bool m_clientRequestTokenHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_failureMessageHasBeenSet = false;
  bool m_submitTimeHasBeenSet = false;
  bool m_lastModifiedTimeHasBeenSet = false;
  bool m_endTimeHasBeenSet = false;
  bool m_outputDataConfigHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace BedrockRuntime
}  // namespace Aws
