/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.search;

import com.dickimawbooks.texparserlib.search.SearchMatcher;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URIMatcher
implements SearchMatcher {
    private Pattern pattern;
    private int type;
    public static final int ALL = 0;
    public static final int SCHEME = 1;
    public static final int USER_INFO = 2;
    public static final int HOST = 3;
    public static final int PORT = 4;
    public static final int PATH = 5;
    public static final int QUERY = 6;
    public static final int FRAGMENT = 7;

    public URIMatcher(Pattern pattern, int n) {
        this.pattern = pattern;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.type = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type: " + n);
            }
        }
    }

    @Override
    public boolean isMatch(Object object) {
        if (!(object instanceof URI)) {
            return false;
        }
        URI uRI = (URI)object;
        String string = "";
        switch (this.type) {
            case 0: {
                string = uRI.toString();
                break;
            }
            case 1: {
                string = uRI.getScheme();
                break;
            }
            case 2: {
                string = uRI.getUserInfo();
                break;
            }
            case 3: {
                string = uRI.getHost();
                break;
            }
            case 4: {
                string = "" + uRI.getPort();
                break;
            }
            case 5: {
                string = uRI.getPath();
                break;
            }
            case 6: {
                string = uRI.getQuery();
                break;
            }
            case 7: {
                string = uRI.getFragment();
            }
        }
        Matcher matcher = this.pattern.matcher(string);
        return matcher.matches();
    }

    public String toString() {
        return String.format("%s[pattern=%s,type=%d]", this.getClass().getSimpleName(), this.pattern, this.type);
    }
}

