/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.color;

import com.dickimawbooks.texparserlib.Declaration;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.color.ColorSty;
import java.awt.Color;
import java.io.IOException;

public class ColorDeclaration
extends Declaration {
    private ColorSty sty;
    private Color orgColor;
    private boolean isFg = true;

    public ColorDeclaration(ColorSty colorSty) {
        this(colorSty, "color", true);
    }

    public ColorDeclaration(ColorSty colorSty, String string, boolean bl) {
        super(string);
        this.setArgTypes("om");
        this.sty = colorSty;
        this.isFg = bl;
        this.orgColor = null;
    }

    @Override
    public Object clone() {
        return new ColorDeclaration(this.sty, this.getName(), this.isFg);
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return null;
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        String string = this.popOptLabelString(teXParser, teXObjectList);
        string = string == null ? "named" : string.trim();
        String string2 = this.popLabelString(teXParser, teXObjectList).trim();
        Color color = this.sty.getColor(teXParser, string, string2);
        TeXSettings teXSettings = teXParser.getSettings();
        if (this.isFg) {
            this.orgColor = teXSettings.getCurrentFgColor();
            teXSettings.setFgColor(color);
        } else {
            this.orgColor = teXSettings.getCurrentBgColor();
            teXSettings.setBgColor(color);
        }
        ((LaTeXParserListener)teXParser.getListener()).startColor(color, this.isFg);
    }

    @Override
    public void end(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        ((LaTeXParserListener)teXParser.getListener()).endColor(this.isFg);
        TeXSettings teXSettings = teXParser.getSettings();
        if (this.isFg) {
            teXSettings.setFgColor(this.orgColor);
        } else {
            teXSettings.setBgColor(this.orgColor);
        }
    }

    @Override
    public boolean isModeSwitcher() {
        return false;
    }
}

