/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkSignedDanielssonDistanceMapImageFilter_h
#define sitkSignedDanielssonDistanceMapImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class SignedDanielssonDistanceMapImageFilter
\brief This filter computes the signed distance map of the input image as an approximation with pixel accuracy to the Euclidean distance.

This class is parameterized over the type of the input image and the type of the output image.

For purposes of evaluating the signed distance map, the input is assumed to be binary composed of pixels with value 0 and non-zero.

The inside is considered as having negative distances. Outside is treated as having positive distances. To change the convention, use the InsideIsPositive(bool) function.

As a convention, the distance is evaluated from the boundary of the ON pixels.

The filter returns

\li A signed distance map with the approximation to the euclidean distance.

\li A voronoi partition. (See itkDanielssonDistanceMapImageFilter)

\li A vector map containing the component of the vector relating the current pixel with the closest point of the closest object to this pixel. Given that the components of the distance are computed in "pixels", the vector is represented by an itk::Offset . That is, physical coordinates are not used. (See itkDanielssonDistanceMapImageFilter)




This filter internally uses the DanielssonDistanceMap filter. This filter is N-dimensional.

\see itkDanielssonDistanceMapImageFilter
\sa itk::simple::SignedDanielssonDistanceMap for the procedural interface
\sa itk::SignedDanielssonDistanceMapImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT SignedDanielssonDistanceMapImageFilter : public ImageFilter {
    public:
      using Self = SignedDanielssonDistanceMapImageFilter;

      /** Destructor */
      virtual ~SignedDanielssonDistanceMapImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      SignedDanielssonDistanceMapImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = IntegerPixelIDTypeList;
\

      /**
       * Set if the inside represents positive values in the signed distance map. By convention ON pixels are treated as inside pixels.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetInsideIsPositive ( bool InsideIsPositive ) { this->m_InsideIsPositive = InsideIsPositive; return *this; }

      /** Set the value of InsideIsPositive to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER InsideIsPositiveOn() { return this->SetInsideIsPositive(true); }
      SITK_RETURN_SELF_TYPE_HEADER InsideIsPositiveOff() { return this->SetInsideIsPositive(false); }

      /**
       * Get if the inside represents positive values in the signed distance map. See GetInsideIsPositive()
       */
      bool GetInsideIsPositive() const { return this->m_InsideIsPositive; }\

      /**
       * Set if the distance should be squared.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSquaredDistance ( bool SquaredDistance ) { this->m_SquaredDistance = SquaredDistance; return *this; }

      /** Set the value of SquaredDistance to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER SquaredDistanceOn() { return this->SetSquaredDistance(true); }
      SITK_RETURN_SELF_TYPE_HEADER SquaredDistanceOff() { return this->SetSquaredDistance(false); }

      /**
       * Get the distance squared.
       */
      bool GetSquaredDistance() const { return this->m_SquaredDistance; }\

      /**
       * Set if image spacing should be used in computing distances.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetUseImageSpacing ( bool UseImageSpacing ) { this->m_UseImageSpacing = UseImageSpacing; return *this; }

      /** Set the value of UseImageSpacing to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER UseImageSpacingOn() { return this->SetUseImageSpacing(true); }
      SITK_RETURN_SELF_TYPE_HEADER UseImageSpacingOff() { return this->SetUseImageSpacing(false); }

      /**
       * Get whether spacing is used.
       */
      bool GetUseImageSpacing() const { return this->m_UseImageSpacing; }
     /**
      * Get Voronoi Map This map shows for each pixel what object is closest to it. Each object should be labeled by a number (larger than 0), so the map has a value for each pixel corresponding to the label of the closest object.
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     Image GetVoronoiMap() const { return this->m_VoronoiMap; };

     /**
      * Get vector field of distances.
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     Image GetVectorDistanceMap() const { return this->m_VectorDistanceMap; };


      /** Name of this class */
      std::string GetName() const { return std::string ("SignedDanielssonDistanceMapImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      bool  m_InsideIsPositive{false};

      bool  m_SquaredDistance{false};

      bool  m_UseImageSpacing{false};

      /* Docs */
      Image m_VoronoiMap{Image()};
      /* Docs */
      Image m_VectorDistanceMap{Image()};


    };

    /**\
     * \brief This filter computes the signed distance map of the input image as an approximation with pixel accuracy to the Euclidean distance.
     *
     * This function directly calls the execute method of SignedDanielssonDistanceMapImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::SignedDanielssonDistanceMapImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image SignedDanielssonDistanceMap ( const Image& image1, bool insideIsPositive = false, bool squaredDistance = false, bool useImageSpacing = false );

     /** @} */
}
#endif
