# typing.py
#
# Copyright 2025 Hari Rana (TheEvilSkeleton)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# SPDX-License-Identifier: GPL-3.0-or-later


from typing import TypedDict
from enum import IntEnum, auto

from gi.repository import Gio


class RefineSettingsSource(TypedDict):
    """Dictionary for storing important `Gio.Settings`-related data."""

    settings: Gio.Settings | None
    schema: Gio.SettingsSchema | None


class RefineLogicalDirectionType(IntEnum):
    """Logical direction types."""

    START = auto()
    END = auto()
