\name{UnsharpMaskImageFilter}
\alias{UnsharpMaskImageFilter}
\title{UnsharpMaskImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Edge enhancement filter.
UnsharpMaskImageFilter}
\details{
This filter subtracts a smoothed version of the image from the image
to achieve the edge enhancing effect. https://en.wikipedia.org/w/index.php?title=Unsharp_masking&oldid=75048
6803#Photographic_unsharp_masking
It has configurable amount, radius (sigma) and threshold, and whether
to clamp the resulting values to the range of output type.
Formula: sharpened=original+[ itk::Math::abs (original-blurred)-threshold]*amount
If clamping is turned off (it is on by default), casting to output
pixel format is done using C++ defaults, meaning that values are not
clamped but rather wrap around e.g. 260 -> 4 (unsigned char).
See:
ImageToImageFilter
SmoothingRecursiveGaussianImageFilter
RescaleIntensityImageFilter
UnsharpMask for the procedural interface
itk::UnsharpMaskImageFilter for the Doxygen on the original ITK class.
UnsharpMaskImageFilter}
%C++ includes: sitkUnsharpMaskImageFilter.h
\section{Methods}{
\describe{
\item{Self ClampOff():}{}
\item{Self ClampOn():}{
Set the value of Clamp to true or false respectfully.
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{double GetAmount() const:}{
Set/Get amount of enhancement. Usual range: 0.1 to 2.0. Default: 0.5.
}
\item{bool GetClamp() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< double > GetSigmas() const:}{
Set/Get Sigma values measured in the units of image spacing. Default:
1.0.
}
\item{double GetThreshold() const:}{
Set/Get threshold for enhancement. Default: 0.
}
\item{Self SetAmount(double Amount):}{
Set/Get amount of enhancement. Usual range: 0.1 to 2.0. Default: 0.5.
}
\item{Self SetClamp(bool Clamp):}{
Set/Get whether to clamp values to supported range of output type.
}
\item{Self SetSigmas(double s):}{
Custom public declarations
}
\item{Self SetSigmas(std::vector< double > Sigmas):}{
Set/Get Sigma values measured in the units of image spacing. Default:
1.0.
}
\item{Self SetThreshold(double Threshold):}{
Set/Get threshold for enhancement. Default: 0.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ UnsharpMaskImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{ ~UnsharpMaskImageFilter():}{
Destructor
}
}
}
