\name{LandmarkBasedTransformInitializerFilter}
\alias{LandmarkBasedTransformInitializerFilter}
\title{LandmarkBasedTransformInitializerFilter}
\Rdversion{1.1}
\docType{class}
\description{LandmarkBasedTransformInitializerFilter}
\details{
This class computes the transform that aligns the fixed and moving
images given a set of pair landmarks. The class is templated over the Transform type as well as fixed image and moving image types. The transform
computed gives the best fit transform that maps the fixed and moving
images in a least squares sense. The indices are taken to correspond,
so point 1 in the first set will get mapped close to point 1 in the
second set, etc.
Currently, the following transforms are supported by the class:
VersorRigid3DTransform
Similarity3DTransform
Rigid2DTransform
AffineTransform
BSplineTransform
An equal number of fixed and moving landmarks need to be specified
using SetFixedLandmarks() and SetMovingLandmarks() . Any number of landmarks may be specified. In the case of using
Affine or BSpline transforms, each landmark pair can contribute in the
final transform based on its defined weight. Number of weights should
be equal to the number of landmarks and can be specified using SetLandmarkWeight() . By defaults are weights are set to one. Call InitializeTransform()
to initialize the transform.
The class is based in part on Hybrid/vtkLandmarkTransform originally
implemented in python by David G. Gobbi.
The solution is based on Berthold K. P. Horn (1987), "Closed-form
solution of absolute orientation using unit quaternions," http://people.csail.mit.edu/bkph/papers/Absolute_Orientation.pdf
The Affine Transform initializer is based on an algorithm by H Spaeth, and is described in
the Insight Journal Article "Affine Transformation for Landmark Based
Registration Initializer in ITK" by Kim E.Y., Johnson H., Williams N.
available at https://www.midasjournal.org/browse/publication/825
Wiki Examples:
All Examples
Rigidly register one image to another using manually specified
landmarks
See:
LandmarkBasedTransformInitializerFilter for the procedural interface
itk::LandmarkBasedTransformInitializer for the Doxygen on the original ITK class.
LandmarkBasedTransformInitializerFilter}
%C++ includes: sitkLandmarkBasedTransformInitializerFilter.h
\section{Methods}{
\describe{
\item{Transform Execute(const Transform &transform):}{
Execute the filter on the input image
}
\item{unsigned int GetBSplineNumberOfControlPoints() const:}{
Set/Get the number of control points
}
\item{std::vector< double > GetFixedLandmarks() const:}{}
\item{std::vector< double > GetLandmarkWeight() const:}{}
\item{std::vector< double > GetMovingLandmarks() const:}{
Get the shrink factors.
}
\item{std::string GetName() const override:}{
Name of this class
}
\item{Image GetReferenceImage() const:}{}
\item{ LandmarkBasedTransformInitializerFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetBSplineNumberOfControlPoints(unsigned int BSplineNumberOfControlPoints):}{
Set/Get the number of control points
}
\item{Self SetFixedLandmarks(const std::vector< double > &FixedLandmarks):}{
Set the Fixed landmark point containers
}
\item{Self SetLandmarkWeight(const std::vector< double > &LandmarkWeight):}{
Set the landmark weight point containers Weight includes diagonal
elements of weight matrix
}
\item{Self SetMovingLandmarks(const std::vector< double > &MovingLandmarks):}{
Set the Moving landmark point containers
}
\item{Self SetReferenceImage(const Image &ReferenceImage):}{
Set the reference image to define the parametric domain for the
BSpline transform
}
\item{std::string ToString() const override:}{
Print ourselves out
}
\item{ ~LandmarkBasedTransformInitializerFilter() override:}{
Destructor
}
}
}
