/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jobscheduler.transport.action;

import java.io.IOException;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.time.DateFormatter;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.jobscheduler.ScheduledJobProvider;
import org.opensearch.jobscheduler.scheduler.JobScheduler;
import org.opensearch.jobscheduler.scheduler.JobSchedulingInfo;
import org.opensearch.jobscheduler.scheduler.ScheduledJobInfo;
import org.opensearch.jobscheduler.spi.schedule.CronSchedule;
import org.opensearch.jobscheduler.spi.schedule.IntervalSchedule;
import org.opensearch.jobscheduler.spi.schedule.Schedule;
import org.opensearch.jobscheduler.transport.request.GetScheduledInfoNodeRequest;
import org.opensearch.jobscheduler.transport.request.GetScheduledInfoRequest;
import org.opensearch.jobscheduler.transport.response.GetScheduledInfoNodeResponse;
import org.opensearch.jobscheduler.transport.response.GetScheduledInfoResponse;
import org.opensearch.jobscheduler.utils.JobDetailsService;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportGetScheduledInfoAction
extends TransportNodesAction<GetScheduledInfoRequest, GetScheduledInfoResponse, GetScheduledInfoNodeRequest, GetScheduledInfoNodeResponse> {
    private static final Logger log = LogManager.getLogger(JobScheduler.class);
    private final JobScheduler jobScheduler;
    private final JobDetailsService jobDetailsService;
    private static final DateFormatter STRICT_DATE_TIME_FORMATTER = DateFormatter.forPattern((String)"strict_date_time");

    @Inject
    public TransportGetScheduledInfoAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, JobScheduler jobScheduler, JobDetailsService jobDetailsService) {
        super("cluster:admin/opensearch/jobscheduler/jobs/all", threadPool, clusterService, transportService, actionFilters, GetScheduledInfoRequest::new, GetScheduledInfoNodeRequest::new, "management", GetScheduledInfoNodeResponse.class);
        this.jobScheduler = jobScheduler;
        this.jobDetailsService = jobDetailsService;
    }

    protected GetScheduledInfoResponse newResponse(GetScheduledInfoRequest request, List<GetScheduledInfoNodeResponse> nodeResponses, List<FailedNodeException> failures) {
        return new GetScheduledInfoResponse(this.clusterService.getClusterName(), nodeResponses, failures);
    }

    protected GetScheduledInfoNodeRequest newNodeRequest(GetScheduledInfoRequest request) {
        return new GetScheduledInfoNodeRequest(request);
    }

    protected GetScheduledInfoNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new GetScheduledInfoNodeResponse(in);
    }

    protected GetScheduledInfoNodeResponse nodeOperation(GetScheduledInfoNodeRequest request) {
        GetScheduledInfoNodeResponse response = new GetScheduledInfoNodeResponse(this.clusterService.localNode());
        HashMap<String, Object> scheduledJobInfo = new HashMap<String, Object>();
        Map<String, ScheduledJobProvider> indexToJobProvider = this.jobDetailsService.getIndexToJobProviders();
        try {
            ScheduledJobInfo scheduledJobInfoLocal;
            ArrayList jobs = new ArrayList();
            if (this.jobScheduler != null && (scheduledJobInfoLocal = this.jobScheduler.getScheduledJobInfo()) != null && scheduledJobInfoLocal.getJobInfoMap() != null) {
                for (Map.Entry<String, Map<String, JobSchedulingInfo>> indexEntry : scheduledJobInfoLocal.getJobInfoMap().entrySet()) {
                    String indexName = indexEntry.getKey();
                    Map<String, JobSchedulingInfo> jobsMap = indexEntry.getValue();
                    if (jobsMap == null) continue;
                    for (Map.Entry<String, JobSchedulingInfo> jobEntry : jobsMap.entrySet()) {
                        String jobId = jobEntry.getKey();
                        JobSchedulingInfo jobInfo = jobEntry.getValue();
                        if (jobInfo == null) {
                            log.debug("JobInfo {} does not exist.", (Object)jobId);
                            continue;
                        }
                        LinkedHashMap<String, Object> jobDetails = new LinkedHashMap<String, Object>();
                        String jobType = indexToJobProvider.get(indexName).getJobType();
                        jobDetails.put("job_type", jobType);
                        jobDetails.put("job_id", jobId);
                        jobDetails.put("index_name", indexName);
                        jobDetails.put("name", jobInfo.getJobParameter().getName());
                        jobDetails.put("descheduled", jobInfo.isDescheduled());
                        jobDetails.put("enabled", jobInfo.getJobParameter().isEnabled());
                        jobDetails.put("enabled_time", STRICT_DATE_TIME_FORMATTER.format((TemporalAccessor)jobInfo.getJobParameter().getEnabledTime().atOffset(ZoneOffset.UTC)));
                        jobDetails.put("last_update_time", STRICT_DATE_TIME_FORMATTER.format((TemporalAccessor)jobInfo.getJobParameter().getLastUpdateTime().atOffset(ZoneOffset.UTC)));
                        if (jobInfo.getActualPreviousExecutionTime() != null) {
                            jobDetails.put("last_execution_time", STRICT_DATE_TIME_FORMATTER.format((TemporalAccessor)jobInfo.getActualPreviousExecutionTime().atOffset(ZoneOffset.UTC)));
                        } else {
                            jobDetails.put("last_execution_time", "none");
                        }
                        if (jobInfo.getExpectedPreviousExecutionTime() != null) {
                            jobDetails.put("last_expected_execution_time", STRICT_DATE_TIME_FORMATTER.format((TemporalAccessor)jobInfo.getExpectedPreviousExecutionTime().atOffset(ZoneOffset.UTC)));
                        } else {
                            jobDetails.put("last_expected_execution_time", "none");
                        }
                        if (jobInfo.getExpectedExecutionTime() != null) {
                            jobDetails.put("next_expected_execution_time", STRICT_DATE_TIME_FORMATTER.format((TemporalAccessor)jobInfo.getExpectedExecutionTime().atOffset(ZoneOffset.UTC)));
                        } else {
                            jobDetails.put("next_expected_execution_time", "none");
                        }
                        if (jobInfo.getJobParameter().getSchedule() == null) {
                            log.debug("Schedule for job {} does not exist.", (Object)jobId);
                        } else {
                            LinkedHashMap<String, Object> scheduleMap = new LinkedHashMap<String, Object>();
                            Schedule schedule = jobInfo.getJobParameter().getSchedule();
                            if (schedule instanceof IntervalSchedule) {
                                IntervalSchedule intervalSchedule = (IntervalSchedule)schedule;
                                scheduleMap.put("type", "interval");
                                scheduleMap.put("start_time", STRICT_DATE_TIME_FORMATTER.format((TemporalAccessor)intervalSchedule.getStartTime().atOffset(ZoneOffset.UTC)));
                                scheduleMap.put("interval", intervalSchedule.getInterval());
                                scheduleMap.put("unit", intervalSchedule.getUnit().toString());
                                scheduleMap.put("delay", jobInfo.getJobParameter().getSchedule().getDelay() != null ? jobInfo.getJobParameter().getSchedule().getDelay() : "none");
                            } else {
                                schedule = jobInfo.getJobParameter().getSchedule();
                                if (schedule instanceof CronSchedule) {
                                    CronSchedule cronSchedule = (CronSchedule)schedule;
                                    scheduleMap.put("type", "cron");
                                    scheduleMap.put("expression", cronSchedule.getCronExpression());
                                    scheduleMap.put("timezone", cronSchedule.getTimeZone().getId());
                                    scheduleMap.put("delay", jobInfo.getJobParameter().getSchedule().getDelay() != null ? jobInfo.getJobParameter().getSchedule().getDelay() : "none");
                                } else {
                                    scheduleMap.put("type", "unknown");
                                }
                            }
                            jobDetails.put("schedule", scheduleMap);
                        }
                        jobDetails.put("lock_duration", jobInfo.getJobParameter().getLockDurationSeconds() != null ? jobInfo.getJobParameter().getLockDurationSeconds() : "no_lock");
                        jobDetails.put("jitter", jobInfo.getJobParameter().getJitter() != null ? jobInfo.getJobParameter().getJitter() : "none");
                        jobs.add(jobDetails);
                    }
                }
            }
            scheduledJobInfo.put("jobs", jobs);
            scheduledJobInfo.put("total_jobs", jobs.size());
        }
        catch (Exception e) {
            scheduledJobInfo.put("jobs", new ArrayList());
            scheduledJobInfo.put("total_jobs", 0);
            scheduledJobInfo.put("error", e.getMessage());
        }
        response.setScheduledJobInfo(scheduledJobInfo);
        return response;
    }
}

