/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import mediathek.config.Daten;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.MVC;
import mediathek.tool.cellrenderer.CellRendererColor;
import mediathek.tool.models.TModelColor;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;

public class PanelEinstellungenColor
extends JPanel {
    private JTable jTable1;
    private JButton jButtonReset;

    public PanelEinstellungenColor() {
        this.initComponents();
        this.init();
    }

    public void updateGui() {
        try {
            SwingUtilities.updateComponentTreeUI(MediathekGui.ui());
            for (Frame f : Frame.getFrames()) {
                SwingUtilities.updateComponentTreeUI(f);
                for (Window w : f.getOwnedWindows()) {
                    SwingUtilities.updateComponentTreeUI(w);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void init() {
        this.jTable1.addMouseListener(new BeobMausTabelle());
        this.jTable1.setDefaultRenderer(MVC.class, new CellRendererColor());
        this.jTable1.setModel(this.getModel());
        this.jButtonReset.addActionListener(e -> {
            Daten.mVColor.reset();
            this.updateGui();
            Daten.mVColor.save();
        });
    }

    private void getColor(MVC mvc) {
        Color selectedColor = JColorChooser.showDialog(this, "Farbe ausw\u00e4hlen", mvc.color);
        if (selectedColor != null && !selectedColor.equals(mvc.color)) {
            mvc.set(selectedColor);
            this.jTable1.setModel(this.getModel());
            this.updateGui();
            Daten.mVColor.save();
        }
    }

    private TableModel getModel() {
        TModelColor tModel = new TModelColor(new Object[0][]);
        tModel.setRowCount(0);
        for (MVC mvc : Daten.mVColor.liste) {
            Object[] object = new Object[]{mvc.text, mvc};
            tModel.addRow(object);
        }
        return tModel;
    }

    private void initComponents() {
        JScrollPane jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        JPanel hSpacer1 = new JPanel(null);
        this.jButtonReset = new JButton();
        this.setLayout(new MigLayout(new LC().insets("0").hideMode(3).gridGap("5", "5"), new AC().fill().gap().grow().fill().gap().fill(), new AC().grow().fill().gap().fill()));
        jScrollPane1.setViewportView(this.jTable1);
        this.add((Component)jScrollPane1, new CC().cell(1, 0, 2, 1));
        this.add((Component)hSpacer1, new CC().cell(1, 1));
        this.jButtonReset.setText("Farben zur\u00fccksetzen");
        this.add((Component)this.jButtonReset, new CC().cell(2, 1));
    }

    public class BeobMausTabelle
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getButton() == 1 && arg0.getClickCount() == 1) {
                Point p = arg0.getPoint();
                int row = PanelEinstellungenColor.this.jTable1.rowAtPoint(p);
                int column = PanelEinstellungenColor.this.jTable1.columnAtPoint(p);
                if (row >= 0) {
                    MVC mvc = (MVC)PanelEinstellungenColor.this.jTable1.getModel().getValueAt(PanelEinstellungenColor.this.jTable1.convertRowIndexToModel(row), 1);
                    if (PanelEinstellungenColor.this.jTable1.convertColumnIndexToModel(column) == 1) {
                        PanelEinstellungenColor.this.getColor(mvc);
                    }
                }
            }
        }
    }
}

