/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.DelegateAction;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.event.SearchableEvent;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class TextComponentSearchable
extends Searchable
implements DocumentListener,
PropertyChangeListener {
    private Highlighter.HighlightPainter _highlightPainter;
    private static final Color DEFAULT_HIGHLIGHT_COLOR = new Color(204, 204, 255);
    private Color _highlightColor = null;
    private int _selectedIndex = -1;
    private HighlighCache _highlighCache = new HighlighCache();
    private String _text = null;

    public TextComponentSearchable(JTextComponent textComponent) {
        super(textComponent);
        this.installHighlightsRemover();
        this.setHighlightColor(DEFAULT_HIGHLIGHT_COLOR);
    }

    public void uninstallHighlightsRemover() {
        DelegateAction.restoreAction(this._component, 0, KeyStroke.getKeyStroke(27, 0));
    }

    public void installHighlightsRemover() {
        DelegateAction.replaceAction(this._component, 0, KeyStroke.getKeyStroke(27, 0), new DelegateAction(){
            private static final long serialVersionUID = 8572103995404313032L;

            @Override
            public boolean isDelegateEnabled() {
                Iterator highlights;
                if (TextComponentSearchable.this._component instanceof JTextComponent && !(highlights = TextComponentSearchable.this._highlighCache.getAllHighlights()).hasNext()) {
                    return false;
                }
                return super.isDelegateEnabled();
            }

            @Override
            public boolean delegateActionPerformed(ActionEvent e) {
                Iterator highlights;
                if (TextComponentSearchable.this._component instanceof JTextComponent && !(highlights = TextComponentSearchable.this._highlighCache.getAllHighlights()).hasNext()) {
                    return false;
                }
                TextComponentSearchable.this.removeAllHighlights();
                return true;
            }
        });
    }

    @Override
    public void installListeners() {
        super.installListeners();
        if (this._component instanceof JTextComponent) {
            ((JTextComponent)this._component).getDocument().addDocumentListener(this);
            this._component.addPropertyChangeListener("document", this);
        }
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        if (this._component instanceof JTextComponent) {
            ((JTextComponent)this._component).getDocument().removeDocumentListener(this);
            this._component.removePropertyChangeListener("document", this);
        }
    }

    @Override
    protected void setSelectedIndex(int index, boolean incremental) {
        if (this._component instanceof JTextComponent) {
            if (index == -1) {
                this.removeAllHighlights();
                this._selectedIndex = -1;
                return;
            }
            if (!incremental) {
                this.removeAllHighlights();
            }
            String text = this.getSearchingText();
            try {
                this.addHighlight(index, text, incremental);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    protected void addHighlight(final int index, final String text, boolean incremental) throws BadLocationException {
        if (this._component instanceof JTextComponent) {
            final JTextComponent textComponent = (JTextComponent)this._component;
            Object obj = textComponent.getHighlighter().addHighlight(index, index + text.length(), this._highlightPainter);
            this._highlighCache.addHighlight(obj);
            this._selectedIndex = index;
            if (!incremental) {
                Runnable runnable2 = new Runnable(){

                    @Override
                    public void run() {
                        TextComponentSearchable.this.scrollTextVisible(textComponent, index, text.length());
                    }
                };
                SwingUtilities.invokeLater(runnable2);
            }
        }
    }

    private void scrollTextVisible(JTextComponent textComponent, int index, int length) {
        if (index != -1) {
            try {
                Rectangle begin = textComponent.modelToView(index);
                if (begin == null) {
                    return;
                }
                Rectangle end = textComponent.modelToView(index + length);
                if (end == null) {
                    return;
                }
                Rectangle bounds = this._component.getVisibleRect();
                if (begin.x <= bounds.width) {
                    begin.width = end.x;
                    begin.x = 0;
                } else {
                    begin.width = end.x - begin.x;
                }
                textComponent.scrollRectToVisible(begin);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    protected void removeAllHighlights() {
        if (this._component instanceof JTextComponent) {
            Iterator itor = this._highlighCache.getAllHighlights();
            while (itor.hasNext()) {
                Object o = itor.next();
                ((JTextComponent)this._component).getHighlighter().removeHighlight(o);
            }
            this._highlighCache.removeAllHighlights();
        }
    }

    @Override
    protected int getSelectedIndex() {
        if (this._component instanceof JTextComponent) {
            return this._selectedIndex;
        }
        return 0;
    }

    @Override
    protected Object getElementAt(int index) {
        String text = this.getSearchingText();
        if (text != null && this._component instanceof JTextComponent) {
            int elementCount;
            int endIndex = index + text.length();
            if (endIndex > (elementCount = this.getElementCount())) {
                endIndex = this.getElementCount();
            }
            try {
                return ((JTextComponent)this._component).getDocument().getText(index, endIndex - index + 1);
            }
            catch (BadLocationException e) {
                return null;
            }
        }
        return "";
    }

    @Override
    protected int getElementCount() {
        if (this._component instanceof JTextComponent) {
            return ((JTextComponent)this._component).getDocument().getLength();
        }
        return 0;
    }

    @Override
    protected String convertElementToString(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.isProcessModelChangeEvent()) {
            this.hidePopup();
            this._text = null;
            if (evt.getOldValue() instanceof Document) {
                ((Document)evt.getNewValue()).removeDocumentListener(this);
            }
            if (evt.getNewValue() instanceof Document) {
                ((Document)evt.getNewValue()).addDocumentListener(this);
            }
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this.isProcessModelChangeEvent()) {
            this.hidePopup();
            this._text = null;
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this.isProcessModelChangeEvent()) {
            this.hidePopup();
            this._text = null;
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (this.isProcessModelChangeEvent()) {
            this.hidePopup();
            this._text = null;
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    @Override
    protected boolean isActivateKey(KeyEvent e) {
        if (this._component instanceof JTextComponent && ((JTextComponent)this._component).isEditable()) {
            return e.getID() == 401 && e.getKeyCode() == 70 && JideSwingUtilities.isMenuShortcutKeyDown(e);
        }
        return super.isActivateKey(e);
    }

    public Color getHighlightColor() {
        if (this._highlightColor != null) {
            return this._highlightColor;
        }
        return DEFAULT_HIGHLIGHT_COLOR;
    }

    public void setHighlightColor(Color highlightColor) {
        this._highlightColor = highlightColor;
        this._highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(this._highlightColor);
    }

    @Override
    public int findLast(String s2) {
        if (this._component instanceof JTextComponent) {
            String text = this.getDocumentText();
            if (this.isCaseSensitive()) {
                return text.lastIndexOf(s2);
            }
            return TextComponentSearchable.lastIndexOf(text, s2, text.length());
        }
        return super.findLast(s2);
    }

    private String getDocumentText() {
        if (this._text == null) {
            Document document = ((JTextComponent)this._component).getDocument();
            try {
                String text;
                this._text = text = document.getText(0, document.getLength());
            }
            catch (BadLocationException e) {
                return "";
            }
        }
        return this._text;
    }

    @Override
    public int findFirst(String s2) {
        if (this._component instanceof JTextComponent) {
            String text = this.getDocumentText();
            if (this.isCaseSensitive()) {
                return text.indexOf(s2);
            }
            return TextComponentSearchable.indexOf(text, s2, 0);
        }
        return super.findFirst(s2);
    }

    static int lastIndexOf(String source2, String target, int fromIndex2) {
        int sourceCount = source2.length();
        int targetCount = target.length();
        int rightIndex = sourceCount - targetCount;
        if (fromIndex2 < 0) {
            return -1;
        }
        if (fromIndex2 > rightIndex) {
            fromIndex2 = rightIndex;
        }
        if (targetCount == 0) {
            return fromIndex2;
        }
        char[] lowerTarget = target.toLowerCase().toCharArray();
        char[] upperTarget = target.toUpperCase().toCharArray();
        int strLastIndex = targetCount - 1;
        int min2 = targetCount - 1;
        int i = min2 + fromIndex2;
        while (i >= min2) {
            while (i >= min2 && source2.charAt(i) != lowerTarget[strLastIndex] && source2.charAt(i) != upperTarget[strLastIndex]) {
                --i;
            }
            if (i < min2) break;
            int j = i - 1;
            int start = j - (targetCount - 1);
            int k = strLastIndex - 1;
            while (j > start) {
                char ch = source2.charAt(j);
                if (ch != lowerTarget[k] && ch != upperTarget[k]) {
                    --i;
                    break;
                }
                --j;
                --k;
            }
            if (j > start) continue;
            return start + 1;
        }
        return -1;
    }

    private static int indexOf(String source2, String target, int fromIndex2) {
        int sourceCount = source2.length();
        int targetCount = target.length();
        if (fromIndex2 >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex2 < 0) {
            fromIndex2 = 0;
        }
        if (targetCount == 0) {
            return fromIndex2;
        }
        char[] lowerTarget = target.toLowerCase().toCharArray();
        char[] upperTarget = target.toUpperCase().toCharArray();
        int max = sourceCount - targetCount;
        for (int i = fromIndex2; i <= max; ++i) {
            char ch;
            int j;
            char c = source2.charAt(i);
            if (c != lowerTarget[0] && c != upperTarget[0]) {
                ++i;
                while (i <= max && source2.charAt(i) != lowerTarget[0] && source2.charAt(i) != upperTarget[0]) {
                    ++i;
                }
            }
            if (i > max) continue;
            int end = j + targetCount - 1;
            int k = 1;
            for (j = i + 1; j < end && ((ch = source2.charAt(j)) == lowerTarget[k] || ch == upperTarget[k]); ++j) {
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int findFromCursor(String s2) {
        String text;
        if (this.isCountMatch()) {
            int oldIndex;
            text = this.getDocumentText();
            int newIndex = 0;
            this._matchCount = -1;
            do {
                oldIndex = newIndex;
                newIndex = (this.isCaseSensitive() ? text.indexOf(s2, oldIndex) : TextComponentSearchable.indexOf(text, s2, oldIndex)) + 1;
                ++this._matchCount;
            } while (newIndex > oldIndex);
        }
        if (this.isReverseOrder()) {
            return this.reverseFindFromCursor(s2);
        }
        if (this._component instanceof JTextComponent) {
            int found;
            int count;
            int selectedIndex;
            text = this.getDocumentText();
            int n = selectedIndex = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (selectedIndex < 0) {
                selectedIndex = 0;
            }
            if ((count = this.getElementCount()) == 0) {
                return s2.length() > 0 ? -1 : 0;
            }
            int n2 = found = this.isCaseSensitive() ? text.indexOf(s2, selectedIndex) : TextComponentSearchable.indexOf(text, s2, selectedIndex);
            if (found == -1) {
                int n3 = found = this.isCaseSensitive() ? text.indexOf(s2, 0) : TextComponentSearchable.indexOf(text, s2, 0);
                if (found >= selectedIndex) {
                    found = -1;
                }
            }
            return found;
        }
        return super.findFromCursor(s2);
    }

    @Override
    public int reverseFindFromCursor(String s2) {
        if (!this.isReverseOrder()) {
            return this.findFromCursor(s2);
        }
        if (this._component instanceof JTextComponent) {
            int found;
            int count;
            int selectedIndex;
            String text = this.getDocumentText();
            int n = selectedIndex = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (selectedIndex < 0) {
                selectedIndex = 0;
            }
            if ((count = this.getElementCount()) == 0) {
                return s2.length() > 0 ? -1 : 0;
            }
            int n2 = found = this.isCaseSensitive() ? text.lastIndexOf(s2, selectedIndex) : TextComponentSearchable.lastIndexOf(text, s2, selectedIndex);
            if (found == -1) {
                int n3 = found = this.isCaseSensitive() ? text.lastIndexOf(s2, text.length() - 1) : TextComponentSearchable.lastIndexOf(text, s2, text.length() - 1);
                if (found <= selectedIndex) {
                    found = -1;
                }
            }
            return found;
        }
        return super.findFromCursor(s2);
    }

    @Override
    public int findNext(String s2) {
        if (this._component instanceof JTextComponent) {
            int found;
            int count;
            int selectedIndex;
            String text = this.getDocumentText();
            int n = selectedIndex = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (selectedIndex < 0) {
                selectedIndex = 0;
            }
            if ((count = this.getElementCount()) == 0) {
                return s2.length() > 0 ? -1 : 0;
            }
            int n2 = found = this.isCaseSensitive() ? text.indexOf(s2, selectedIndex + 1) : TextComponentSearchable.indexOf(text, s2, selectedIndex + 1);
            if (found == -1 && this.isRepeats()) {
                int n3 = found = this.isCaseSensitive() ? text.indexOf(s2, 0) : TextComponentSearchable.indexOf(text, s2, 0);
                if (found > selectedIndex) {
                    found = -1;
                }
            }
            return found;
        }
        return super.findNext(s2);
    }

    @Override
    public int findPrevious(String s2) {
        if (this._component instanceof JTextComponent) {
            int found;
            int count;
            int selectedIndex;
            String text = this.getDocumentText();
            int n = selectedIndex = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (selectedIndex < 0) {
                selectedIndex = 0;
            }
            if ((count = this.getElementCount()) == 0) {
                return s2.length() > 0 ? -1 : 0;
            }
            int n2 = found = this.isCaseSensitive() ? text.lastIndexOf(s2, selectedIndex - 1) : TextComponentSearchable.lastIndexOf(text, s2, selectedIndex - 1);
            if (found == -1 && this.isRepeats()) {
                int n3 = found = this.isCaseSensitive() ? text.lastIndexOf(s2, count - 1) : TextComponentSearchable.lastIndexOf(text, s2, count - 1);
                if (found < selectedIndex) {
                    found = -1;
                }
            }
            return found;
        }
        return super.findPrevious(s2);
    }

    @Override
    public void hidePopup() {
        super.hidePopup();
        this._selectedIndex = -1;
    }

    @Override
    protected void searchingTextEmpty() {
        this.setSelectedIndex(-1, false);
    }

    private class HighlighCache
    extends HashMap {
        private HighlighCache() {
        }

        public void addHighlight(Object obj) {
            this.put(obj, null);
        }

        public void removeHighlight(Object obj) {
            this.remove(obj);
        }

        public Iterator getAllHighlights() {
            return this.keySet().iterator();
        }

        public void removeAllHighlights() {
            this.clear();
        }
    }
}

