/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;
import ghidra.util.exception.NotFoundException;

public class AVR8_ElfRelocationHandler
extends ElfRelocationHandler {
    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 83;
    }

    public RelocationResult relocate(ElfRelocationContext elfRelocationContext, ElfRelocation relocation, Address relocationAddress) throws MemoryAccessException, NotFoundException {
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        int type = relocation.getType();
        int symbolIndex = relocation.getSymbolIndex();
        long addend = relocation.getAddend();
        ElfHeader elf = elfRelocationContext.getElfHeader();
        long offset = relocationAddress.getOffset();
        ElfSymbol sym = elfRelocationContext.getSymbol(symbolIndex);
        long symbolValue = elfRelocationContext.getSymbolValue(sym);
        String symbolName = elfRelocationContext.getSymbolName(symbolIndex);
        short oldValue = memory.getShort(relocationAddress);
        if (elf.e_machine() != 83) {
            return RelocationResult.FAILURE;
        }
        int newValue = 0;
        int byteLength = 2;
        switch (type) {
            case 0: {
                return RelocationResult.SKIPPED;
            }
            case 1: {
                newValue = (int)symbolValue + (int)addend & 0xFFFFFFFF;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 2: {
                newValue = (int)(symbolValue * 2L + (long)((int)addend) - offset);
                if (((newValue -= 2) & 1) == 1) {
                    AVR8_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (long)type, (String)symbolName, (String)"relocation out of range", (MessageLog)elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                if (newValue > 127 || newValue < -128) {
                    AVR8_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (long)type, (String)symbolName, (String)"relocation overflow", (MessageLog)elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                newValue = oldValue & 0xFC07 | newValue >> 1 << 3 & 0x3F8;
                memory.setShort(relocationAddress, (short)newValue);
                break;
            }
            case 3: {
                newValue = (int)(symbolValue * 2L + (long)((int)addend) - offset);
                if (((newValue -= 2) & 1) == 1) {
                    AVR8_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (long)type, (String)symbolName, (String)"relocation out of range", (MessageLog)elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                if ((newValue >>= 1) < -2048 || newValue > 2047) {
                    AVR8_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)symbolName, (String)symbolName, (long)symbolIndex, (String)"possible relocation error", (MessageLog)elfRelocationContext.getLog());
                }
                newValue = oldValue & 0xF000 | newValue & 0xFFF;
                memory.setShort(relocationAddress, (short)newValue);
                break;
            }
            case 4: {
                newValue = (int)symbolValue + (int)addend;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case 5: {
                newValue = (int)symbolValue * 2 + (int)addend;
                memory.setShort(relocationAddress, (short)((newValue >>= 1) & 0xFFFF));
                break;
            }
            case 6: {
                newValue = (int)symbolValue + (int)addend;
                newValue = oldValue & 0xF0F0 | newValue & 0xF | newValue << 4 & 0xF00;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case 7: {
                newValue = (int)symbolValue + (int)addend;
                newValue = newValue >> 8 & 0xFF;
                newValue = oldValue & 0xF0F0 | newValue & 0xF | newValue << 4 & 0xF00;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case 8: {
                newValue = (int)symbolValue + (int)addend;
                newValue = newValue >> 16 & 0xFF;
                newValue = oldValue & 0xF0F0 | newValue & 0xF | newValue << 4 & 0xF00;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case 9: {
                newValue = (int)symbolValue + (int)addend;
                newValue = -newValue;
                newValue = oldValue & 0xF0F0 | newValue & 0xF | newValue << 4 & 0xF00;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case 10: {
                newValue = (int)symbolValue + (int)addend;
                newValue = -newValue;
                newValue = newValue >> 8 & 0xFF;
                newValue = oldValue & 0xF0F0 | newValue & 0xF | newValue << 4 & 0xF00;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case 11: {
                newValue = (int)symbolValue + (int)addend;
                newValue = -newValue;
                newValue = newValue >> 16 & 0xFF;
                newValue = oldValue & 0xF0F0 | newValue & 0xF | newValue << 4 & 0xF00;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case 12: {
                newValue = (int)symbolValue * 2 + (int)addend;
                if ((newValue & 1) == 1) {
                    AVR8_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (long)type, (String)symbolName, (String)"relocation out of range", (MessageLog)elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                newValue >>= 1;
                newValue = oldValue & 0xF0F0 | newValue & 0xF | newValue << 4 & 0xF00;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case 13: {
                newValue = (int)symbolValue * 2 + (int)addend;
                if ((newValue & 1) == 1) {
                    AVR8_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (long)type, (String)symbolName, (String)"relocation out of range", (MessageLog)elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                newValue >>= 1;
                newValue = newValue >> 8 & 0xFF;
                newValue = oldValue & 0xF0F0 | newValue & 0xF | newValue << 4 & 0xF00;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case 14: {
                newValue = (int)symbolValue * 2 + (int)addend;
                if ((newValue & 1) == 1) {
                    AVR8_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (long)type, (String)symbolName, (String)"relocation out of range", (MessageLog)elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                newValue >>= 1;
                newValue = newValue >> 16 & 0xFF;
                newValue = oldValue & 0xF0F0 | newValue & 0xF | newValue << 4 & 0xF00;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case 15: {
                newValue = (int)symbolValue * 2 + (int)addend;
                newValue = -newValue;
                if ((newValue & 1) == 1) {
                    AVR8_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (long)type, (String)symbolName, (String)"relocation out of range", (MessageLog)elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                newValue >>= 1;
                newValue = oldValue & 0xF0F0 | newValue & 0xF | newValue << 4 & 0xF00;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case 16: {
                newValue = (int)symbolValue * 2 + (int)addend;
                newValue = -newValue;
                if ((newValue & 1) == 1) {
                    AVR8_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (long)type, (String)symbolName, (String)"relocation out of range", (MessageLog)elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                newValue >>= 1;
                newValue = newValue >> 8 & 0xFF;
                newValue = oldValue & 0xF0F0 | newValue & 0xF | newValue << 4 & 0xF00;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case 17: {
                newValue = (int)symbolValue * 2 + (int)addend;
                newValue = -newValue;
                if ((newValue & 1) == 1) {
                    AVR8_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (long)type, (String)symbolName, (String)"relocation out of range", (MessageLog)elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                newValue >>= 1;
                newValue = newValue >> 16 & 0xFF;
                newValue = oldValue & 0xF0F0 | newValue & 0xF | newValue << 4 & 0xF00;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case 18: {
                newValue = (int)symbolValue * 2 + (int)addend;
                if ((newValue & 1) == 1) {
                    AVR8_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (long)type, (String)symbolName, (String)"relocation out of range", (MessageLog)elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                int hiValue = oldValue | ((newValue >>= 1) & 0x10000 | newValue << 3 & 0x1F00000) >> 16;
                memory.setShort(relocationAddress, (short)(hiValue & 0xFFFF));
                memory.setShort(relocationAddress.add(2L), (short)(newValue & 0xFFFF));
                byteLength = 4;
                break;
            }
            case 19: {
                newValue = (int)symbolValue + (int)addend;
                if ((newValue & 0xFFFF) > 255) {
                    AVR8_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (long)type, (String)symbolName, (String)"relocation out of range", (MessageLog)elfRelocationContext.getLog());
                }
                newValue = newValue >> 8 & 0xFF;
                newValue = oldValue & 0xF0F0 | newValue & 0xF | newValue << 4 & 0xF00;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case 20: {
                newValue = (int)symbolValue + (int)addend;
                if ((newValue & 0xFFFF) > 63 || newValue < 0) {
                    AVR8_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (long)type, (String)symbolName, (String)"relocation out of range", (MessageLog)elfRelocationContext.getLog());
                }
                newValue = oldValue & 0xD3F8 | newValue & 7 | (newValue & 0x18) << 7 | (newValue & 0x20) << 8;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case 21: {
                newValue = (int)symbolValue + (int)addend;
                if ((newValue & 0xFFFF) > 63 || newValue < 0) {
                    AVR8_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (long)type, (String)symbolName, (String)"relocation out of range", (MessageLog)elfRelocationContext.getLog());
                }
                newValue = oldValue & 0xFF30 | newValue & 0xF | (newValue & 0x30) << 2;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                break;
            }
            case 33: {
                newValue = (int)symbolValue + (int)addend;
                if ((newValue & 0xFFFF) < 64 || (newValue & 0xFFFF) > 191) {
                    AVR8_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (long)type, (String)symbolName, (String)"relocation out of range", (MessageLog)elfRelocationContext.getLog());
                }
                newValue &= 0x7F;
                newValue = oldValue & 0xF | (newValue & 0x30) << 5 | (newValue & 0x40) << 2;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case 34: {
                newValue = (int)symbolValue + (int)addend;
                if ((newValue & 0xFFFF) > 63) {
                    AVR8_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (long)type, (String)symbolName, (String)"relocation out of range", (MessageLog)elfRelocationContext.getLog());
                }
                newValue = oldValue & 0xF9F0 | (newValue & 0x30) << 5 | newValue & 0xF;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            case 35: {
                newValue = (int)symbolValue + (int)addend;
                if ((newValue & 0xFFFF) > 31) {
                    AVR8_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (long)type, (String)symbolName, (String)"relocation out of range", (MessageLog)elfRelocationContext.getLog());
                }
                newValue = oldValue & 0xFF07 | (newValue & 0x1F) << 3;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFF));
                break;
            }
            default: {
                AVR8_ElfRelocationHandler.markAsUnhandled((Program)program, (Address)relocationAddress, (long)type, (long)symbolIndex, (String)symbolName, (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }
}

