/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.target.schema;

import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.DefaultSchemaContext;
import ghidra.dbg.target.schema.DefaultTargetObjectSchema;
import ghidra.dbg.target.schema.EnumerableTargetObjectSchema;
import ghidra.dbg.target.schema.SchemaBuilder;
import ghidra.dbg.target.schema.SchemaContext;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.util.Msg;
import ghidra.util.xml.XmlUtilities;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class XmlSchemaContext
extends DefaultSchemaContext {
    protected static final Set<String> TRUES = Set.of("true", "yes", "y", "1");
    protected final Map<String, TargetObjectSchema.SchemaName> names = new HashMap<String, TargetObjectSchema.SchemaName>();

    protected static boolean parseBoolean(Element ele, String attrName) {
        return TRUES.contains(ele.getAttributeValue(attrName, "no").toLowerCase());
    }

    public static String serialize(SchemaContext ctx) {
        return XmlUtilities.toString((Element)XmlSchemaContext.contextToXml(ctx));
    }

    public static Element contextToXml(SchemaContext ctx) {
        Element result = new Element("context");
        for (TargetObjectSchema schema : ctx.getAllSchemas()) {
            Element schemaElem = XmlSchemaContext.schemaToXml(schema);
            if (schemaElem == null) continue;
            result.addContent((Content)schemaElem);
        }
        return result;
    }

    public static Element attributeSchemaToXml(TargetObjectSchema.AttributeSchema as) {
        Element attrElem = new Element("attribute");
        if (!as.getName().equals("")) {
            XmlUtilities.setStringAttr((Element)attrElem, (String)"name", (String)as.getName());
        }
        XmlUtilities.setStringAttr((Element)attrElem, (String)"schema", (String)as.getSchema().toString());
        if (as.isRequired()) {
            XmlUtilities.setStringAttr((Element)attrElem, (String)"required", (String)"yes");
        }
        if (as.isFixed()) {
            XmlUtilities.setStringAttr((Element)attrElem, (String)"fixed", (String)"yes");
        }
        if (as.isHidden()) {
            XmlUtilities.setStringAttr((Element)attrElem, (String)"hidden", (String)"yes");
        }
        return attrElem;
    }

    public static Element schemaToXml(TargetObjectSchema schema) {
        if (!TargetObject.class.isAssignableFrom(schema.getType())) {
            return null;
        }
        if (schema == EnumerableTargetObjectSchema.OBJECT) {
            return null;
        }
        Element result = new Element("schema");
        XmlUtilities.setStringAttr((Element)result, (String)"name", (String)schema.getName().toString());
        for (Class<? extends TargetObject> clazz : schema.getInterfaces()) {
            Element ifElem = new Element("interface");
            XmlUtilities.setStringAttr((Element)ifElem, (String)"name", (String)DebuggerObjectModel.requireIfaceName(clazz));
            result.addContent((Content)ifElem);
        }
        if (schema.isCanonicalContainer()) {
            XmlUtilities.setStringAttr((Element)result, (String)"canonical", (String)"yes");
        }
        XmlUtilities.setStringAttr((Element)result, (String)"elementResync", (String)schema.getElementResyncMode().name());
        XmlUtilities.setStringAttr((Element)result, (String)"attributeResync", (String)schema.getAttributeResyncMode().name());
        for (Map.Entry entry : schema.getElementSchemas().entrySet()) {
            Element elemElem = new Element("element");
            XmlUtilities.setStringAttr((Element)elemElem, (String)"index", (String)((String)entry.getKey()));
            XmlUtilities.setStringAttr((Element)elemElem, (String)"schema", (String)((TargetObjectSchema.SchemaName)entry.getValue()).toString());
            result.addContent((Content)elemElem);
        }
        Element deElem = new Element("element");
        XmlUtilities.setStringAttr((Element)deElem, (String)"schema", (String)schema.getDefaultElementSchema().toString());
        result.addContent((Content)deElem);
        for (TargetObjectSchema.AttributeSchema as : schema.getAttributeSchemas().values()) {
            Element attrElem = XmlSchemaContext.attributeSchemaToXml(as);
            result.addContent((Content)attrElem);
        }
        TargetObjectSchema.AttributeSchema attributeSchema = schema.getDefaultAttributeSchema();
        Element daElem = XmlSchemaContext.attributeSchemaToXml(attributeSchema);
        result.addContent((Content)daElem);
        return result;
    }

    public static XmlSchemaContext deserialize(String xml) throws JDOMException {
        return XmlSchemaContext.deserialize(xml.getBytes());
    }

    public static XmlSchemaContext deserialize(byte[] xml) throws JDOMException {
        try {
            return XmlSchemaContext.deserialize(new ByteArrayInputStream(xml));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static XmlSchemaContext deserialize(File file) throws JDOMException, IOException {
        return XmlSchemaContext.deserialize(new FileInputStream(file));
    }

    public static XmlSchemaContext deserialize(InputStream is) throws JDOMException, IOException {
        SAXBuilder sb = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
        Document doc = sb.build(Objects.requireNonNull(is));
        return XmlSchemaContext.contextFromXml(doc.getRootElement());
    }

    public static XmlSchemaContext contextFromXml(Element contextElem) {
        XmlSchemaContext ctx = new XmlSchemaContext();
        for (Element schemaElem : XmlUtilities.getChildren((Element)contextElem, (String)"schema")) {
            ctx.schemaFromXml(schemaElem);
        }
        return ctx;
    }

    public synchronized TargetObjectSchema.SchemaName name(String name) {
        return this.names.computeIfAbsent(name, TargetObjectSchema.SchemaName::new);
    }

    private String requireAttributeValue(Element elem, String name) {
        String value = elem.getAttributeValue(name);
        if (value == null) {
            throw new IllegalArgumentException("Missing attribute " + name + " in " + elem);
        }
        return value;
    }

    public TargetObjectSchema schemaFromXml(Element schemaElem) {
        TargetObjectSchema.SchemaName schema;
        SchemaBuilder builder = this.builder(this.name(schemaElem.getAttributeValue("name", "")));
        for (Element ifaceElem : XmlUtilities.getChildren((Element)schemaElem, (String)"interface")) {
            String ifaceName = this.requireAttributeValue(ifaceElem, "name");
            Class<? extends TargetObject> iface = TargetObject.INTERFACES_BY_NAME.get(ifaceName);
            if (iface == null) {
                Msg.warn((Object)this, (Object)("Unknown interface name: '" + ifaceName + "'"));
                continue;
            }
            builder.addInterface(iface);
        }
        builder.setCanonicalContainer(XmlSchemaContext.parseBoolean(schemaElem, "canonical"));
        builder.setElementResyncMode(TargetObjectSchema.ResyncMode.valueOf(this.requireAttributeValue(schemaElem, "elementResync")));
        builder.setAttributeResyncMode(TargetObjectSchema.ResyncMode.valueOf(this.requireAttributeValue(schemaElem, "attributeResync")));
        for (Element elemElem : XmlUtilities.getChildren((Element)schemaElem, (String)"element")) {
            schema = this.name(this.requireAttributeValue(elemElem, "schema"));
            String index = elemElem.getAttributeValue("index", "");
            builder.addElementSchema(index, schema, elemElem);
        }
        for (Element attrElem : XmlUtilities.getChildren((Element)schemaElem, (String)"attribute")) {
            schema = this.name(this.requireAttributeValue(attrElem, "schema"));
            boolean required = XmlSchemaContext.parseBoolean(attrElem, "required");
            boolean fixed = XmlSchemaContext.parseBoolean(attrElem, "fixed");
            boolean hidden = XmlSchemaContext.parseBoolean(attrElem, "hidden");
            String name = attrElem.getAttributeValue("name", "");
            builder.addAttributeSchema(new DefaultTargetObjectSchema.DefaultAttributeSchema(name, schema, required, fixed, hidden), attrElem);
        }
        return builder.buildAndAdd();
    }
}

