/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pty.ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ConfigRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.OpenSSHConfig;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.PasswordDialog;
import ghidra.pty.PtyFactory;
import ghidra.pty.ssh.SshPty;
import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import javax.swing.JOptionPane;
import org.apache.commons.text.StringEscapeUtils;

public class GhidraSshPtyFactory
implements PtyFactory {
    private static final String TITLE = "GDB via SSH";
    private static final int WRAP_LEN = 80;
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final int DEFAULT_PORT = 22;
    public static final String DEFAULT_USERNAME = "user";
    public static final String DEFAULT_CONFIG_FILE = "~/.ssh/config";
    private String hostname = "localhost";
    private int port = 22;
    private String username = "user";
    private String configFile = "~/.ssh/config";
    private Session session;

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = Objects.requireNonNull(hostname);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = Objects.requireNonNull(username);
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    protected Session connectAndAuthenticate() throws IOException {
        JSch jsch = new JSch();
        OpenSSHConfig configRepo = null;
        try {
            configRepo = OpenSSHConfig.parseFile((String)this.configFile);
        }
        catch (IOException e) {
            Msg.warn((Object)this, (Object)("ssh config file " + this.configFile + " could not be parsed."));
        }
        jsch.setConfigRepository((ConfigRepository)new RequireTTYAlwaysConfigRepo((ConfigRepository)configRepo));
        try {
            Session session = jsch.getSession(this.username.length() == 0 ? null : this.username, this.hostname, this.port);
            session.setUserInfo((UserInfo)new GhidraUserInfo());
            session.connect();
            return session;
        }
        catch (JSchException e) {
            String message = e.getMessage();
            if (message.equals("Auth cancel")) {
                Msg.error((Object)this, (Object)"SSH connection canceled");
                throw new CancellationException("SSH connection canceled");
            }
            if (message.startsWith("reject HostKey")) {
                String cancelMessage = "SSH " + message;
                Msg.error((Object)this, (Object)cancelMessage);
                throw new CancellationException(cancelMessage);
            }
            Msg.error((Object)this, (Object)"SSH connection error");
            throw new IOException("SSH connection error", e);
        }
    }

    @Override
    public SshPty openpty(short cols, short rows) throws IOException {
        if (this.session == null) {
            this.session = this.connectAndAuthenticate();
        }
        try {
            SshPty pty = new SshPty((ChannelExec)this.session.openChannel("exec"));
            if (cols != 0 && rows != 0) {
                pty.getParent().setWindowSize(cols, rows);
            }
            return pty;
        }
        catch (JSchException e) {
            throw new IOException("SSH connection error", e);
        }
    }

    @Override
    public String getDescription() {
        return "ssh:" + this.hostname + "(user=" + this.username + ",port=" + this.port + ")";
    }

    private class RequireTTYAlwaysConfigRepo
    implements ConfigRepository {
        private final ConfigRepository delegate;

        public RequireTTYAlwaysConfigRepo(ConfigRepository delegate) {
            this.delegate = delegate;
        }

        public ConfigRepository.Config getConfig(String host) {
            if (this.delegate == null) {
                return new RequireTTYAlwaysConfig(ConfigRepository.defaultConfig);
            }
            return new RequireTTYAlwaysConfig(this.delegate.getConfig(host));
        }
    }

    private class GhidraUserInfo
    implements UserInfo {
        private String password;
        private String passphrase;

        private GhidraUserInfo() {
        }

        public String doPromptSecret(String prompt) {
            PasswordDialog dialog = new PasswordDialog(GhidraSshPtyFactory.TITLE, "SSH", GhidraSshPtyFactory.this.hostname, prompt, null, null);
            DockingWindowManager.showDialog((DialogComponentProvider)dialog);
            if (dialog.okWasPressed()) {
                return new String(dialog.getPassword());
            }
            return null;
        }

        public String html(String message) {
            String wrapped = StringUtilities.wrapToWidth((String)message, (int)80);
            return "<html><pre>" + StringEscapeUtils.escapeHtml4((String)wrapped).replace("\n", "<br>");
        }

        public String getPassphrase() {
            return this.passphrase;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean promptPassword(String message) {
            this.password = this.doPromptSecret(message);
            return this.password != null;
        }

        public boolean promptPassphrase(String message) {
            this.passphrase = this.doPromptSecret(message);
            return this.passphrase != null;
        }

        public boolean promptYesNo(String message) {
            return JOptionPane.showConfirmDialog(null, this.html(message), GhidraSshPtyFactory.TITLE, 0, 3) == 0;
        }

        public void showMessage(String message) {
            JOptionPane.showMessageDialog(null, this.html(message), GhidraSshPtyFactory.TITLE, 1);
        }
    }

    private class RequireTTYAlwaysConfig
    implements ConfigRepository.Config {
        private final ConfigRepository.Config delegate;

        public RequireTTYAlwaysConfig(ConfigRepository.Config delegate) {
            this.delegate = delegate;
        }

        public String getHostname() {
            return this.delegate.getHostname();
        }

        public String getUser() {
            return this.delegate.getUser();
        }

        public int getPort() {
            return this.delegate.getPort();
        }

        public String getValue(String key) {
            if ("RequestTTY".equals(key)) {
                return "yes";
            }
            return this.delegate.getValue(key);
        }

        public String[] getValues(String key) {
            if ("RequestTTY".equals(key)) {
                return new String[]{"yes"};
            }
            return this.delegate.getValues(key);
        }
    }
}

