/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.tracermi.launcher;

import db.Transaction;
import docking.widgets.OptionDialog;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.objects.components.DebuggerMethodInvocationDialog;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.TraceRmiLauncherServicePlugin;
import ghidra.app.plugin.core.debug.service.tracermi.DefaultTraceRmiAcceptor;
import ghidra.app.plugin.core.debug.service.tracermi.TraceRmiHandler;
import ghidra.app.plugin.core.terminal.TerminalListener;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.InternalTraceRmiService;
import ghidra.app.services.Terminal;
import ghidra.app.services.TerminalService;
import ghidra.async.AsyncUtils;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.util.ShellUtils;
import ghidra.debug.api.modules.DebuggerStaticMappingChangeListener;
import ghidra.debug.api.modules.MapProposal;
import ghidra.debug.api.modules.ModuleMapProposal;
import ghidra.debug.api.tracermi.TerminalSession;
import ghidra.debug.api.tracermi.TraceRmiConnection;
import ghidra.debug.api.tracermi.TraceRmiLaunchOffer;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramUserData;
import ghidra.program.util.ProgramLocation;
import ghidra.pty.Pty;
import ghidra.pty.PtyChild;
import ghidra.pty.PtyFactory;
import ghidra.pty.PtyParent;
import ghidra.pty.PtySession;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceLocation;
import ghidra.util.HTMLUtilities;
import ghidra.util.MessageType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlUtilities;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Icon;
import org.jdom.Element;
import org.jdom.JDOMException;

public abstract class AbstractTraceRmiLaunchOffer
implements TraceRmiLaunchOffer {
    public static final String PREFIX_DBGLAUNCH = "DBGLAUNCH_";
    public static final String PARAM_DISPLAY_IMAGE = "Image";
    protected final TraceRmiLauncherServicePlugin plugin;
    protected final Program program;
    protected final PluginTool tool;
    protected final TerminalService terminalService;

    public AbstractTraceRmiLaunchOffer(TraceRmiLauncherServicePlugin plugin, Program program) {
        this.plugin = Objects.requireNonNull(plugin);
        this.program = Objects.requireNonNull(program);
        this.tool = plugin.getTool();
        this.terminalService = Objects.requireNonNull((TerminalService)this.tool.getService(TerminalService.class));
    }

    protected int getTimeoutMillis() {
        return 10000;
    }

    public Icon getIcon() {
        return DebuggerResources.ICON_DEBUGGER;
    }

    protected Address getMappingProbeAddress() {
        AddressIterator eepi = this.program.getSymbolTable().getExternalEntryPointIterator();
        if (eepi.hasNext()) {
            return eepi.next();
        }
        InstructionIterator ii = this.program.getListing().getInstructions(true);
        if (ii.hasNext()) {
            return ii.next().getAddress();
        }
        AddressSetView es = this.program.getMemory().getExecuteSet();
        if (!es.isEmpty()) {
            return es.getMinAddress();
        }
        if (!this.program.getMemory().isEmpty()) {
            return this.program.getMinAddress();
        }
        return null;
    }

    protected CompletableFuture<Void> listenForMapping(final DebuggerStaticMappingService mappingService, final TraceRmiConnection connection, final Trace trace) {
        Address probeAddress = this.getMappingProbeAddress();
        if (probeAddress == null) {
            return AsyncUtils.nil();
        }
        final ProgramLocation probe = new ProgramLocation(this.program, probeAddress);
        var result = new CompletableFuture<Void>(){
            DebuggerStaticMappingChangeListener listener = (affectedTraces, affectedPrograms) -> {
                if (!affectedPrograms.contains(AbstractTraceRmiLaunchOffer.this.program) && !affectedTraces.contains(trace)) {
                    return;
                }
                this.check();
            };

            protected void check() {
                long snap = connection.getLastSnapshot(trace);
                TraceLocation result = mappingService.getOpenMappedLocation(trace, probe, snap);
                if (result == null) {
                    return;
                }
                this.complete(null);
                mappingService.removeChangeListener(this.listener);
            }
        };
        mappingService.addChangeListener(result.listener);
        result.check();
        result.exceptionally(ex -> {
            mappingService.removeChangeListener(result.listener);
            return null;
        });
        return result;
    }

    protected Collection<ModuleMapProposal.ModuleMapEntry> invokeMapper(TaskMonitor monitor, DebuggerStaticMappingService mappingService, Trace trace) throws CancelledException {
        Map map = mappingService.proposeModuleMaps(trace.getModuleManager().getAllModules(), List.of(this.program));
        Collection proposal = MapProposal.flatten(map.values());
        mappingService.addModuleMappings(proposal, monitor, true);
        return proposal;
    }

    private void saveLauncherArgs(Map<String, ?> args, Map<String, TargetMethod.ParameterDescription<?>> params) {
        SaveState state = new SaveState();
        for (TargetMethod.ParameterDescription<?> param : params.values()) {
            Object val = args.get(param.name);
            if (val == null) continue;
            AutoConfigState.ConfigStateField.putState((SaveState)state, param.type.asSubclass(Object.class), (String)("param_" + param.name), val);
            state.putLong("last", System.currentTimeMillis());
        }
        if (this.program != null) {
            ProgramUserData userData = this.program.getProgramUserData();
            try (Transaction tx = userData.openTransaction();){
                Element element = state.saveToXml();
                userData.setStringProperty(PREFIX_DBGLAUNCH + this.getConfigName(), XmlUtilities.toString((Element)element));
            }
        }
    }

    protected Map<String, ?> generateDefaultLauncherArgs(Map<String, TargetMethod.ParameterDescription<?>> params) {
        File imageFile;
        if (this.program == null) {
            return Map.of();
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        TargetMethod.ParameterDescription<?> paramImage = null;
        for (Map.Entry<String, TargetMethod.ParameterDescription<?>> entry : params.entrySet()) {
            TargetMethod.ParameterDescription<?> param = entry.getValue();
            map.put(entry.getKey(), param.defaultValue);
            if (!PARAM_DISPLAY_IMAGE.equals(param.display)) continue;
            if (param.type != String.class) {
                Msg.warn((Object)this, (Object)("'Image' parameter has unexpected type: " + paramImage.type));
            }
            paramImage = param;
        }
        if (paramImage != null && (imageFile = TraceRmiLauncherServicePlugin.getProgramPath(this.program)) != null) {
            paramImage.set(map, (Object)imageFile.getAbsolutePath());
        }
        return map;
    }

    protected Map<String, ?> promptLauncherArgs(TraceRmiLaunchOffer.LaunchConfigurator configurator, Throwable lastExc) {
        Map<String, ?> args;
        Map params = this.getParameters();
        DebuggerMethodInvocationDialog dialog = new DebuggerMethodInvocationDialog(this.tool, this.getTitle(), "Launch", this.getIcon());
        dialog.setDescription(this.getDescription());
        boolean reset = false;
        do {
            args = configurator.configureLauncher((TraceRmiLaunchOffer)this, this.loadLastLauncherArgs(true), TraceRmiLaunchOffer.RelPrompt.BEFORE);
            for (TargetMethod.ParameterDescription param : params.values()) {
                Object val = args.get(param.name);
                if (val == null) continue;
                dialog.setMemorizedArgument(param.name, param.type.asSubclass(Object.class), val);
            }
            if (lastExc != null) {
                dialog.setStatusText(lastExc.toString(), MessageType.ERROR);
            } else {
                dialog.setStatusText("");
            }
            args = dialog.promptArguments(params);
            if (args == null) {
                return null;
            }
            reset = dialog.isResetRequested();
            if (reset) {
                args = this.generateDefaultLauncherArgs(params);
            }
            this.saveLauncherArgs(args, params);
        } while (reset);
        return args;
    }

    protected Map<String, ?> loadLastLauncherArgs(boolean forPrompt) {
        if (this.program != null) {
            Map params = this.getParameters();
            ProgramUserData userData = this.program.getProgramUserData();
            String property = userData.getStringProperty(PREFIX_DBGLAUNCH + this.getConfigName(), null);
            if (property != null) {
                try {
                    Element element = XmlUtilities.fromString((String)property);
                    SaveState state = new SaveState(element);
                    List<String> names = List.of(state.getNames());
                    LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
                    for (TargetMethod.ParameterDescription param : params.values()) {
                        Object configState;
                        String key = "param_" + param.name;
                        if (!names.contains(key) || (configState = AutoConfigState.ConfigStateField.getState((SaveState)state, (Class)param.type, (String)key)) == null) continue;
                        args.put(param.name, configState);
                    }
                    if (!args.isEmpty()) {
                        return args;
                    }
                }
                catch (IOException | JDOMException e) {
                    if (!forPrompt) {
                        throw new RuntimeException("Saved launcher args are corrupt, or launcher parameters changed. Not launching.", e);
                    }
                    Msg.error((Object)this, (Object)"Saved launcher args are corrupt, or launcher parameters changed. Defaulting.", (Throwable)e);
                }
            }
            Map<String, ?> args = this.generateDefaultLauncherArgs(params);
            this.saveLauncherArgs(args, params);
            return args;
        }
        return new LinkedHashMap();
    }

    public Map<String, ?> getLauncherArgs(boolean prompt, TraceRmiLaunchOffer.LaunchConfigurator configurator, Throwable lastExc) {
        return prompt ? configurator.configureLauncher((TraceRmiLaunchOffer)this, this.promptLauncherArgs(configurator, lastExc), TraceRmiLaunchOffer.RelPrompt.AFTER) : configurator.configureLauncher((TraceRmiLaunchOffer)this, this.loadLastLauncherArgs(false), TraceRmiLaunchOffer.RelPrompt.NONE);
    }

    public Map<String, ?> getLauncherArgs(boolean prompt) {
        return this.getLauncherArgs(prompt, TraceRmiLaunchOffer.LaunchConfigurator.NOP, null);
    }

    protected PtyFactory getPtyFactory() {
        return PtyFactory.local();
    }

    protected PtyTerminalSession runInTerminal(List<String> commandLine, Map<String, String> env, File workingDirectory, Collection<TerminalSession> subordinates) throws IOException {
        PtyFactory factory = this.getPtyFactory();
        Pty pty = factory.openpty();
        final PtyParent parent = pty.getParent();
        Terminal terminal = this.terminalService.createWithStreams(Charset.forName("UTF-8"), parent.getInputStream(), parent.getOutputStream());
        terminal.setSubTitle(ShellUtils.generateLine(commandLine));
        TerminalListener resizeListener = new TerminalListener(){

            public void resized(short cols, short rows) {
                try {
                    parent.setWindowSize(cols, rows);
                }
                catch (Exception e) {
                    Msg.error((Object)this, (Object)("Could not resize pty: " + e));
                }
            }
        };
        terminal.addTerminalListener(resizeListener);
        env.put("TERM", "xterm-256color");
        PtySession session = pty.getChild().session((String[])commandLine.toArray(String[]::new), env, workingDirectory, new PtyChild.TermMode[0]);
        Thread waiter = new Thread(() -> {
            try {
                session.waitExited();
                terminal.terminated();
                pty.close();
                for (TerminalSession ss : subordinates) {
                    ss.terminate();
                }
            }
            catch (IOException | InterruptedException e) {
                Msg.error((Object)this, (Object)e);
            }
        }, "Waiter: " + this.getConfigName());
        waiter.start();
        PtyTerminalSession terminalSession = new PtyTerminalSession(terminal, pty, session, waiter);
        terminal.setTerminateAction(() -> this.tool.execute((Task)new TerminateSessionTask(terminalSession)));
        return terminalSession;
    }

    protected NullPtyTerminalSession nullPtyTerminal() throws IOException {
        PtyFactory factory = this.getPtyFactory();
        Pty pty = factory.openpty();
        final PtyParent parent = pty.getParent();
        Terminal terminal = this.terminalService.createWithStreams(Charset.forName("UTF-8"), parent.getInputStream(), parent.getOutputStream());
        TerminalListener resizeListener = new TerminalListener(){

            public void resized(short cols, short rows) {
                parent.setWindowSize(cols, rows);
            }
        };
        terminal.addTerminalListener(resizeListener);
        String name = pty.getChild().nullSession(new PtyChild.TermMode[0]);
        terminal.setSubTitle(name);
        NullPtyTerminalSession terminalSession = new NullPtyTerminalSession(terminal, pty, name);
        terminal.setTerminateAction(() -> this.tool.execute((Task)new TerminateSessionTask(terminalSession)));
        return terminalSession;
    }

    protected abstract void launchBackEnd(TaskMonitor var1, Map<String, TerminalSession> var2, Map<String, ?> var3, SocketAddress var4) throws Exception;

    public TraceRmiLaunchOffer.LaunchResult launchProgram(TaskMonitor monitor, TraceRmiLaunchOffer.LaunchConfigurator configurator) {
        InternalTraceRmiService service = (InternalTraceRmiService)this.tool.getService(InternalTraceRmiService.class);
        DebuggerStaticMappingService mappingService = (DebuggerStaticMappingService)this.tool.getService(DebuggerStaticMappingService.class);
        DebuggerTraceManagerService traceManager = (DebuggerTraceManagerService)this.tool.getService(DebuggerTraceManagerService.class);
        TraceRmiLaunchOffer.PromptMode mode = configurator.getPromptMode();
        boolean prompt = mode == TraceRmiLaunchOffer.PromptMode.ALWAYS;
        DefaultTraceRmiAcceptor acceptor = null;
        LinkedHashMap<String, TerminalSession> sessions = new LinkedHashMap<String, TerminalSession>();
        TraceRmiHandler connection = null;
        Trace trace = null;
        Throwable lastExc = null;
        monitor.setMaximum(5L);
        block15: while (true) {
            monitor.setMessage("Gathering arguments");
            Map<String, ?> args = this.getLauncherArgs(prompt, configurator, lastExc);
            if (args == null) {
                if (lastExc == null) {
                    lastExc = new CancelledException();
                }
                return new TraceRmiLaunchOffer.LaunchResult(this.program, sessions, connection, trace, lastExc);
            }
            acceptor = null;
            sessions.clear();
            connection = null;
            trace = null;
            lastExc = null;
            try {
                monitor.setMessage("Listening for connection");
                acceptor = service.acceptOne(new InetSocketAddress("127.0.0.1", 0));
                monitor.setMessage("Launching back-end");
                this.launchBackEnd(monitor, sessions, args, acceptor.getAddress());
                monitor.setMessage("Waiting for connection");
                acceptor.setTimeout(this.getTimeoutMillis());
                connection = acceptor.accept();
                connection.registerTerminals(sessions.values());
                monitor.setMessage("Waiting for trace");
                trace = connection.waitForTrace(this.getTimeoutMillis());
                traceManager.openTrace(trace);
                traceManager.activate(traceManager.resolveTrace(trace), DebuggerTraceManagerService.ActivationCause.START_RECORDING);
                monitor.setMessage("Waiting for module mapping");
                try {
                    this.listenForMapping(mappingService, connection, trace).get(this.getTimeoutMillis(), TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    Collection<ModuleMapProposal.ModuleMapEntry> mapped;
                    monitor.setMessage("Timed out waiting for module mapping. Invoking the mapper.");
                    try {
                        mapped = this.invokeMapper(monitor, mappingService, trace);
                    }
                    catch (CancelledException ce) {
                        throw new CancellationException(e.getMessage());
                    }
                    if (mapped.isEmpty()) {
                        throw new NoStaticMappingException("The resulting target process has no mapping to the static image.");
                    }
                }
            }
            catch (Exception e) {
                lastExc = e;
                prompt = mode != TraceRmiLaunchOffer.PromptMode.NEVER;
                TraceRmiLaunchOffer.LaunchResult result = new TraceRmiLaunchOffer.LaunchResult(this.program, sessions, connection, trace, lastExc);
                if (prompt) {
                    switch (this.promptError(result)) {
                        case KEEP: {
                            return result;
                        }
                        case RETRY: {
                            try {
                                result.close();
                            }
                            catch (Exception e1) {
                                Msg.error((Object)this, (Object)"Could not close", (Throwable)e1);
                            }
                            continue block15;
                        }
                        case TERMINATE: {
                            try {
                                result.close();
                            }
                            catch (Exception e1) {
                                Msg.error((Object)this, (Object)"Could not close", (Throwable)e1);
                            }
                            return new TraceRmiLaunchOffer.LaunchResult(this.program, Map.of(), null, null, lastExc);
                        }
                    }
                    continue;
                }
                return result;
            }
            break;
        }
        return new TraceRmiLaunchOffer.LaunchResult(this.program, sessions, (TraceRmiConnection)connection, trace, null);
    }

    protected ErrPromptResponse promptError(TraceRmiLaunchOffer.LaunchResult result) {
        String message = "<html><body width=\"400px\">\n<h3>Failed to launch %s due to an exception:</h3>\n\n<tt>%s</tt>\n\n<h3>Troubleshooting</h3>\n<p>\n<b>Check the Terminal!</b>\nIf no terminal is visible, check the menus: <b>Window &rarr; Terminals &rarr;\n...</b>.\nA path or other configuration parameter may be incorrect.\nThe back-end debugger may have paused for user input.\nThere may be a missing dependency.\nThere may be an incorrect version, etc.</p>\n\n<h3>These resources remain after the failed launch:</h3>\n<ul>\n%s\n</ul>\n\n<h3>Do you want to keep these resources?</h3>\n<ul>\n<li>Choose <b>Yes</b> to stop here and diagnose or complete the launch manually.\n</li>\n<li>Choose <b>No</b> to clean up and retry at the launch dialog.</li>\n<li>Choose <b>Cancel</b> to clean up without retrying.</li>\n".formatted(this.htmlProgramName(result), this.htmlExceptionMessage(result), this.htmlResources(result));
        return LaunchFailureDialog.show(message);
    }

    protected String htmlProgramName(TraceRmiLaunchOffer.LaunchResult result) {
        if (result.program() == null) {
            return "";
        }
        return "<tt>" + HTMLUtilities.escapeHTML((String)result.program().getName()) + "</tt>";
    }

    protected String htmlExceptionMessage(TraceRmiLaunchOffer.LaunchResult result) {
        if (result.exception() == null) {
            return "(No exception)";
        }
        return HTMLUtilities.escapeHTML((String)result.exception().toString());
    }

    protected String htmlResources(TraceRmiLaunchOffer.LaunchResult result) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry ent : result.sessions().entrySet()) {
            TerminalSession session = (TerminalSession)ent.getValue();
            sb.append("<li>Terminal: " + HTMLUtilities.escapeHTML((String)((String)ent.getKey())) + " &rarr; <tt>" + HTMLUtilities.escapeHTML((String)session.description()) + "</tt>");
            if (session.isTerminated()) {
                sb.append(" (Terminated)");
            }
            sb.append("</li>\n");
        }
        if (result.connection() != null) {
            sb.append("<li>Connection: <tt>" + HTMLUtilities.escapeHTML((String)result.connection().getRemoteAddress().toString()) + "</tt></li>\n");
        }
        if (result.trace() != null) {
            sb.append("<li>Trace: " + HTMLUtilities.escapeHTML((String)result.trace().getName()) + "</li>\n");
        }
        return sb.toString();
    }

    protected record PtyTerminalSession(Terminal terminal, Pty pty, PtySession session, Thread waiter) implements TerminalSession
    {
        public void close() throws IOException {
            this.terminate();
            this.terminal.close();
        }

        public void terminate() throws IOException {
            this.terminal.terminated();
            this.session.destroyForcibly();
            this.pty.close();
            this.waiter.interrupt();
        }

        public boolean isTerminated() {
            return this.terminal.isTerminated();
        }

        public String description() {
            return this.session.description();
        }
    }

    protected record NullPtyTerminalSession(Terminal terminal, Pty pty, String name) implements TerminalSession
    {
        public void close() throws IOException {
            this.terminate();
            this.terminal.close();
        }

        public void terminate() throws IOException {
            this.terminal.terminated();
            this.pty.close();
        }

        public boolean isTerminated() {
            return this.terminal.isTerminated();
        }

        public String description() {
            return this.name;
        }
    }

    static class NoStaticMappingException
    extends Exception {
        public NoStaticMappingException(String message) {
            super(message);
        }

        @Override
        public String toString() {
            return this.getMessage();
        }
    }

    static enum ErrPromptResponse {
        KEEP,
        RETRY,
        TERMINATE;

    }

    static class LaunchFailureDialog
    extends OptionDialog {
        public LaunchFailureDialog(String message) {
            super("Launch Failed", message, "&Yes", "&No", 0, null, true, "No");
        }

        static ErrPromptResponse show(String message) {
            return switch (new LaunchFailureDialog(message).show()) {
                case 1 -> ErrPromptResponse.KEEP;
                case 2 -> ErrPromptResponse.RETRY;
                case 0 -> ErrPromptResponse.TERMINATE;
                default -> throw new AssertionError();
            };
        }
    }

    static class TerminateSessionTask
    extends Task {
        private final TerminalSession session;

        public TerminateSessionTask(TerminalSession session) {
            super("Terminate Session", false, false, false);
            this.session = session;
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            try {
                this.session.close();
            }
            catch (IOException e) {
                Msg.error((Object)((Object)this), (Object)("Could not terminate: " + e), (Throwable)e);
            }
        }
    }
}

