/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.tracermi;

import docking.DialogComponentProvider;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.utils.MiscellaneousUtils;
import ghidra.dbg.target.schema.SchemaContext;
import ghidra.debug.api.tracermi.RemoteParameter;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.Msg;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualLinkedHashBidiMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jdom.Element;

public class RemoteMethodInvocationDialog
extends DialogComponentProvider
implements PropertyChangeListener {
    private static final String KEY_MEMORIZED_ARGUMENTS = "memorizedArguments";
    private final BidiMap<RemoteParameter, PropertyEditor> paramEditors = new DualLinkedHashBidiMap();
    private JPanel panel;
    private JLabel descriptionLabel;
    private JPanel pairPanel;
    private PairLayout layout;
    protected JButton invokeButton;
    protected JButton resetButton;
    private final PluginTool tool;
    private SchemaContext ctx;
    private Map<String, RemoteParameter> parameters;
    private Map<String, Object> defaults;
    private Map<NameTypePair, Object> memorized = new HashMap<NameTypePair, Object>();
    private Map<String, Object> arguments;

    public RemoteMethodInvocationDialog(PluginTool tool, String title, String buttonText, Icon buttonIcon) {
        super(title, true, true, true, false);
        this.tool = tool;
        this.populateComponents(buttonText, buttonIcon);
        this.setRememberSize(false);
    }

    protected Object computeMemorizedValue(RemoteParameter parameter) {
        return this.memorized.computeIfAbsent(NameTypePair.fromParameter(this.ctx, parameter), ntp -> parameter.getDefaultValue());
    }

    public Map<String, Object> promptArguments(SchemaContext ctx, Map<String, RemoteParameter> parameterMap, Map<String, Object> defaults) {
        this.setParameters(ctx, parameterMap);
        this.setDefaults(defaults);
        this.tool.showDialog((DialogComponentProvider)this);
        return this.getArguments();
    }

    public void setParameters(SchemaContext ctx, Map<String, RemoteParameter> parameterMap) {
        this.ctx = ctx;
        this.parameters = parameterMap;
        this.populateOptions();
    }

    public void setDefaults(Map<String, Object> defaults) {
        this.defaults = defaults;
    }

    private void populateComponents(String buttonText, Icon buttonIcon) {
        this.panel = new JPanel(new BorderLayout());
        this.panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.layout = new PairLayout(5, 5);
        this.pairPanel = new JPanel((LayoutManager)this.layout);
        JPanel centering = new JPanel(new FlowLayout(1));
        JScrollPane scrolling = new JScrollPane(centering, 20, 31);
        this.panel.add((Component)scrolling, "Center");
        centering.add(this.pairPanel);
        this.descriptionLabel = new JLabel();
        this.descriptionLabel.setMaximumSize(new Dimension(300, 100));
        this.panel.add((Component)this.descriptionLabel, "North");
        this.addWorkPanel(this.panel);
        this.invokeButton = new JButton(buttonText, buttonIcon);
        this.addButton(this.invokeButton);
        this.resetButton = new JButton("Reset", DebuggerResources.ICON_REFRESH);
        this.addButton(this.resetButton);
        this.addCancelButton();
        this.invokeButton.addActionListener(this::invoke);
        this.resetButton.addActionListener(this::reset);
    }

    protected void cancelCallback() {
        this.arguments = null;
        this.close();
    }

    protected void invoke(ActionEvent evt) {
        this.arguments = this.collectArguments();
        this.close();
    }

    private void reset(ActionEvent evt) {
        this.arguments = new HashMap<String, Object>();
        for (RemoteParameter param : this.parameters.values()) {
            if (this.defaults.containsKey(param.name())) {
                this.arguments.put(param.name(), this.defaults.get(param.name()));
                continue;
            }
            this.arguments.put(param.name(), param.getDefaultValue());
        }
        this.populateValues();
    }

    protected PropertyEditor createEditor(RemoteParameter param) {
        Class type = this.ctx.getSchema(param.type()).getType();
        PropertyEditor editor = PropertyEditorManager.findEditor(type);
        if (editor != null) {
            return editor;
        }
        Msg.warn((Object)this, (Object)("No editor for " + type + "? Trying String instead"));
        return PropertyEditorManager.findEditor(String.class);
    }

    void populateOptions() {
        this.pairPanel.removeAll();
        this.paramEditors.clear();
        for (RemoteParameter param : this.parameters.values()) {
            JLabel label = new JLabel(param.display());
            label.setToolTipText(param.description());
            this.pairPanel.add(label);
            PropertyEditor editor = this.createEditor(param);
            Object val = this.computeMemorizedValue(param);
            editor.setValue(val);
            editor.addPropertyChangeListener(this);
            this.pairPanel.add(MiscellaneousUtils.getEditorComponent((PropertyEditor)editor));
            this.paramEditors.put((Object)param, (Object)editor);
        }
    }

    void populateValues() {
        for (Map.Entry<String, Object> ent : this.arguments.entrySet()) {
            RemoteParameter param = this.parameters.get(ent.getKey());
            if (param == null) {
                Msg.warn((Object)this, (Object)("No parameter for argument: " + ent));
                continue;
            }
            PropertyEditor editor = (PropertyEditor)this.paramEditors.get((Object)param);
            editor.setValue(ent.getValue());
        }
    }

    protected Map<String, Object> collectArguments() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (RemoteParameter param : this.paramEditors.keySet()) {
            Object val = this.memorized.get(NameTypePair.fromParameter(this.ctx, param));
            if (val == null) continue;
            map.put(param.name(), val);
        }
        return map;
    }

    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    public <T> void setMemorizedArgument(String name, Class<T> type, T value) {
        if (value == null) {
            return;
        }
        this.memorized.put(new NameTypePair(name, type), value);
    }

    public <T> T getMemorizedArgument(String name, Class<T> type) {
        return type.cast(this.memorized.get(new NameTypePair(name, type)));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        PropertyEditor editor = (PropertyEditor)evt.getSource();
        RemoteParameter param = (RemoteParameter)this.paramEditors.getKey((Object)editor);
        this.memorized.put(NameTypePair.fromParameter(this.ctx, param), editor.getValue());
    }

    public void writeConfigState(SaveState saveState) {
        SaveState subState = new SaveState();
        for (Map.Entry<NameTypePair, Object> ent : this.memorized.entrySet()) {
            NameTypePair ntp = ent.getKey();
            AutoConfigState.ConfigStateField.putState((SaveState)subState, ntp.type().asSubclass(Object.class), (String)ntp.name(), (Object)ent.getValue());
        }
        saveState.putXmlElement(KEY_MEMORIZED_ARGUMENTS, subState.saveToXml());
    }

    public void readConfigState(SaveState saveState) {
        Element element = saveState.getXmlElement(KEY_MEMORIZED_ARGUMENTS);
        if (element == null) {
            return;
        }
        SaveState subState = new SaveState(element);
        for (String name : subState.getNames()) {
            try {
                NameTypePair ntp = NameTypePair.fromString(name);
                this.memorized.put(ntp, AutoConfigState.ConfigStateField.getState((SaveState)subState, ntp.type(), (String)ntp.name()));
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)("Error restoring memorized parameter " + name), (Throwable)e);
            }
        }
    }

    public void setDescription(String htmlDescription) {
        if (htmlDescription == null) {
            this.descriptionLabel.setBorder(BorderFactory.createEmptyBorder());
            this.descriptionLabel.setText("");
        } else {
            this.descriptionLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            this.descriptionLabel.setText(htmlDescription);
        }
    }

    record NameTypePair(String name, Class<?> type) {
        public static NameTypePair fromParameter(SchemaContext ctx, RemoteParameter parameter) {
            return new NameTypePair(parameter.name(), ctx.getSchema(parameter.type()).getType());
        }

        public static NameTypePair fromString(String name) throws ClassNotFoundException {
            String[] parts = name.split(",", 2);
            if (parts.length != 2) {
                return new NameTypePair(parts[0], String.class);
            }
            return new NameTypePair(parts[0], Class.forName(parts[1]));
        }
    }

    static class ChoicesPropertyEditor
    implements PropertyEditor {
        private final List<?> choices;
        private final String[] tags;
        private final List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
        private Object value;

        public ChoicesPropertyEditor(Set<?> choices) {
            this.choices = List.copyOf(choices);
            this.tags = (String[])choices.stream().map(Objects::toString).toArray(String[]::new);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValue(Object value) {
            List<PropertyChangeListener> listeners;
            Object oldValue;
            if (Objects.equals(value, this.value)) {
                return;
            }
            if (!this.choices.contains(value)) {
                throw new IllegalArgumentException("Unsupported value: " + value);
            }
            List<PropertyChangeListener> list = this.listeners;
            synchronized (list) {
                oldValue = this.value;
                this.value = value;
                if (this.listeners.isEmpty()) {
                    return;
                }
                listeners = List.copyOf(this.listeners);
            }
            PropertyChangeEvent evt = new PropertyChangeEvent(this, null, oldValue, value);
            for (PropertyChangeListener l : listeners) {
                l.propertyChange(evt);
            }
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public boolean isPaintable() {
            return false;
        }

        @Override
        public void paintValue(Graphics gfx, Rectangle box) {
        }

        @Override
        public String getJavaInitializationString() {
            if (this.value == null) {
                return "null";
            }
            Object object = this.value;
            if (object instanceof String) {
                String str = (String)object;
                return "\"" + StringEscapeUtils.escapeJava((String)str) + "\"";
            }
            return Objects.toString(this.value);
        }

        @Override
        public String getAsText() {
            return Objects.toString(this.value);
        }

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            int index = ArrayUtils.indexOf((Object[])this.tags, (Object)text);
            if (index < 0) {
                throw new IllegalArgumentException("Unsupported value: " + text);
            }
            this.setValue(this.choices.get(index));
        }

        @Override
        public String[] getTags() {
            return (String[])this.tags.clone();
        }

        @Override
        public Component getCustomEditor() {
            return null;
        }

        @Override
        public boolean supportsCustomEditor() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            List<PropertyChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            List<PropertyChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }
    }
}

