/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.search.memory;

import ghidra.app.plugin.core.searchmem.RegExSearchData;
import ghidra.app.plugin.core.searchmem.SearchData;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.Msg;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.search.memory.CodeUnitSearchInfo;
import ghidra.util.search.memory.MemSearchResult;
import ghidra.util.search.memory.MemoryAddressSetCharSequence;
import ghidra.util.search.memory.MemorySearchAlgorithm;
import ghidra.util.search.memory.SearchInfo;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegExMemSearcherAlgorithm
implements MemorySearchAlgorithm {
    private SearchInfo searchInfo;
    private AddressSetView searchSet;
    private Program program;
    private boolean spanAddressGaps;
    private int alignment;
    private CodeUnitSearchInfo codeUnitSearchInfo;

    public RegExMemSearcherAlgorithm(SearchInfo searchInfo, AddressSetView searchSet, Program program, boolean searchAcrossAddressGaps) {
        SearchData data = searchInfo.getSearchData();
        if (!(data instanceof RegExSearchData)) {
            throw new IllegalArgumentException("The given SearchInfo does not contain a RegExSearchData");
        }
        this.searchInfo = searchInfo;
        this.searchSet = searchSet;
        this.program = program;
        this.spanAddressGaps = searchAcrossAddressGaps;
        this.alignment = searchInfo.getAlignment();
        this.codeUnitSearchInfo = searchInfo.getCodeUnitSearchInfo();
    }

    @Override
    public void search(Accumulator<MemSearchResult> accumulator, TaskMonitor monitor) {
        monitor.initialize(this.searchSet.getNumAddresses());
        if (this.spanAddressGaps) {
            this.searchAddressSet(this.searchSet, accumulator, monitor, 0);
        } else {
            AddressRangeIterator rangeIterator = this.searchSet.getAddressRanges();
            int progress = 0;
            int searchLimit = this.searchInfo.getSearchLimit();
            while (rangeIterator.hasNext()) {
                AddressRange range = (AddressRange)rangeIterator.next();
                this.searchAddressSet((AddressSetView)new AddressSet(range), accumulator, monitor, progress);
                monitor.setProgress((long)(progress += (int)range.getLength()));
                if (accumulator.size() < searchLimit) continue;
                return;
            }
        }
    }

    private void searchAddressSet(AddressSetView addressSet, Accumulator<MemSearchResult> accumulator, TaskMonitor monitor, int progressCount) {
        if (addressSet.getNumAddresses() <= Integer.MAX_VALUE) {
            this.searchSubAddressSet(addressSet, accumulator, monitor, progressCount);
            return;
        }
        List<AddressSet> sets = this.breakSetsByMemoryBlock(addressSet);
        int searchLimit = this.searchInfo.getSearchLimit();
        for (AddressSet set : sets) {
            this.searchSubAddressSet((AddressSetView)set, accumulator, monitor, progressCount);
            if (accumulator.size() < searchLimit) continue;
            return;
        }
    }

    private List<AddressSet> breakSetsByMemoryBlock(AddressSetView addressSet) {
        MemoryBlock[] blocks;
        Memory mem = this.program.getMemory();
        ArrayList<AddressSet> list = new ArrayList<AddressSet>();
        for (MemoryBlock memoryBlock : blocks = mem.getBlocks()) {
            AddressSet set = addressSet.intersectRange(memoryBlock.getStart(), memoryBlock.getEnd());
            if (set.isEmpty()) continue;
            list.add(set);
        }
        return list;
    }

    private void searchSubAddressSet(AddressSetView addressSet, Accumulator<MemSearchResult> accumulator, TaskMonitor monitor, int progressCount) {
        SearchData searchData = this.searchInfo.getSearchData();
        Pattern pattern = ((RegExSearchData)searchData).getRegExPattern();
        Memory memory = this.program.getMemory();
        int searchLimit = this.searchInfo.getSearchLimit();
        try {
            MemoryAddressSetCharSequence charSet = new MemoryAddressSetCharSequence(memory, addressSet);
            Matcher matcher = pattern.matcher(charSet);
            int searchFrom = 0;
            while (matcher.find(searchFrom) && !monitor.isCancelled()) {
                int startIndex = matcher.start();
                int length = matcher.end() - startIndex;
                Address address = charSet.getAddressAtIndex(startIndex);
                if (this.isMatchingAddress(address, length)) {
                    MemSearchResult result = new MemSearchResult(address, length);
                    accumulator.add((Object)result);
                    monitor.setProgress((long)(progressCount + startIndex));
                    if (accumulator.size() >= searchLimit) {
                        return;
                    }
                }
                searchFrom = startIndex + 1;
            }
        }
        catch (MemoryAccessException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            monitor.setMessage("Error: Could not read memory");
        }
    }

    protected boolean isMatchingAddress(Address address, long matchSize) {
        if (address == null) {
            return false;
        }
        if (address.getOffset() % (long)this.alignment != 0L) {
            return false;
        }
        if (this.codeUnitSearchInfo.searchAll()) {
            return true;
        }
        Listing listing = this.program.getListing();
        CodeUnit codeUnit = listing.getCodeUnitContaining(address);
        if (codeUnit instanceof Instruction) {
            return this.codeUnitSearchInfo.isSearchInstructions();
        }
        if (codeUnit instanceof Data) {
            Data data = (Data)codeUnit;
            if (data.isDefined()) {
                return this.codeUnitSearchInfo.isSearchDefinedData();
            }
            return this.codeUnitSearchInfo.isSearchUndefinedData();
        }
        return false;
    }
}

