/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import generic.jar.ApplicationModule;
import generic.jar.ClassModuleTree;
import generic.jar.GClassLoader;
import generic.jar.ResourceFile;
import ghidra.GhidraApplicationLayout;
import ghidra.GhidraLaunchable;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.framework.GModule;
import ghidra.framework.HeadlessGhidraApplicationConfiguration;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassFinder;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.extensions.ExtensionUtils;
import ghidra.util.task.TaskMonitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import utilities.util.FileUtilities;
import utility.application.ApplicationLayout;

public class GhidraJarBuilder
implements GhidraLaunchable {
    private static final String ROOT = "_Root/";
    private static final String ROOT_GHIDRA = "_Root/Ghidra/";
    private static final String INVOCATION_NAME_PROPERTY = "GhidraJarBuilder.Name";
    private List<File> rootGhidraDirs = new ArrayList<File>();
    private List<ApplicationModule> allModules;
    private Set<ApplicationModule> includedModules = new HashSet<ApplicationModule>();
    private List<FileFilter> filters = new ArrayList<FileFilter>();
    private String mainClass = "ghidra.JarRun";
    private boolean excludeHelp;
    private List<String> excludedFileExtensions = new ArrayList<String>();
    private Pattern extensionPointSuffixPattern;
    private List<String> extensionPointClasses = new ArrayList<String>();
    private ClassLoader classLoader;
    private Set<File> processedJars = new HashSet<File>();

    public GhidraJarBuilder() {
    }

    public GhidraJarBuilder(ApplicationLayout layout) throws IOException {
        for (ResourceFile file : layout.getApplicationRootDirs()) {
            File rgd = file.getFile(false).getCanonicalFile();
            this.rootGhidraDirs.add(rgd);
        }
        this.allModules = this.findAllModules(layout);
        Collections.sort(this.allModules);
        for (ApplicationModule module : this.allModules) {
            if (!this.includeByDefault(module)) continue;
            this.includedModules.add(module);
        }
        this.filters.add(new FileExtensionFilter());
    }

    private boolean includeByDefault(ApplicationModule module) {
        if (module.isFramework() || module.isProcessor() || module.isConfiguration()) {
            return true;
        }
        if (module.isExtension()) {
            return false;
        }
        if (module.isFeature()) {
            return !module.excludeFromGhidraJar();
        }
        if (module.isDebug()) {
            return !module.excludeFromGhidraJar();
        }
        if (module.isGPL()) {
            return !module.excludeFromGhidraJar();
        }
        return false;
    }

    public List<ApplicationModule> getAllModules() {
        ArrayList<ApplicationModule> list = new ArrayList<ApplicationModule>(this.allModules);
        Collections.sort(list);
        return list;
    }

    public List<ApplicationModule> getIncludedModules() {
        ArrayList<ApplicationModule> list = new ArrayList<ApplicationModule>(this.includedModules);
        Collections.sort(list);
        return list;
    }

    public void removeAllProcessorModules() {
        Iterator<ApplicationModule> it = this.includedModules.iterator();
        while (it.hasNext()) {
            ApplicationModule module = it.next();
            if (!module.isProcessor()) continue;
            it.remove();
        }
    }

    public List<ApplicationModule> getExcludedModules() {
        HashSet<ApplicationModule> set = new HashSet<ApplicationModule>(this.allModules);
        set.removeAll(this.includedModules);
        ArrayList<ApplicationModule> list = new ArrayList<ApplicationModule>(set);
        Collections.sort(list);
        return list;
    }

    public ApplicationModule getModule(String name) {
        for (ApplicationModule module : this.allModules) {
            if (!module.getName().equals(name)) continue;
            return module;
        }
        return null;
    }

    public boolean isModuleIncluded(String moduleName) {
        ApplicationModule module = this.getModule(moduleName);
        return this.includedModules.contains(module);
    }

    public void addAllModules() {
        this.includedModules.addAll(this.allModules);
    }

    public boolean addModule(String name) {
        ApplicationModule module = this.getModule(name);
        if (module != null) {
            return this.includedModules.add(module);
        }
        return false;
    }

    public boolean removeModule(String name) {
        ApplicationModule module = this.getModule(name);
        if (module != null) {
            return this.includedModules.remove(module);
        }
        return false;
    }

    public void addFileFilter(FileFilter filter) {
        this.filters.add(filter);
    }

    public void addExcludedFileExtension(String excludedExtension) {
        this.excludedFileExtensions.add(excludedExtension);
    }

    public void addModuleToJar(ApplicationModule module) {
        this.includedModules.add(module);
    }

    public void setExcludeHelp(boolean excludeHelp) {
        this.excludeHelp = excludeHelp;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void buildJar(File outputFile, File extraBinDir, TaskMonitor monitor) throws IOException, CancelledException {
        Msg.info((Object)this, (Object)("Building GHIDRA standalone jar file: " + outputFile));
        this.createExtensionPointSuffixPattern();
        Manifest manifest = this.createManifest();
        Jar jar = new Jar(outputFile, manifest, monitor);
        ArrayList<ApplicationModule> moduleList = new ArrayList<ApplicationModule>(this.includedModules);
        Collections.sort(moduleList);
        this.createClassLoader(moduleList);
        if (extraBinDir != null) {
            this.writeDirRecursively(jar, extraBinDir.getAbsolutePath(), extraBinDir, null);
        }
        for (ApplicationModule module : moduleList) {
            this.writeModuleClassesAndResources(jar, module);
            if (this.excludeHelp) continue;
            this.writeModuleHelp(jar, module);
        }
        this.writeNonModuleFiles(jar);
        jar.setPathPrefix(ROOT_GHIDRA);
        for (ApplicationModule module : moduleList) {
            this.writeModuleData(jar, module);
        }
        if (extraBinDir != null) {
            this.processSrcForModuleTree(jar, moduleList);
        }
        jar.writeGhidraExtensionsDir();
        jar.writeExtensionPointClassFile();
        jar.writeModuleListFile(moduleList);
        jar.close();
    }

    private void processSrcForModuleTree(Jar jar, List<ApplicationModule> moduleList) {
        for (ApplicationModule module : moduleList) {
            File srcDir = new File(module.getModuleDir(), "src");
            this.processSrcRecursively(jar, srcDir, srcDir.getAbsolutePath(), module);
        }
    }

    private void processSrcRecursively(Jar jar, File srcDir, String rootPath, ApplicationModule module) {
        File[] listFiles;
        if (!srcDir.isDirectory()) {
            return;
        }
        for (File file : listFiles = srcDir.listFiles()) {
            if (file.isDirectory()) {
                this.processSrcRecursively(jar, file, rootPath, module);
                continue;
            }
            if (!this.isJavaFile(file)) continue;
            String path = this.getPathFromRoot(rootPath, file);
            path = path.substring(0, path.length() - 5).concat(".class");
            jar.addToModuleTree(path, module);
        }
    }

    private boolean isJavaFile(File file) {
        return file.getName().endsWith(".java");
    }

    private void createClassLoader(List<ApplicationModule> modules) {
        ArrayList<File> moduleDirs = new ArrayList<File>();
        for (ApplicationModule module : modules) {
            moduleDirs.add(module.getModuleDir());
        }
        this.classLoader = new GClassLoader(moduleDirs);
    }

    private void createExtensionPointSuffixPattern() {
        HashSet<String> suffixes = new HashSet<String>();
        for (ApplicationModule module : this.includedModules) {
            File manifest = new File(module.getModuleDir(), "data/ExtensionPoint.manifest");
            this.accumulatedExtensionPointSuffixes(suffixes, manifest);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(".*(");
        String between = "";
        for (String suffix : suffixes) {
            if ((suffix = suffix.trim()).isEmpty()) continue;
            sb.append(between);
            sb.append(suffix);
            between = "|";
        }
        sb.append(")");
        sb.append(".class");
        this.extensionPointSuffixPattern = Pattern.compile(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accumulatedExtensionPointSuffixes(Set<String> suffixes, File manifest) {
        if (!manifest.exists()) {
            return;
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(manifest));
            while ((line = reader.readLine()) != null) {
                suffixes.add(line);
            }
        }
        catch (Exception e) {
            Msg.error(ClassSearcher.class, (Object)("Error opening extension point file " + manifest.getAbsolutePath()), (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void buildSrcZip(File outputFile, TaskMonitor monitor) throws IOException, CancelledException {
        Zip zip = new Zip(outputFile, monitor);
        boolean wroteToZip = false;
        ArrayList<ApplicationModule> moduleList = new ArrayList<ApplicationModule>(this.includedModules);
        Collections.sort(moduleList);
        for (ApplicationModule module : moduleList) {
            File srcDir = new File(module.getModuleDir(), "src");
            File srcZipFileForModule = new File(srcDir, module.getName() + "-src.zip");
            if (srcZipFileForModule.exists()) {
                this.writeModuleSrcZipToOverallSrcZip(zip, srcZipFileForModule);
                wroteToZip = true;
                continue;
            }
            wroteToZip |= this.writeZipRecursively(zip, srcDir.getAbsolutePath(), srcDir);
        }
        if (wroteToZip) {
            System.out.println("Can't create source zip!  Has source been downloaded and installed?");
            zip.close();
        }
    }

    private void writeModuleSrcZipToOverallSrcZip(Zip zip, File srcZipFileForModule) throws IOException, CancelledException {
        ZipFile zipFile = new ZipFile(srcZipFileForModule);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            if (zipEntry.isDirectory()) continue;
            zip.addZipEntry(zipFile, zipEntry);
        }
    }

    private void writeModuleClassesAndResources(Jar jar, ApplicationModule module) throws CancelledException, IOException {
        File binDir = new File(module.getModuleDir(), "bin/main");
        this.writeDirRecursively(jar, binDir.getAbsolutePath(), binDir, module);
        File resourceDir = new File(module.getModuleDir(), "src/main/resources");
        this.writeDirRecursively(jar, resourceDir.getAbsolutePath(), resourceDir, null);
        this.processLibDir(jar, module);
    }

    private void processLibDir(Jar jar, ApplicationModule module) throws CancelledException, IOException {
        File[] listFiles;
        File libDir = new File(module.getModuleDir(), "lib");
        if (!libDir.isDirectory()) {
            return;
        }
        for (File file : listFiles = libDir.listFiles()) {
            if (!this.isJar(file)) continue;
            this.processJarFile(jar, file, module);
        }
    }

    private void processJarFile(Jar jar, File file, ApplicationModule module) throws IOException, CancelledException {
        if (!file.exists()) {
            return;
        }
        if (this.processedJars.contains(file)) {
            return;
        }
        this.processedJars.add(file);
        JarFile jarFile = new JarFile(file);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            String jarName = jarEntry.getName();
            if (jarName.contains("Log4j2Plugins.dat")) {
                if (!jarFile.getName().contains("log4j-core")) continue;
                jar.addJarEntry(jarFile, jarEntry, module);
            }
            if (jarName.endsWith(".SF") || jarName.endsWith(".DSA") || jarName.endsWith(".RSA")) continue;
            jar.addJarEntry(jarFile, jarEntry, module);
        }
    }

    private boolean isJar(File file) {
        return file.isFile() && file.getName().endsWith(".jar");
    }

    private void writeModuleData(Jar jar, ApplicationModule module) throws CancelledException, IOException {
        File moduleDir = module.getModuleDir();
        String appRootPath = module.getApplicationRoot().getAbsolutePath();
        File moduleManifestFile = new File(moduleDir, "Module.manifest");
        String jarPath = this.getPathFromRoot(appRootPath, moduleManifestFile);
        jar.addFile(jarPath, moduleManifestFile, null);
        File extensionPropertiesFile = new File(moduleDir, ExtensionUtils.PROPERTIES_FILE_NAME);
        if (extensionPropertiesFile.exists()) {
            jarPath = this.getPathFromRoot(appRootPath, extensionPropertiesFile);
            jar.addFile(jarPath, extensionPropertiesFile, module);
        }
        this.writeDirRecursively(jar, appRootPath, new File(moduleDir, "data"), null);
        this.writeDirRecursively(jar, appRootPath, new File(moduleDir, "os"), null);
        this.writeDirRecursively(jar, appRootPath, new File(moduleDir, "build/os"), null);
        this.writeDirRecursively(jar, appRootPath, new File(moduleDir, "ghidra_scripts"), null);
        this.writeDirRecursively(jar, appRootPath, new File(moduleDir, "developer_scripts"), null);
    }

    private void writeModuleHelp(Jar jar, ApplicationModule module) throws CancelledException, IOException {
        File moduleDir = module.getModuleDir();
        File helpDir = new File(moduleDir, "help");
        if (!helpDir.isDirectory()) {
            return;
        }
        this.writeDirRecursively(jar, moduleDir.getAbsolutePath(), new File(helpDir, "shared"), null);
        this.writeDirRecursively(jar, moduleDir.getAbsolutePath(), new File(helpDir, "topics"), null);
        File helpBinDir = new File(helpDir, "bin/main");
        jar.setPathPrefix("help/");
        this.writeDirRecursively(jar, helpBinDir.getAbsolutePath(), helpBinDir, null);
        jar.setPathPrefix(null);
    }

    private void writeDirRecursively(Jar jar, String rootPath, File dir, ApplicationModule module) throws CancelledException, IOException {
        File[] listFiles;
        if (!dir.isDirectory()) {
            return;
        }
        for (File file : listFiles = dir.listFiles()) {
            if (file.isDirectory()) {
                this.writeDirRecursively(jar, rootPath, file, module);
                continue;
            }
            if (!this.passesAllFilters(file)) continue;
            String jarPath = this.getPathFromRoot(rootPath, file);
            jar.addFile(jarPath, file, module);
        }
    }

    private boolean writeZipRecursively(Zip zip, String rootPath, File dir) throws CancelledException, IOException {
        File[] listFiles;
        if (!dir.isDirectory()) {
            return false;
        }
        boolean wroteToZip = false;
        for (File file : listFiles = dir.listFiles()) {
            if (file.isDirectory()) {
                wroteToZip |= this.writeZipRecursively(zip, rootPath, file);
                continue;
            }
            String zipPath = this.getPathFromRoot(rootPath, file);
            zip.addFile(zipPath, file);
            wroteToZip = true;
        }
        return wroteToZip;
    }

    private boolean passesAllFilters(File file) {
        for (FileFilter filter : this.filters) {
            if (filter.accept(file)) continue;
            return false;
        }
        return true;
    }

    private void writeNonModuleFiles(Jar jar) throws IOException, CancelledException {
        File changeHistory;
        jar.setPathPrefix(ROOT);
        File rootDir = this.findRootDir();
        File applicatonProperties = GhidraJarBuilder.getApplicationPropertyFile(rootDir);
        String jarPath = this.getPathFromRoot(rootDir.getParentFile().getAbsolutePath(), applicatonProperties);
        jar.addFile(jarPath, applicatonProperties, null);
        File whatsNew = new File(rootDir, "docs/WhatsNew.html");
        if (whatsNew.exists()) {
            jarPath = this.getPathFromRoot(rootDir.getAbsolutePath(), whatsNew);
            jar.addFile(jarPath, whatsNew, null);
        }
        if ((changeHistory = new File(rootDir, "docs/ChangeHistory.html")).exists()) {
            jarPath = this.getPathFromRoot(rootDir.getAbsolutePath(), changeHistory);
            jar.addFile(jarPath, changeHistory, null);
        }
    }

    private File findRootDir() {
        for (File root : this.rootGhidraDirs) {
            if (!GhidraJarBuilder.getApplicationPropertyFile(root).exists()) continue;
            return root;
        }
        throw new AssertException("Can't find application property file!");
    }

    private Manifest createManifest() {
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        mainAttributes.putValue("Manifest-Version", "1.0");
        if (this.mainClass != null) {
            mainAttributes.putValue("Main-Class", this.mainClass);
        }
        return manifest;
    }

    private List<ApplicationModule> findAllModules(ApplicationLayout layout) throws IOException {
        ArrayList<ApplicationModule> modules = new ArrayList<ApplicationModule>();
        for (GModule module : layout.getModules().values()) {
            File moduleDir = module.getModuleRoot().getFile(false).getCanonicalFile();
            File rootDir = this.getModuleRootDir(moduleDir);
            modules.add(new ApplicationModule(rootDir, moduleDir));
        }
        return modules;
    }

    private File getModuleRootDir(File moduleDir) {
        ArrayList<File> rootDirs = new ArrayList<File>(this.rootGhidraDirs);
        for (File rootDir : this.rootGhidraDirs) {
            rootDirs.add(new File(rootDir.getParentFile(), "GPL"));
        }
        for (File rootDir : rootDirs) {
            if (!FileUtilities.isPathContainedWithin((File)rootDir, (File)moduleDir)) continue;
            return rootDir;
        }
        throw new AssertException("Module root directory could not be determined: " + moduleDir);
    }

    private String getPathFromRoot(String rootPath, File file) {
        String filePath = file.getAbsolutePath();
        if (!filePath.startsWith(rootPath)) {
            throw new AssertException("Attempted to get jar path for file not under root!");
        }
        return filePath.substring(rootPath.length() + 1);
    }

    private void checkExtensionPointClass(String path, InputStream inputStream) {
        path = path.substring(0, path.length() - 6);
        path = path.replace('/', '.');
        try {
            Class<?> clazz = this.classLoader.loadClass(path);
            if (clazz == null) {
                System.out.println("Couldn't load " + path);
            } else if (ClassFinder.isClassOfInterest(clazz)) {
                this.extensionPointClasses.add(clazz.getName());
            }
        }
        catch (ClassNotFoundException e) {
            System.out.println("Can't load class " + path);
        }
        catch (Throwable t) {
            System.out.println("Throwable " + t);
        }
    }

    private static void usage(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            System.err.println("arg " + i + ": " + args[i]);
        }
        String invocationName = System.getProperty(INVOCATION_NAME_PROPERTY);
        StringBuffer buf = new StringBuffer();
        buf.append("\nUsage: ");
        buf.append(invocationName != null ? invocationName : "GhidraJarBuilder");
        buf.append(" [-output <output file>] [-srczip <src zip output file>] [-bin <compiled classes dir>] [-main <main-class>]\n");
        System.err.println(buf.toString());
        System.exit(0);
    }

    public static void main(String[] args) throws IOException {
        new GhidraJarBuilder().launch(new GhidraApplicationLayout(), args);
    }

    public void launch(GhidraApplicationLayout layout, String[] args) throws IOException {
        Application.initializeApplication((ApplicationLayout)layout, (ApplicationConfiguration)new HeadlessGhidraApplicationConfiguration());
        if (args.length == 0) {
            GhidraJarBuilder.usage(args);
        }
        File outputFile = null;
        File srczip = null;
        File extraBinDir = null;
        String mainClassArg = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-output")) {
                if (i == args.length - 1) {
                    GhidraJarBuilder.usage(args);
                }
                outputFile = new File(args[++i]);
                continue;
            }
            if (arg.equals("-srczip")) {
                if (i == args.length - 1) {
                    GhidraJarBuilder.usage(args);
                }
                srczip = new File(args[++i]);
                continue;
            }
            if (arg.equals("-bin")) {
                if (i == args.length - 1) {
                    GhidraJarBuilder.usage(args);
                }
                extraBinDir = new File(args[++i]);
                continue;
            }
            if (arg.equals("-main")) {
                if (i == args.length - 1) {
                    GhidraJarBuilder.usage(args);
                }
                mainClassArg = args[++i];
                continue;
            }
            GhidraJarBuilder.usage(args);
        }
        if (outputFile == null) {
            outputFile = new File("ghidra.jar");
        }
        System.out.println("Output file = " + outputFile);
        if (srczip != null) {
            System.out.println("Source Zip File = " + srczip);
        }
        if (extraBinDir != null) {
            System.out.println("Extra Bin Dir = " + extraBinDir);
        }
        try {
            GhidraJarBuilder builder = new GhidraJarBuilder((ApplicationLayout)layout);
            if (mainClassArg != null) {
                builder.setMainClass(mainClassArg);
            }
            builder.addExcludedFileExtension(".pdf");
            List<ApplicationModule> moduleList = builder.getIncludedModules();
            for (ApplicationModule module : moduleList) {
                System.out.println("Include " + module.getName());
            }
            moduleList = builder.getExcludedModules();
            for (ApplicationModule module : moduleList) {
                System.out.println("Exclude " + module.getName());
            }
            builder.buildJar(outputFile, extraBinDir, TaskMonitor.DUMMY);
            if (srczip != null) {
                builder.buildSrcZip(srczip, TaskMonitor.DUMMY);
            }
        }
        catch (Exception e) {
            System.err.println("Exception build ghidra jar");
            e.printStackTrace();
        }
        System.out.println("Done");
    }

    private static File getApplicationPropertyFile(File ghidraRootDir) {
        return new File(ghidraRootDir, "application.properties");
    }

    private class FileExtensionFilter
    implements FileFilter {
        private FileExtensionFilter() {
        }

        @Override
        public boolean accept(File file) {
            for (String excludedExtension : GhidraJarBuilder.this.excludedFileExtensions) {
                if (!file.getName().endsWith(excludedExtension)) continue;
                return false;
            }
            return true;
        }
    }

    private class Jar {
        private JarOutputStream jarOut;
        private TaskMonitor monitor;
        private String prefix;
        private ClassModuleTree classTree = new ClassModuleTree();

        Jar(File outputFile, Manifest manifest, TaskMonitor monitor) throws IOException {
            this.monitor = monitor;
            FileOutputStream fos = new FileOutputStream(outputFile);
            this.jarOut = new JarOutputStream((OutputStream)fos, manifest);
        }

        public void writeGhidraExtensionsDir() throws IOException {
            ZipEntry entry = new ZipEntry("_Root/Ghidra/Extensions/");
            try {
                this.jarOut.putNextEntry(entry);
            }
            catch (ZipException e) {
                System.out.println(e.getMessage());
                return;
            }
            finally {
                this.jarOut.closeEntry();
            }
        }

        public void writeExtensionPointClassFile() throws IOException {
            ZipEntry entry = new ZipEntry("_Root/Ghidra/EXTENSION_POINT_CLASSES");
            try {
                this.jarOut.putNextEntry(entry);
            }
            catch (ZipException e) {
                System.out.println(e.getMessage());
                return;
            }
            for (String extensionPointClass : GhidraJarBuilder.this.extensionPointClasses) {
                this.jarOut.write(extensionPointClass.getBytes());
                this.jarOut.write(10);
            }
            this.jarOut.closeEntry();
        }

        public void writeModuleListFile(List<ApplicationModule> moduleList) throws IOException {
            ZipEntry entry = new ZipEntry("_Root/Ghidra/MODULE_LIST");
            try {
                this.jarOut.putNextEntry(entry);
            }
            catch (ZipException e) {
                System.out.println(e.getMessage());
                return;
            }
            for (ApplicationModule module : moduleList) {
                String relativePath = module.getRelativePath();
                this.jarOut.write(relativePath.getBytes());
                this.jarOut.write(10);
            }
            this.jarOut.closeEntry();
        }

        public void setPathPrefix(String string) {
            this.prefix = string;
        }

        public void close() throws IOException {
            File tempFile = File.createTempFile("jarBuilder", "treeIDX");
            this.classTree.trim();
            this.classTree.saveFile(tempFile);
            try {
                this.addFile("classModuleTree", tempFile, null);
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
            tempFile.delete();
            this.jarOut.close();
        }

        public void addFile(String jarPath, File file, ApplicationModule module) throws IOException, CancelledException {
            if (!file.exists()) {
                throw new AssertException("Attempted to write a file that does not exist to the jar! File = " + file.getAbsolutePath());
            }
            if (!file.isFile()) {
                throw new AssertException("Attempted to write a directory to the jar! File = " + file.getAbsolutePath());
            }
            jarPath = ((String)jarPath).replaceAll("\\\\", "/");
            long modifiedTime = file.lastModified();
            this.addToModuleTree((String)jarPath, module);
            if (GhidraJarBuilder.this.extensionPointSuffixPattern.matcher((CharSequence)jarPath).matches()) {
                try (FileInputStream inStream = new FileInputStream(file);){
                    GhidraJarBuilder.this.checkExtensionPointClass((String)jarPath, inStream);
                }
            }
            if (this.prefix != null) {
                jarPath = this.prefix + (String)jarPath;
            }
            if (((String)jarPath).contains("..")) {
                jarPath = Path.of((String)jarPath, new String[0]).normalize().toString();
            }
            ZipEntry entry = new ZipEntry((String)jarPath);
            entry.setTime(modifiedTime);
            try {
                this.jarOut.putNextEntry(entry);
            }
            catch (ZipException e) {
                System.out.println(e.getMessage());
                return;
            }
            try (FileInputStream in = new FileInputStream(file);){
                int numRead;
                byte[] bytes = new byte[4096];
                while ((numRead = ((InputStream)in).read(bytes)) != -1) {
                    this.monitor.checkCancelled();
                    this.jarOut.write(bytes, 0, numRead);
                }
            }
            this.jarOut.closeEntry();
        }

        public void addJarEntry(JarFile jarFile, JarEntry jarEntry, ApplicationModule module) throws IOException, CancelledException {
            int numRead;
            long modifiedTime = jarEntry.getTime();
            String path = jarEntry.getName();
            if (GhidraJarBuilder.this.extensionPointSuffixPattern.matcher(path).matches()) {
                GhidraJarBuilder.this.checkExtensionPointClass(path, jarFile.getInputStream(jarEntry));
            }
            this.addToModuleTree(path, module);
            ZipEntry entry = new ZipEntry(path);
            entry.setTime(modifiedTime);
            try {
                this.jarOut.putNextEntry(entry);
            }
            catch (ZipException e) {
                System.out.println(e.getMessage());
                return;
            }
            InputStream in = jarFile.getInputStream(jarEntry);
            byte[] bytes = new byte[4096];
            while ((numRead = in.read(bytes)) != -1) {
                this.monitor.checkCancelled();
                this.jarOut.write(bytes, 0, numRead);
            }
            in.close();
            this.jarOut.closeEntry();
        }

        private void addToModuleTree(String path, ApplicationModule module) {
            if (module == null) {
                return;
            }
            if (path.endsWith(".class")) {
                this.classTree.addNode(path, module.getName());
            }
        }
    }

    private class Zip {
        private ZipOutputStream zipOut;
        private TaskMonitor monitor;

        Zip(File outputFile, TaskMonitor monitor) throws IOException {
            this.monitor = monitor;
            FileOutputStream fos = new FileOutputStream(outputFile);
            this.zipOut = new ZipOutputStream(fos);
        }

        public void close() throws IOException {
            this.zipOut.close();
        }

        public void addFile(String zipPath, File file) throws IOException, CancelledException {
            int numRead;
            if (!file.isFile()) {
                throw new AssertException("Attempted to write a directory to the jar file");
            }
            zipPath = zipPath.replaceAll("\\\\", "/");
            long modifiedTime = file.lastModified();
            ZipEntry entry = new ZipEntry(zipPath);
            entry.setTime(modifiedTime);
            try {
                this.zipOut.putNextEntry(entry);
            }
            catch (ZipException e) {
                System.out.println(e.getMessage());
                return;
            }
            FileInputStream in = new FileInputStream(file);
            byte[] bytes = new byte[4096];
            while ((numRead = ((InputStream)in).read(bytes)) != -1) {
                this.monitor.checkCancelled();
                this.zipOut.write(bytes, 0, numRead);
            }
            ((InputStream)in).close();
            this.zipOut.closeEntry();
        }

        public void addZipEntry(ZipFile zipFile, ZipEntry zipEntry) throws IOException, CancelledException {
            int numRead;
            long modifiedTime = zipEntry.getTime();
            String path = zipEntry.getName();
            ZipEntry entry = new ZipEntry(path);
            entry.setTime(modifiedTime);
            try {
                this.zipOut.putNextEntry(entry);
            }
            catch (ZipException e) {
                System.out.println(e.getMessage());
                return;
            }
            InputStream in = zipFile.getInputStream(zipEntry);
            byte[] bytes = new byte[4096];
            while ((numRead = in.read(bytes)) != -1) {
                this.monitor.checkCancelled();
                this.zipOut.write(bytes, 0, numRead);
            }
            in.close();
            this.zipOut.closeEntry();
        }
    }
}

