/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftStructure;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public final class MetadataSourceRecord
implements SwiftStructure {
    public static final int SIZE = 8;
    private String mangledTypeName;
    private String mangledMetadataSource;

    public MetadataSourceRecord(BinaryReader reader) throws IOException {
        this.mangledTypeName = reader.readNext(SwiftUtils::relativeString);
        this.mangledMetadataSource = reader.readNext(SwiftUtils::relativeString);
    }

    public String getMangledTypeName() {
        return this.mangledTypeName;
    }

    public String getMangledMetadataSource() {
        return this.mangledMetadataSource;
    }

    @Override
    public String getStructureName() {
        return MetadataSourceRecord.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "metadata source record";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getStructureName(), 0);
        struct.add((DataType)SwiftUtils.PTR_STRING, "MangledTypeName", "");
        struct.add((DataType)SwiftUtils.PTR_STRING, "MangledMetadataSource", "");
        struct.setCategoryPath(new CategoryPath("/Swift"));
        return struct;
    }
}

