/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftStructure;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.app.util.bin.format.swift.types.AssociatedTypeRecord;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class AssociatedTypeDescriptor
implements SwiftStructure {
    public static final int SIZE = 16;
    private String conformingTypeName;
    private String protocolTypeName;
    private int numAssociatedTypes;
    private int associatedTypeRecordSize;
    private List<AssociatedTypeRecord> associatedTypeRecords = new ArrayList<AssociatedTypeRecord>();

    public AssociatedTypeDescriptor(BinaryReader reader) throws IOException {
        this.conformingTypeName = reader.readNext(SwiftUtils::relativeString);
        this.protocolTypeName = reader.readNext(SwiftUtils::relativeString);
        this.numAssociatedTypes = reader.readNextInt();
        this.associatedTypeRecordSize = reader.readNextInt();
        for (int i = 0; i < this.numAssociatedTypes; ++i) {
            this.associatedTypeRecords.add(new AssociatedTypeRecord(reader));
        }
    }

    public String getConformingTypeName() {
        return this.conformingTypeName;
    }

    public String getProtocolTypeName() {
        return this.protocolTypeName;
    }

    public int getNumAssociatedTypes() {
        return this.numAssociatedTypes;
    }

    public int getAssociatedTypeRecordSize() {
        return this.associatedTypeRecordSize;
    }

    public List<AssociatedTypeRecord> getAssociatedTypeRecords() {
        return this.associatedTypeRecords;
    }

    @Override
    public String getStructureName() {
        return AssociatedTypeDescriptor.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "associated type descriptor";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getStructureName(), 0);
        struct.add((DataType)SwiftUtils.PTR_STRING, "ConformingTypeName", "");
        struct.add((DataType)SwiftUtils.PTR_STRING, "ProtocolTypeName", "");
        struct.add(DWORD, "NumAssociatedTypes", "");
        struct.add(DWORD, "AssociatedTypeRecordSize", "");
        struct.setCategoryPath(new CategoryPath("/Swift"));
        return struct;
    }
}

