/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfExternalSymbol;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.bin.format.omf.OmfSymbol;
import java.io.IOException;

public class OmfComdefRecord
extends OmfExternalSymbol {
    public OmfComdefRecord(BinaryReader reader, boolean isStatic) throws IOException, OmfException {
        super(isStatic);
        this.readRecordHeader(reader);
        long max = reader.getPointerIndex() + (long)this.getRecordLength() - 1L;
        while (reader.getPointerIndex() < max) {
            String name = OmfRecord.readString(reader);
            int typeIndex = OmfRecord.readIndex(reader);
            byte dataType = reader.readNextByte();
            int byteLength = 0;
            if (dataType == 97) {
                int numElements = OmfComdefRecord.readCommunalLength(reader);
                int elSize = OmfComdefRecord.readCommunalLength(reader);
                byteLength = numElements * elSize;
            } else {
                byteLength = OmfComdefRecord.readCommunalLength(reader);
            }
            this.symbols.add(new OmfSymbol(name, typeIndex, 0L, dataType, byteLength));
        }
        this.readCheckSumByte(reader);
    }

    private static int readCommunalLength(BinaryReader reader) throws OmfException, IOException {
        int val = reader.readNextByte() & 0xFF;
        if (val <= 128) {
            return val;
        }
        if (val == 129) {
            val = reader.readNextShort() & 0xFFFF;
        } else if (val == 132) {
            val = reader.readNextShort() & 0xFFFF;
            int hithird = reader.readNextByte() & 0xFF;
            val += hithird << 16;
        } else if (val == 136) {
            val = reader.readNextInt();
        } else {
            throw new OmfException("Illegal communal length encoding");
        }
        return val;
    }
}

