/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_Constants;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_State;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Utilities;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ObjectiveC2_InstanceVariable
implements StructConverter {
    private ObjectiveC2_State _state;
    private long offset;
    private String name;
    private String type;
    private int alignment;
    private int size;

    public ObjectiveC2_InstanceVariable(ObjectiveC2_State state, BinaryReader reader) throws IOException {
        long typeIndex;
        this._state = state;
        this.offset = state.is32bit ? (long)reader.readNextInt() & 0xFFFFFFFFL : reader.readNextLong();
        long nameIndex = ObjectiveC1_Utilities.readNextIndex(reader, state.is32bit);
        if (nameIndex > 0L && reader.isValidIndex(nameIndex)) {
            this.name = reader.readAsciiString(nameIndex);
        }
        if ((typeIndex = ObjectiveC1_Utilities.readNextIndex(reader, state.is32bit)) > 0L && reader.isValidIndex(typeIndex)) {
            this.type = reader.readAsciiString(typeIndex);
        }
        this.alignment = reader.readNextInt();
        this.size = reader.readNextInt();
    }

    public long getOffset() {
        return this.offset;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("ivar_t", 0);
        if (this._state.is32bit) {
            struct.add((DataType)new PointerDataType(DWORD), this._state.pointerSize, "offset", null);
            struct.add((DataType)new PointerDataType(STRING), this._state.pointerSize, "name", null);
            struct.add((DataType)new PointerDataType(STRING), this._state.pointerSize, "type", null);
        } else {
            struct.add((DataType)new PointerDataType(QWORD), this._state.pointerSize, "offset", null);
            struct.add((DataType)new PointerDataType(STRING), this._state.pointerSize, "name", null);
            struct.add((DataType)new PointerDataType(STRING), this._state.pointerSize, "type", null);
        }
        struct.add(DWORD, "alignment", null);
        struct.add(DWORD, "size", null);
        struct.setCategoryPath(ObjectiveC2_Constants.CATEGORY_PATH);
        return struct;
    }

    public void applyTo(Namespace namespace) throws Exception {
        if (this.getOffset() == 0L) {
            return;
        }
        if (this.getName() == null && this.getName().length() == 0) {
            return;
        }
        Address address = this._state.program.getAddressFactory().getDefaultAddressSpace().getAddress(this.getOffset());
        ObjectiveC1_Utilities.createSymbol(this._state.program, namespace, this.getName(), address);
        this._state.variableMap.put(address, this);
    }
}

