/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideFixup;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfo1;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfo2;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfo3;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfo4;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;

public abstract class DyldCacheSlideInfoCommon
implements StructConverter {
    public static final int DATA_PAGE_MAP_ENTRY = 1;
    public static final int BYTES_PER_CHAIN_OFFSET = 4;
    public static final int CHAIN_OFFSET_MASK = 16383;
    protected int version;
    protected long slideInfoOffset;
    protected long mappingAddress;
    protected long mappingSize;
    protected long mappingFileOffset;

    public static DyldCacheSlideInfoCommon parseSlideInfo(BinaryReader reader, long slideInfoOffset, long mappingAddress, long mappingSize, long mappingFileOffset, MessageLog log, TaskMonitor monitor) {
        if (slideInfoOffset == 0L) {
            return null;
        }
        monitor.setMessage("Parsing DYLD slide info...");
        monitor.initialize(1L);
        Object errorMessage = "Failed to parse dyld_cache_slide_info";
        try {
            reader.setPointerIndex(slideInfoOffset);
            int version = reader.readInt(reader.getPointerIndex());
            errorMessage = (String)errorMessage + version;
            DyldCacheSlideInfoCommon returnedSlideInfo = switch (version) {
                case 1 -> new DyldCacheSlideInfo1(reader, mappingAddress, mappingSize, mappingFileOffset);
                case 2 -> new DyldCacheSlideInfo2(reader, mappingAddress, mappingSize, mappingFileOffset);
                case 3 -> new DyldCacheSlideInfo3(reader, mappingAddress, mappingSize, mappingFileOffset);
                case 4 -> new DyldCacheSlideInfo4(reader, mappingAddress, mappingSize, mappingFileOffset);
                default -> throw new IOException();
            };
            monitor.incrementProgress(1L);
            returnedSlideInfo.slideInfoOffset = slideInfoOffset;
            return returnedSlideInfo;
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheSlideInfoCommon.class.getSimpleName(), (String)errorMessage);
            return null;
        }
    }

    public DyldCacheSlideInfoCommon(BinaryReader reader, long mappingAddress, long mappingSize, long mappingFileOffset) throws IOException {
        this.mappingAddress = mappingAddress;
        this.mappingSize = mappingSize;
        this.mappingFileOffset = mappingFileOffset;
        this.version = reader.readNextInt();
    }

    public int getVersion() {
        return this.version;
    }

    public long getSlideInfoOffset() {
        return this.slideInfoOffset;
    }

    public long getMappingAddress() {
        return this.mappingAddress;
    }

    public long getMappingSize() {
        return this.mappingSize;
    }

    public long getMappingFileOffset() {
        return this.mappingFileOffset;
    }

    public abstract List<DyldCacheSlideFixup> getSlideFixups(BinaryReader var1, int var2, MessageLog var3, TaskMonitor var4) throws IOException, CancelledException;

    public void fixupSlidePointers(Program program, boolean markup, boolean addRelocations, MessageLog log, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        Memory memory = program.getMemory();
        AddressSpace space = program.getAddressFactory().getDefaultAddressSpace();
        Address dataPageAddr = space.getAddress(this.mappingAddress);
        try (MemoryByteProvider provider = new MemoryByteProvider(memory, dataPageAddr);){
            Address addr;
            BinaryReader reader = new BinaryReader(provider, !memory.isBigEndian());
            List<DyldCacheSlideFixup> fixups = this.getSlideFixups(reader, program.getDefaultPointerSize(), log, monitor);
            monitor.initialize((long)fixups.size(), "Fixing DYLD Cache slide pointers...");
            for (DyldCacheSlideFixup fixup : fixups) {
                monitor.increment();
                addr = dataPageAddr.add(fixup.offset());
                if (fixup.size() == 8) {
                    memory.setLong(addr, fixup.value());
                    continue;
                }
                memory.setInt(addr, (int)fixup.value());
            }
            if (markup) {
                monitor.initialize((long)fixups.size(), "Marking up DYLD Cache slide pointers...");
                for (DyldCacheSlideFixup fixup : fixups) {
                    monitor.increment();
                    addr = dataPageAddr.add(fixup.offset());
                    if (addRelocations) {
                        program.getRelocationTable().add(addr, Relocation.Status.APPLIED, this.version, new long[]{fixup.value()}, fixup.size(), null);
                    }
                    try {
                        program.getListing().createData(addr, POINTER);
                    }
                    catch (CodeUnitInsertionException codeUnitInsertionException) {}
                }
            }
        }
        catch (IOException e) {
            throw new MemoryAccessException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_cache_slide_info", 0);
        struct.add(DWORD, "version", "");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

