/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.LEB128Info;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.LinkEditDataCommand;
import ghidra.app.util.bin.format.macho.commands.SegmentCommand;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FunctionStartsCommand
extends LinkEditDataCommand {
    private List<LEB128Info> lebs = new ArrayList<LEB128Info>();

    FunctionStartsCommand(BinaryReader loadCommandReader, BinaryReader dataReader) throws IOException {
        super(loadCommandReader, dataReader);
        LEB128Info info;
        int i = 0;
        while (i + (info = dataReader.readNext(LEB128Info::unsigned)).getLength() <= this.datasize && info.asLong() != 0L) {
            i += info.getLength();
            this.lebs.add(info);
        }
    }

    public List<Address> findFunctionStartAddrs(Address textSegmentAddr) throws IOException {
        ArrayList<Address> addrs = new ArrayList<Address>();
        long currentFuncOffset = 0L;
        for (LEB128Info leb : this.lebs) {
            addrs.add(textSegmentAddr.add(currentFuncOffset += leb.asLong()));
        }
        return addrs;
    }

    @Override
    public void markup(Program program, MachHeader header, String source, TaskMonitor monitor, MessageLog log) throws CancelledException {
        Address addr = this.fileOffsetToAddress(program, header, this.dataoff, this.datasize);
        if (addr == null) {
            return;
        }
        super.markup(program, header, source, monitor, log);
        SegmentCommand textSegment = header.getSegment("__TEXT");
        if (textSegment == null) {
            return;
        }
        try {
            ReferenceManager referenceManager = program.getReferenceManager();
            Address textSegmentAddr = program.getAddressFactory().getDefaultAddressSpace().getAddress(textSegment.getVMaddress());
            long currentFuncOffset = 0L;
            for (LEB128Info leb : this.lebs) {
                Data d = DataUtilities.createData((Program)program, (Address)addr, (DataType)ULEB128, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                addr = addr.add((long)leb.getLength());
                Reference ref = referenceManager.addMemoryReference(d.getMinAddress(), textSegmentAddr.add(currentFuncOffset += leb.asLong()), RefType.DATA, SourceType.IMPORTED, 0);
                referenceManager.setPrimary(ref, true);
            }
        }
        catch (Exception e) {
            log.appendMsg(FunctionStartsCommand.class.getSimpleName(), "Failed to markup: " + this.getContextualName(source, null));
        }
    }
}

