/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.LinkEditDataCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.commands.codesignature.CodeSignatureBlobParser;
import ghidra.app.util.bin.format.macho.commands.codesignature.CodeSignatureGenericBlob;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class CodeSignatureCommand
extends LinkEditDataCommand {
    private CodeSignatureGenericBlob blob;

    CodeSignatureCommand(BinaryReader loadCommandReader, BinaryReader dataReader) throws IOException {
        super(loadCommandReader, dataReader);
        dataReader.setLittleEndian(false);
        this.blob = CodeSignatureBlobParser.parse(dataReader);
    }

    @Override
    public void markup(Program program, MachHeader header, String source, TaskMonitor monitor, MessageLog log) throws CancelledException {
        Address addr = this.fileOffsetToAddress(program, header, this.dataoff, this.datasize);
        if (addr == null) {
            return;
        }
        super.markup(program, header, source, monitor, log);
        try {
            Data d = DataUtilities.createData((Program)program, (Address)addr, (DataType)this.blob.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            LoadCommand.setEndian(d, true);
            this.blob.markup(program, addr, header, monitor, log);
        }
        catch (Exception e) {
            log.appendMsg(CodeSignatureCommand.class.getSimpleName(), "Failed to markup: " + this.getContextualName(source, null));
        }
    }
}

