/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti;

import ghidra.program.database.symbol.FunctionSymbol;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public record GoSymbolName(String symbolName, String packagePath, String packageName, String receiverString) {
    private static final Pattern SYMBOL_INFO_PATTERN = Pattern.compile("^(type:\\.(eq|hash)\\.(\\[[0-9.]*\\])?)?(([-+_/.a-zA-Z0-9]+)(\\(\\*[^)]+\\))?.*)");

    private GoSymbolName(String symbolName) {
        this(symbolName, null, null, null);
    }

    public static String fixGolangSpecialSymbolnameChars(String s) {
        if (s.contains("\u00b7") || s.contains("\u2215")) {
            s = s.replaceAll("\u00b7", ".").replaceAll("\u2215", "/");
        }
        return s;
    }

    public static GoSymbolName parse(String s) {
        s = GoSymbolName.fixGolangSpecialSymbolnameChars(s);
        Matcher m = SYMBOL_INFO_PATTERN.matcher(s);
        if (s.startsWith("go:") || !m.matches()) {
            return new GoSymbolName(s);
        }
        String packageString = m.group(5);
        String receiverString = m.group(6);
        int packageNameStart = packageString.lastIndexOf(47) + 1;
        int firstDot = packageString.indexOf(46, packageNameStart);
        if (firstDot <= 0) {
            return new GoSymbolName(s);
        }
        String packagePath = packageString.substring(0, firstDot);
        String packageName = packageString.substring(packageNameStart, firstDot);
        if (receiverString != null && !receiverString.isEmpty()) {
            receiverString = receiverString.substring(1, receiverString.length() - 1);
        }
        return new GoSymbolName(s, packagePath, packageName, receiverString);
    }

    public static GoSymbolName from(String packageName, String symbolName) {
        return new GoSymbolName(symbolName, packageName, packageName, null);
    }

    public static GoSymbolName fromPackagePath(String packagePath) {
        GoSymbolName tmp = GoSymbolName.parse(packagePath + ".TMP");
        return new GoSymbolName(null, tmp.getPackagePath(), tmp.getPackageName(), null);
    }

    public String getPackagePath() {
        return this.packagePath;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getRecieverString() {
        return this.receiverString;
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    public String getTruncatedPackagePath() {
        return this.packagePath != null && this.packageName != null && this.packagePath.length() > this.packageName.length() ? this.packagePath.substring(0, this.packagePath.length() - this.packageName.length()) : null;
    }

    public Namespace getSymbolNamespace(Program program) {
        Namespace rootNS = program.getGlobalNamespace();
        if (this.packagePath != null && !this.packagePath.isBlank()) {
            try {
                return program.getSymbolTable().getOrCreateNameSpace(rootNS, this.packagePath, SourceType.IMPORTED);
            }
            catch (DuplicateNameException | InvalidInputException throwable) {
                // empty catch block
            }
        }
        return rootNS;
    }

    public Function getFunction(Program program) {
        Namespace ns = this.getSymbolNamespace(program);
        Symbol sym = SymbolUtilities.getUniqueSymbol((Program)program, (String)this.getSymbolName(), (Namespace)ns);
        Function func = sym instanceof FunctionSymbol ? (Function)sym.getObject() : null;
        return func;
    }
}

