/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf4.next.DWARFDataInstanceHelper;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.golang.structmapping.ContextField;
import ghidra.app.util.bin.format.golang.structmapping.EOLComment;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.MarkupSession;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.app.util.bin.format.golang.structmapping.StructureMarkup;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.StringDataInstance;
import java.io.IOException;
import java.util.function.Predicate;

@StructureMapping(structureName="string")
public class GoString
implements StructureMarkup<GoString> {
    public static final int MAX_SANE_STR_LEN = 0x100000;
    @ContextField
    private StructureContext<GoString> context;
    @FieldMapping
    @MarkupReference(value="getStringAddr")
    @EOLComment(value="getStringValue")
    private long str;
    @FieldMapping
    private long len;

    public static GoString createInlineString(GoRttiMapper goBinary, Address stringData, long len) {
        GoString result = new GoString();
        result.context = goBinary.createArtificialStructureContext(GoString.class);
        result.str = stringData.getOffset();
        result.len = len;
        return result;
    }

    public Address getStringAddr() {
        return this.context.getDataTypeMapper().getDataAddress(this.str);
    }

    public AddressRange getStringDataRange() {
        if (this.len <= 0L) {
            return null;
        }
        Address charStart = this.context.getDataTypeMapper().getDataAddress(this.str);
        Address charEnd = this.context.getDataTypeMapper().getDataAddress(this.str + this.len - 1L);
        return new AddressRangeImpl(charStart, charEnd);
    }

    public long getLength() {
        return this.len;
    }

    public String getStringValue() throws IOException {
        BinaryReader reader = this.context.getDataTypeMapper().getReader(this.str);
        return reader.readNextUtf8String((int)this.len);
    }

    private DataType getStringCharDataType() {
        return new ArrayDataType((DataType)CharDataType.dataType, (int)this.len, -1, this.context.getDataTypeMapper().getDTM());
    }

    public boolean isValid(AddressSetView charValidRange, Predicate<String> stringContentValidator) throws IOException {
        if (this.len <= 0L || this.len > 0x100000L) {
            return false;
        }
        Address structStartAddr = this.context.getStructureAddress();
        AddressRange charDataRange = this.getStringDataRange();
        if (charDataRange == null || !charValidRange.contains(charDataRange.getMinAddress(), charDataRange.getMaxAddress())) {
            return false;
        }
        DWARFDataInstanceHelper dihUtil = new DWARFDataInstanceHelper(this.context.getDataTypeMapper().getProgram());
        if (!dihUtil.isDataTypeCompatibleWithAddress((DataType)this.context.getStructureDataType(), structStartAddr)) {
            return false;
        }
        long maxValidLen = charValidRange.getMaxAddress().subtract(charDataRange.getMinAddress()) - 1L;
        if (this.len > maxValidLen) {
            return false;
        }
        if (!this.isCompatibleCharDataType(charDataRange.getMinAddress())) {
            return false;
        }
        if (this.hasOffcutReferences(charDataRange)) {
            return false;
        }
        String stringValue = this.getStringValue();
        return stringContentValidator.test(stringValue);
    }

    private boolean hasOffcutReferences(AddressRange charDataRange) {
        Address refAddr;
        AddressIterator it = this.context.getDataTypeMapper().getProgram().getReferenceManager().getReferenceDestinationIterator((AddressSetView)new AddressSet(charDataRange), true);
        Address address = refAddr = it.hasNext() ? it.next() : null;
        if (refAddr != null && refAddr.equals((Object)charDataRange.getMinAddress())) {
            refAddr = it.hasNext() ? it.next() : null;
        }
        return refAddr != null;
    }

    private boolean isCompatibleCharDataType(Address charDataAddr) {
        DataType stringCharDataType = this.getStringCharDataType();
        DWARFDataInstanceHelper dihUtil = new DWARFDataInstanceHelper(this.context.getDataTypeMapper().getProgram());
        return dihUtil.isDataTypeCompatibleWithAddress(stringCharDataType, charDataAddr);
    }

    public boolean isValidInlineString(AddressSetView charValidRange, Predicate<String> stringContentValidator) throws IOException {
        if (this.len <= 0L || this.len > 0x100000L) {
            return false;
        }
        Address charStart = this.getStringAddr();
        try {
            Address charEnd = charStart.addNoWrap(this.len - 1L);
            if (!charValidRange.contains(charStart) || !charValidRange.contains(charEnd)) {
                return false;
            }
        }
        catch (AddressOverflowException e) {
            return false;
        }
        long maxValidLen = charValidRange.getMaxAddress().subtract(charStart) - 1L;
        if (this.len > maxValidLen) {
            return false;
        }
        if (!this.isCompatibleCharDataType(charStart)) {
            return false;
        }
        String stringValue = this.getStringValue();
        return stringContentValidator.test(stringValue);
    }

    @Override
    public String getStructureLabel() throws IOException {
        return StringDataInstance.makeStringLabel((String)"gostr_", (String)this.getStringValue(), (DataTypeDisplayOptions)DataTypeDisplayOptions.DEFAULT);
    }

    @Override
    public StructureContext<GoString> getStructureContext() {
        return this.context;
    }

    @Override
    public void additionalMarkup(MarkupSession session) throws IOException {
        session.markupAddress(this.getStringAddr(), this.getStringCharDataType());
    }
}

