/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.info;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteArrayProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.elf.info.ElfInfoItem;
import ghidra.app.util.bin.format.elf.info.StandardElfInfoProducer;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import java.io.IOException;

public class ElfNote
implements ElfInfoItem {
    private static final int MAX_SANE_NAME_LEN = 1024;
    private static final int MAX_SANE_DESC_LEN = 0x100000;
    protected final int nameLen;
    protected final String name;
    protected final int vendorType;
    protected final byte[] description;

    public static ElfNote read(BinaryReader reader) throws IOException {
        int nameLen = reader.readNextUnsignedIntExact();
        int descLen = reader.readNextUnsignedIntExact();
        int vendorType = reader.readNextInt();
        if (nameLen > 1024 || descLen > 0x100000) {
            throw new IOException("Invalid Note lengths: %d, %d".formatted(nameLen, descLen));
        }
        String name = reader.readNextAsciiString(nameLen);
        byte[] desc = reader.readNextByteArray(descLen);
        return new ElfNote(nameLen += reader.align(4), name, vendorType, desc);
    }

    protected static <T extends ElfNote> T readFromProgramHelper(Program program, String sectionName, NoteReaderFunc<T> readerFunc) {
        ElfInfoItem.ItemWithAddress<ElfNote> wrappedNote = ElfInfoItem.readItemFromSection(program, sectionName, (br, _unused) -> ElfNote.read(br));
        if (wrappedNote != null) {
            try {
                return readerFunc.read(wrappedNote.item(), program);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    protected ElfNote(int nameLen, String name, int vendorType, byte[] description) {
        this.nameLen = nameLen;
        this.name = name;
        this.vendorType = vendorType;
        this.description = description;
    }

    protected ElfNote(int nameLen, String name, int vendorType) {
        this(nameLen, name, vendorType, null);
    }

    public boolean isGnu() {
        return "GNU".equals(this.name);
    }

    public String getName() {
        return this.name;
    }

    public int getNameLen() {
        return this.nameLen;
    }

    public byte[] getDescription() {
        return this.description;
    }

    public int getDescriptionLen() {
        return this.description != null ? this.description.length : 0;
    }

    public String getDescriptionAsHexString() {
        return NumericUtilities.convertBytesToString((byte[])this.description);
    }

    public BinaryReader getDescriptionReader(boolean isLittleEndian) {
        ByteArrayProvider bap = new ByteArrayProvider(this.description);
        BinaryReader descReader = new BinaryReader(bap, isLittleEndian);
        return descReader;
    }

    public int getVendorType() {
        return this.vendorType;
    }

    public String getNoteTypeName() {
        return "%s, %d".formatted(this.name, this.vendorType);
    }

    public String getNoteValueString() {
        return this.getDescriptionAsHexString();
    }

    public String getProgramInfoKey() {
        return "ELF Note[%s]".formatted(this.getNoteTypeName());
    }

    public void decorateProgramInfo(Options programInfoOptions) {
        programInfoOptions.setString(this.getProgramInfoKey().replaceAll("\\.", "_"), this.getNoteValueString());
    }

    @Override
    public void markupProgram(Program program, Address address) {
        this.decorateProgramInfo(program.getOptions("Program Information"));
        StructureDataType dt = this.toStructure((DataTypeManager)program.getDataTypeManager());
        if (dt != null) {
            try {
                DataUtilities.createData((Program)program, (Address)address, (DataType)dt, (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA);
            }
            catch (CodeUnitInsertionException e) {
                Msg.error((Object)this, (Object)"Failed to markup Elf Note at %s: %s".formatted(address, this), (Throwable)e);
            }
        }
    }

    public StructureDataType toStructure(DataTypeManager dtm) {
        return ElfNote.createNoteStructure(StandardElfInfoProducer.ELF_CATEGORYPATH, "ElfNote", true, this.getNameLen(), this.getDescriptionLen(), dtm);
    }

    public String toString() {
        return "ELF Note[%s]: %s".formatted(this.getNoteTypeName(), this.getNoteValueString());
    }

    protected static StructureDataType createNoteStructure(CategoryPath cp, String structName, boolean templatedName, int noteNameLen, int noteDescLen, DataTypeManager dtm) {
        if (templatedName) {
            structName = "%s_%d_%d".formatted(structName, noteNameLen, noteDescLen);
        }
        if (cp == null) {
            cp = StandardElfInfoProducer.ELF_CATEGORYPATH;
        }
        StructureDataType result = new StructureDataType(cp, structName, 0, dtm);
        result.add(StructConverter.DWORD, "namesz", "Length of name field");
        result.add(StructConverter.DWORD, "descsz", "Length of description field");
        result.add(StructConverter.DWORD, "type", "Vendor specific type");
        if (noteNameLen > 0) {
            result.add((DataType)StringDataType.dataType, noteNameLen, "name", "Vendor name");
        }
        if (noteDescLen > 0) {
            result.add((DataType)new ArrayDataType(StructConverter.BYTE, noteDescLen, StructConverter.BYTE.getLength(), dtm), "description", "Blob value");
        }
        return result;
    }

    @FunctionalInterface
    public static interface NoteReaderFunc<T extends ElfNote> {
        public T read(ElfNote var1, Program var2) throws IOException;
    }
}

