/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.funcfixup;

import ghidra.app.util.bin.format.dwarf4.DIEAggregate;
import ghidra.app.util.bin.format.dwarf4.DWARFException;
import ghidra.app.util.bin.format.dwarf4.funcfixup.DWARFFunctionFixup;
import ghidra.app.util.bin.format.dwarf4.next.DWARFFunction;
import ghidra.program.database.data.ProgramBasedDataTypeManagerDB;
import ghidra.program.model.listing.Program;
import ghidra.util.classfinder.ExtensionPointProperties;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

@ExtensionPointProperties(priority=4000)
public class RustDWARFFunctionFixup
implements DWARFFunctionFixup {
    private String rustCC;

    @Override
    public void fixupDWARFFunction(DWARFFunction dfunc) throws DWARFException {
        DIEAggregate diea = dfunc.diea;
        int cuLang = diea.getCompilationUnit().getCompileUnit().getLanguage();
        if (cuLang == 28) {
            dfunc.callingConventionName = this.getRustCC(dfunc.getProgram().getGhidraProgram());
            dfunc.signatureCommitMode = DWARFFunction.CommitMode.FORMAL;
        }
    }

    private String getRustCC(Program program) throws DWARFException {
        if (this.rustCC == null) {
            this.rustCC = "__rustcall";
            try {
                ProgramBasedDataTypeManagerDB dtm = (ProgramBasedDataTypeManagerDB)program.getDataTypeManager();
                dtm.getCallingConventionID("__rustcall", false);
            }
            catch (InvalidInputException | IOException e) {
                throw new DWARFException("Unable to get Rust calling convention");
            }
        }
        return this.rustCC;
    }
}

