/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.expression;

import ghidra.app.util.bin.format.dwarf4.DWARFCompilationUnit;
import ghidra.app.util.bin.format.dwarf4.DebugInfoEntry;
import ghidra.app.util.bin.format.dwarf4.expression.DWARFExpression;
import ghidra.app.util.bin.format.dwarf4.expression.DWARFExpressionException;
import ghidra.app.util.bin.format.dwarf4.expression.DWARFExpressionOpCodes;
import ghidra.app.util.bin.format.dwarf4.expression.DWARFExpressionOperation;
import ghidra.app.util.bin.format.dwarf4.expression.DWARFExpressionResult;
import ghidra.app.util.bin.format.dwarf4.next.DWARFProgram;
import ghidra.app.util.bin.format.dwarf4.next.DWARFRegisterMappings;
import ghidra.program.model.lang.Register;
import java.util.ArrayDeque;
import java.util.Objects;

public class DWARFExpressionEvaluator {
    private static final int DEFAULT_MAX_STEP_COUNT = 1000;
    private final int dwarfFormat;
    private int maxStepCount = 1000;
    private final byte pointerSize;
    private final boolean isLittleEndian;
    private DWARFRegisterMappings registerMappings;
    private long frameOffset = -1L;
    private int lastRegister = -1;
    private boolean lastStackRelative;
    private boolean registerLoc;
    private boolean isDeref;
    private boolean dwarfStackValue;
    private boolean useUnknownRegister;
    private ArrayDeque<Long> stack = new ArrayDeque();
    private DWARFExpression expr;
    private DWARFExpressionOperation currentOp;
    private int currentOpIndex = -1;

    public static DWARFExpressionEvaluator create(DebugInfoEntry die) {
        DWARFCompilationUnit compUnit = die.getCompilationUnit();
        DWARFProgram prog = die.getCompilationUnit().getProgram();
        DWARFExpressionEvaluator evaluator = new DWARFExpressionEvaluator(compUnit.getPointerSize(), !prog.isBigEndian(), compUnit.getFormat(), prog.getRegisterMappings());
        return evaluator;
    }

    public DWARFExpressionEvaluator(byte pointerSize, boolean isLittleEndian, int dwarfFormat, DWARFRegisterMappings registerMappings) {
        this.pointerSize = pointerSize;
        this.isLittleEndian = isLittleEndian;
        this.dwarfFormat = dwarfFormat;
        this.registerMappings = Objects.requireNonNullElse(registerMappings, DWARFRegisterMappings.DUMMY);
    }

    public void setFrameBase(long fb) {
        this.frameOffset = fb;
    }

    public void push(long l) {
        this.stack.push(l);
        this.lastRegister = -1;
        this.lastStackRelative = false;
        this.registerLoc = false;
    }

    public long peek() throws DWARFExpressionException {
        if (this.stack.isEmpty()) {
            throw new DWARFExpressionException("DWARF expression stack empty");
        }
        return this.stack.peek();
    }

    public long pop() throws DWARFExpressionException {
        if (this.stack.isEmpty()) {
            throw new DWARFExpressionException("DWARF expression stack empty");
        }
        return this.stack.pop();
    }

    public Register getTerminalRegister() {
        return this.registerMappings.getGhidraReg(this.lastRegister);
    }

    public boolean isDeref() {
        return this.isDeref;
    }

    public DWARFExpression readExpr(byte[] exprBytes) throws DWARFExpressionException {
        DWARFExpression tmp = DWARFExpression.read(exprBytes, this.pointerSize, this.isLittleEndian, this.dwarfFormat);
        return tmp;
    }

    public DWARFExpressionResult evaluate(byte[] exprBytes) throws DWARFExpressionException {
        return this.evaluate(this.readExpr(exprBytes));
    }

    public DWARFExpressionResult evaluate(DWARFExpression _expr, long ... stackArgs) throws DWARFExpressionException {
        for (long l : stackArgs) {
            this.push(l);
        }
        return this.evaluate(_expr);
    }

    public DWARFExpressionResult evaluate(DWARFExpression _expr) throws DWARFExpressionException {
        this.expr = _expr;
        this.currentOp = null;
        int stepCount = 0;
        this.currentOpIndex = 0;
        while (this.currentOpIndex < this.expr.getOpCount()) {
            this.currentOp = this.expr.getOp(this.currentOpIndex);
            try {
                if (stepCount >= this.maxStepCount) {
                    throw new DWARFExpressionException("Excessive expression run length, terminating after " + stepCount + " operations");
                }
                if (Thread.currentThread().isInterrupted()) {
                    throw new DWARFExpressionException("Thread interrupted while evaluating DWARF expression, terminating after " + stepCount + " operations");
                }
                this._preValidateCurrentOp();
                this._evaluateCurrentOp();
            }
            catch (DWARFExpressionException dee) {
                if (dee.getExpression() == null) {
                    dee.setExpression(this.expr);
                    dee.setStep(this.currentOpIndex);
                }
                throw dee;
            }
            ++this.currentOpIndex;
            ++stepCount;
        }
        return new DWARFExpressionResult(this.stack);
    }

    public String getStackAsString() {
        StringBuilder sb = new StringBuilder();
        int stackindex = 0;
        for (Long stackElement : this.stack) {
            sb.append(String.format("%3d: [%08x]  %d\n", stackindex, stackElement, stackElement));
            ++stackindex;
        }
        return sb.toString();
    }

    private void _preValidateCurrentOp() throws DWARFExpressionException {
        int opcode = this.currentOp.getOpCode();
        boolean isLastOperation = this.currentOpIndex == this.expr.getLastActiveOpIndex();
        switch (opcode) {
            case 145: {
                if (this.frameOffset != -1L) break;
                throw new DWARFExpressionException("Frame base has not been set, DW_OP_fbreg can not be evaluated");
            }
            case 6: {
                if (!this.registerLoc && !this.lastStackRelative) {
                    throw new DWARFExpressionException("Can not evaluate DW_OP_deref for non-register location");
                }
                if (isLastOperation) break;
                throw new DWARFExpressionException("Non-terminal DW_OP_deref can't be evaluated");
            }
            default: {
                if ((opcode < 80 || opcode > 111) && opcode != 144 || isLastOperation) break;
                throw new DWARFExpressionException("Non-terminal DW_OP_reg? can't be evaluated");
            }
        }
    }

    private void _evaluateCurrentOp() throws DWARFExpressionException {
        int opcode = this.currentOp.getOpCode();
        if (DWARFExpressionOpCodes.UNSUPPORTED_OPCODES.contains(opcode)) {
            throw new DWARFExpressionException("Can not evaluate unsupported opcode " + DWARFExpressionOpCodes.toString(opcode));
        }
        if (opcode >= 48 && opcode <= 79) {
            this.push(this.currentOp.getRelativeOpCodeOffset(48));
        } else if (opcode >= 112 && opcode <= 143) {
            long offset = this.currentOp.getOperandValue(0);
            this.push(0L + offset);
            this.lastRegister = this.currentOp.getRelativeOpCodeOffset(112);
            if (this.lastRegister == this.registerMappings.getDWARFStackPointerRegNum()) {
                this.lastStackRelative = true;
            } else {
                this.useUnknownRegister = true;
                if (offset == 0L) {
                    this.registerLoc = true;
                }
            }
        } else if (opcode >= 80 && opcode <= 111) {
            this.push(0L);
            this.lastRegister = this.currentOp.getRelativeOpCodeOffset(80);
            this.registerLoc = true;
        } else if (opcode == 144) {
            this.push(0L);
            this.lastRegister = (int)this.currentOp.getOperandValue(0);
            this.registerLoc = true;
        } else {
            switch (opcode) {
                case 3: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    this.push(this.currentOp.getOperandValue(0));
                    break;
                }
                case 145: {
                    this.push(this.frameOffset + this.currentOp.getOperandValue(0));
                    this.lastStackRelative = true;
                    break;
                }
                case 18: {
                    this.push(this.peek());
                    break;
                }
                case 19: {
                    this.pop();
                    break;
                }
                case 21: {
                    long index = this.currentOp.getOperandValue(0);
                    if (index >= (long)this.stack.size()) {
                        throw new DWARFExpressionException("Invalid index for DW_OP_pick: " + index);
                    }
                    this.dw_op_pick((int)index);
                    break;
                }
                case 20: {
                    if (this.stack.size() < 2) {
                        throw new DWARFExpressionException("Not enough items on stack[size=" + this.stack.size() + "] for DW_OP_over");
                    }
                    this.dw_op_pick(1);
                    break;
                }
                case 22: {
                    long firstValue = this.pop();
                    long secondValue = this.pop();
                    this.push(firstValue);
                    this.push(secondValue);
                    break;
                }
                case 23: {
                    long firstValue = this.pop();
                    long secondValue = this.pop();
                    long thirdValue = this.pop();
                    this.push(firstValue);
                    this.push(thirdValue);
                    this.push(secondValue);
                    break;
                }
                case 6: {
                    this.isDeref = true;
                    break;
                }
                case 156: {
                    this.push(this.registerMappings.getCallFrameCFA());
                    this.lastStackRelative = true;
                    break;
                }
                case 25: {
                    this.push(Math.abs(this.pop()));
                    break;
                }
                case 26: {
                    long firstValue = this.pop();
                    long secondValue = this.pop();
                    this.push(firstValue & secondValue);
                    break;
                }
                case 27: {
                    long firstValue = this.pop();
                    long secondValue = this.pop();
                    if (firstValue == 0L) {
                        throw new DWARFExpressionException("Divide by zero");
                    }
                    this.push(secondValue / firstValue);
                    break;
                }
                case 28: {
                    long firstValue = this.pop();
                    long secondValue = this.pop();
                    this.push(secondValue - firstValue);
                    break;
                }
                case 29: {
                    long firstValue = this.pop();
                    long secondValue = this.pop();
                    if (firstValue == 0L) {
                        throw new DWARFExpressionException("Divide by zero");
                    }
                    this.push(secondValue % firstValue);
                    break;
                }
                case 30: {
                    long firstValue = this.pop();
                    long secondValue = this.pop();
                    this.push(firstValue * secondValue);
                    break;
                }
                case 31: {
                    long firstValue = this.pop();
                    this.push(-firstValue);
                    break;
                }
                case 32: {
                    long firstValue = this.pop();
                    this.push(firstValue ^ 0xFFFFFFFFFFFFFFFFL);
                    break;
                }
                case 33: {
                    long firstValue = this.pop();
                    long secondValue = this.pop();
                    this.push(firstValue | secondValue);
                    break;
                }
                case 34: {
                    long firstValue = this.pop();
                    long secondValue = this.pop();
                    this.push(firstValue + secondValue);
                    break;
                }
                case 35: {
                    long firstValue = this.pop();
                    long value = this.currentOp.getOperandValue(0);
                    this.push(firstValue + value);
                    break;
                }
                case 36: {
                    long firstValue = this.pop();
                    long secondValue = this.pop();
                    this.push(secondValue << (int)firstValue);
                    break;
                }
                case 37: {
                    long firstValue = this.pop();
                    long secondValue = this.pop();
                    this.push(secondValue >>> (int)firstValue);
                    break;
                }
                case 38: {
                    long firstValue = this.pop();
                    long secondValue = this.pop();
                    this.push(secondValue >> (int)firstValue);
                    break;
                }
                case 39: {
                    long firstValue = this.pop();
                    long secondValue = this.pop();
                    this.push(firstValue ^ secondValue);
                    break;
                }
                case 44: {
                    long firstValue = this.pop();
                    long secondValue = this.pop();
                    this.push(secondValue <= firstValue ? 1L : 0L);
                    break;
                }
                case 42: {
                    long firstValue = this.pop();
                    long secondValue = this.pop();
                    this.push(secondValue >= firstValue ? 1L : 0L);
                    break;
                }
                case 41: {
                    long firstValue = this.pop();
                    long secondValue = this.pop();
                    this.push(secondValue == firstValue ? 1L : 0L);
                    break;
                }
                case 45: {
                    long firstValue = this.pop();
                    long secondValue = this.pop();
                    this.push(secondValue < firstValue ? 1L : 0L);
                    break;
                }
                case 43: {
                    long firstValue = this.pop();
                    long secondValue = this.pop();
                    this.push(secondValue > firstValue ? 1L : 0L);
                    break;
                }
                case 46: {
                    long firstValue = this.pop();
                    long secondValue = this.pop();
                    this.push(secondValue != firstValue ? 1L : 0L);
                    break;
                }
                case 47: {
                    long destOffset = this.currentOp.getOperandValue(0) + (long)this.currentOp.getOffset();
                    int newStep = this.expr.findOpByOffset(destOffset);
                    if (newStep == -1) {
                        throw new DWARFExpressionException("Invalid skip offset " + destOffset);
                    }
                    this.currentOpIndex = newStep - 1;
                    break;
                }
                case 40: {
                    long destOffset = this.currentOp.getOperandValue(0) + (long)this.currentOp.getOffset();
                    long firstValue = this.pop();
                    if (firstValue == 0L) break;
                    int newStep = this.expr.findOpByOffset(destOffset);
                    if (newStep == -1) {
                        throw new DWARFExpressionException("Invalid bra offset " + destOffset);
                    }
                    this.currentOpIndex = newStep - 1;
                    break;
                }
                case 150: {
                    break;
                }
                case 159: {
                    this.dwarfStackValue = true;
                    break;
                }
                default: {
                    throw new DWARFExpressionException("Unimplemented DWARF expression opcode " + DWARFExpressionOpCodes.toString(opcode));
                }
            }
        }
    }

    private void dw_op_pick(int index) {
        int stackindex = 0;
        for (Long stackElement : this.stack) {
            if (stackindex == index) {
                this.push(stackElement);
                break;
            }
            ++stackindex;
        }
    }

    public String toString() {
        return "DWARFExpressionEvaluator [pointerSize=" + this.pointerSize + ", isLittleEndian=" + this.isLittleEndian + ", frameOffset=" + this.frameOffset + ", lastRegister=" + this.lastRegister + ", lastStackRelative=" + this.lastStackRelative + ", registerLoc=" + this.registerLoc + ", isDeref=" + this.isDeref + ", dwarfStackValue=" + this.dwarfStackValue + ", useUnknownRegister=" + this.useUnknownRegister + "]\nStack:\n" + this.getStackAsString() + "\n" + (this.expr != null ? this.expr.toString(this.currentOpIndex, true, true) : "no expr");
    }

    public int getMaxStepCount() {
        return this.maxStepCount;
    }

    public void setMaxStepCount(int maxStepCount) {
        this.maxStepCount = maxStepCount;
    }

    public boolean isDwarfStackValue() {
        return this.dwarfStackValue;
    }

    public boolean useUnknownRegister() {
        return this.useUnknownRegister;
    }

    public boolean isRegisterLocation() {
        return this.registerLoc;
    }

    public Register getLastRegister() {
        return this.registerMappings.getGhidraReg(this.lastRegister);
    }

    public int getRawLastRegister() {
        return this.lastRegister;
    }

    public boolean isStackRelative() {
        return this.lastStackRelative;
    }
}

